/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.folder.Folder;
import com.novell.gw.message.Note;
import java.util.Date;

public class Appointment
extends Note {
    public static final int ACCEPT_LEVEL_FREE = 160;
    public static final int ACCEPT_LEVEL_TENTATIVE = 190;
    public static final int ACCEPT_LEVEL_BUSY = 210;
    public static final int ACCEPT_LEVEL_OUT_OF_OFFICE = 251;

    private static native int createItem(int var0, int var1);

    private native String getPlace(int var1);

    private native boolean setPlace(int var1, String var2);

    private native boolean hasTimeZone(int var1);

    private native String getTimeZoneName(int var1);

    private native int getEndDate(int var1);

    private native int getDisplayStartDate(int var1);

    private native int getDisplayEndDate(int var1);

    private native boolean setEndDate(int var1, int var2);

    private native boolean resetEndDate(int var1, int var2);

    private native long getDuration(int var1);

    private native boolean setDuration(int var1, long var2);

    private native int getShowAsLevel(int var1);

    private native boolean setShowAsLevel(int var1, int var2, boolean var3);

    public Appointment() {
    }

    Appointment(int n) {
        super(n);
    }

    public Appointment(DataStore dataStore) {
        this(dataStore, null);
    }

    public Appointment(DataStore dataStore, Folder folder) {
        this(Appointment.createItem(dataStore.getPointer(), folder != null ? folder.getPointer() : 0));
    }

    public boolean accept(int n) {
        return this.accept("", n);
    }

    public boolean accept(String string, int n) {
        return super.accept(string, n, this.getShowAsLevel(this.pGWItem));
    }

    public boolean accept(String string, int n, int n2) {
        return super.accept(string, n, n2);
    }

    public boolean decline(int n) {
        return this.decline("", n);
    }

    public boolean decline(String string, int n) {
        return super.decline(string, n, 160, false);
    }

    public boolean decline(String string, int n, int n2, boolean bl) {
        return super.decline(string, n, n2, bl);
    }

    public String getPlace() {
        String string = this.getPlace(this.pGWItem);
        return string;
    }

    public boolean setPlace(String string) {
        boolean bl = this.setPlace(this.pGWItem, string);
        return bl;
    }

    public boolean hasTimeZone() {
        return this.hasTimeZone(this.pGWItem);
    }

    public String getTimeZoneName() {
        return this.getTimeZoneName(this.pGWItem);
    }

    public Date getEndDate() {
        int n = this.getEndDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(n);
        return date;
    }

    public Date getDisplayStartDate() {
        int n = this.getDisplayStartDate(this.pGWItem);
        return EngineUtils.flaimTimeToDate(n);
    }

    public Date getDisplayEndDate() {
        int n = this.getDisplayEndDate(this.pGWItem);
        return EngineUtils.flaimTimeToDate(n);
    }

    public boolean setEndDate(Date date) {
        int n = EngineUtils.DateToFlaimTime(date);
        boolean bl = this.setEndDate(this.pGWItem, n);
        return bl;
    }

    public long getDuration() {
        long l = this.getDuration(this.pGWItem);
        return l;
    }

    public boolean setDuration(long l) {
        boolean bl = this.setDuration(this.pGWItem, l);
        return bl;
    }

    public int getShowAsLevel() {
        int n = this.getShowAsLevel(this.pGWItem);
        return n;
    }

    public boolean setShowAsLevel(int n, boolean bl) {
        boolean bl2 = this.setShowAsLevel(this.pGWItem, n, bl);
        return bl2;
    }

    public boolean setAllDayEvent(boolean bl) {
        return super.setAllDayEvent(bl);
    }
}

