/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.ab.DistributionList;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.message.BusySearchCombinedResult;
import com.novell.gw.message.BusySearchEvent;
import com.novell.gw.message.BusySearchListener;
import com.novell.gw.message.BusySearchRecipientResult;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class BusySearch {
    public static final int MIN_DAYS_TO_SEARCH = 7;
    public static final int MAX_DAYS_TO_SEARCH = 99;
    private int pGWBusySearch = 0;
    private int pEvents = 0;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$novell$gw$message$BusySearchListener;

    private native int subscribeToEvents(int var1) throws EngineException;

    private native int createBusySearch(int var1, int var2) throws EngineException;

    private native int createBusySearchTime(int var1, int var2, int var3, int var4, int var5, int var6) throws EngineException;

    private native void cancelBusySearch(int var1);

    private native int getRecipientSize(int var1) throws EngineException;

    private native int getRecipientResult(int var1, int var2) throws EngineException;

    private native int getCombinedResult(int var1) throws EngineException;

    private native void dispose(int var1, int var2);

    private static native void initIds();

    public BusySearch() {
    }

    public BusySearch(DataStore dataStore, DistributionList distributionList) throws EngineException {
        if (dataStore == null) {
            throw new NullPointerException();
        }
        int n = dataStore.getPointer();
        if (n == 0) {
            throw new NullPointerException();
        }
        int n2 = distributionList.getPointer();
        this.pGWBusySearch = this.createBusySearch(n, n2);
        this.pEvents = this.subscribeToEvents(this.pGWBusySearch);
    }

    public BusySearch(DataStore dataStore, Date date, Date date2, DistributionList distributionList, Date date3, int n) throws EngineException {
        if (dataStore == null) {
            throw new NullPointerException();
        }
        int n2 = dataStore.getPointer();
        if (n2 == 0) {
            throw new NullPointerException();
        }
        int n3 = distributionList.getPointer();
        this.pGWBusySearch = this.createBusySearchTime(n2, EngineUtils.DateToFlaimTime(date), EngineUtils.DateToFlaimTime(date2), n3, EngineUtils.DateToFlaimTime(date3), n);
        this.pEvents = this.subscribeToEvents(this.pGWBusySearch);
    }

    public void addBusySearchListener(BusySearchListener busySearchListener) {
        this.listenerList.add(class$com$novell$gw$message$BusySearchListener == null ? (class$com$novell$gw$message$BusySearchListener = BusySearch.class$("com.novell.gw.message.BusySearchListener")) : class$com$novell$gw$message$BusySearchListener, busySearchListener);
    }

    public void removeBusySearchListener(BusySearchListener busySearchListener) {
        this.listenerList.remove(class$com$novell$gw$message$BusySearchListener == null ? (class$com$novell$gw$message$BusySearchListener = BusySearch.class$("com.novell.gw.message.BusySearchListener")) : class$com$novell$gw$message$BusySearchListener, busySearchListener);
    }

    public BusySearchRecipientResult getRecipientResult(int n) throws EngineException {
        int n2 = this.getRecipientResult(this.pGWBusySearch, n);
        return new BusySearchRecipientResult(n2);
    }

    public BusySearchCombinedResult getCombinedResult() throws EngineException {
        int n = this.getCombinedResult(this.pGWBusySearch);
        return new BusySearchCombinedResult(n);
    }

    public int getRecipientSize() throws EngineException {
        int n = this.getRecipientSize(this.pGWBusySearch);
        return n;
    }

    public Enumeration recipientEnumeration() throws EngineException {
        return new RecipientResultsEnum();
    }

    private void fireBusySearchEvent(int n, int n2, int n3, int n4) {
        final Object[] objectArray = this.listenerList.getListenerList();
        final BusySearchEvent busySearchEvent = new BusySearchEvent(this, n, n2, n3, n4);
        final int n5 = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BusySearch.this.doFireBusySearchEvent(objectArray, busySearchEvent, n5);
            }
        });
    }

    private void doFireBusySearchEvent(Object[] objectArray, BusySearchEvent busySearchEvent, int n) {
        block4: for (int i = 1; i < objectArray.length; i += 2) {
            BusySearchListener busySearchListener = (BusySearchListener)objectArray[i];
            switch (n) {
                case 0: {
                    busySearchListener.moreBusySearchResultsAvailable(busySearchEvent);
                    continue block4;
                }
                case 1: {
                    busySearchListener.busySearchResultsComplete(busySearchEvent);
                    continue block4;
                }
            }
        }
    }

    public void dispose() {
        if (this.pGWBusySearch != 0 || this.pEvents != 0) {
            this.dispose(this.pGWBusySearch, this.pEvents);
            this.pGWBusySearch = 0;
            this.pEvents = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void cancelBusySearch() {
        if (this.pGWBusySearch != 0) {
            this.cancelBusySearch(this.pGWBusySearch);
            this.pGWBusySearch = 0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BusySearch.initIds();
    }

    private class RecipientResultsEnum
    implements Enumeration {
        private int index = 0;

        private RecipientResultsEnum() {
        }

        public boolean hasMoreElements() {
            boolean bl = false;
            try {
                bl = this.index < BusySearch.this.getRecipientSize();
            }
            catch (EngineException engineException) {
                // empty catch block
            }
            return bl;
        }

        public Object nextElement() {
            BusySearchRecipientResult busySearchRecipientResult = null;
            try {
                busySearchRecipientResult = BusySearch.this.getRecipientResult(this.index++);
            }
            catch (EngineException engineException) {
                // empty catch block
            }
            return busySearchRecipientResult;
        }
    }
}

