/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.ab.Recipient;
import com.novell.gw.engine.EngineException;
import com.novell.gw.message.BusySearchTimeBlock;
import java.util.Enumeration;

public class BusySearchRecipientResult {
    public static final int BUSYSEARCH_USERSTATUS_COMPLETE = 0;
    public static final int BUSYSEARCH_USERSTATUS_FAILED = 1;
    public static final int BUSYSEARCH_USERSTATUS_STILLWORKING = 2;
    public static final int BUSYSEARCH_AVAILABLE = 0;
    public static final int BUSYSEARCH_TENTATIVE = 1;
    public static final int BUSYSEARCH_COMMITTED = 2;
    public static final int BUSYSEARCH_OUTOFOFFICE = 3;
    public static final int BUSYSEARCH_WORKSCHEDULE = 4;
    private int pGWRecResult = 0;
    private Recipient m_Recipient = null;

    private native int getRecipient(int var1) throws EngineException;

    private native int getRecipientStatus(int var1) throws EngineException;

    private native int getRecipientTimeBlock(int var1, int var2) throws EngineException;

    private native int getRecipientTimeBlockSize(int var1) throws EngineException;

    private native void dispose(int var1);

    public BusySearchRecipientResult() {
        this.pGWRecResult = 0;
    }

    BusySearchRecipientResult(int n) throws EngineException {
        this.pGWRecResult = n;
        if (n == 0) {
            throw new NullPointerException();
        }
    }

    public Recipient getRecipient() throws EngineException {
        if (this.m_Recipient == null) {
            int n = this.getRecipient(this.pGWRecResult);
            this.m_Recipient = new Recipient(n);
        }
        return this.m_Recipient;
    }

    public int getRecipientStatus() throws EngineException {
        int n = 2;
        n = this.getRecipientStatus(this.pGWRecResult);
        return n;
    }

    public BusySearchTimeBlock getRecipientTimeBlock(int n) throws EngineException {
        int n2 = this.getRecipientTimeBlock(this.pGWRecResult, n);
        return new BusySearchTimeBlock(n2);
    }

    public int getRecipientTimeBlockSize() throws EngineException {
        int n = this.getRecipientTimeBlockSize(this.pGWRecResult);
        return n;
    }

    public Enumeration recipientTimeBlockEnumeration() throws EngineException {
        return new RecipientTimeBlockEnum();
    }

    public void dispose() {
        if (this.pGWRecResult != 0) {
            this.dispose(this.pGWRecResult);
            this.pGWRecResult = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private class RecipientTimeBlockEnum
    implements Enumeration {
        private int index = 0;

        private RecipientTimeBlockEnum() {
        }

        public boolean hasMoreElements() {
            boolean bl = false;
            try {
                bl = this.index < BusySearchRecipientResult.this.getRecipientTimeBlockSize();
            }
            catch (EngineException engineException) {
                // empty catch block
            }
            return bl;
        }

        public Object nextElement() {
            BusySearchTimeBlock busySearchTimeBlock = null;
            try {
                busySearchTimeBlock = BusySearchRecipientResult.this.getRecipientTimeBlock(this.index++);
            }
            catch (EngineException engineException) {
                // empty catch block
            }
            return busySearchTimeBlock;
        }
    }
}

