/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.folder.Folder;
import com.novell.gw.message.Note;
import java.util.Date;

public class Task
extends Note {
    private static native int createItem(int var0, int var1);

    private native int getAssignedDate(int var1);

    private native int getDueDate(int var1);

    private native boolean setDueDate(int var1, int var2);

    private native int getTaskCategory(int var1);

    private native boolean setTaskCategory(int var1, char var2);

    private native int getTaskPriority(int var1);

    private native boolean setTaskPriority(int var1, int var2);

    private native boolean setNotifyWhenCompleted(int var1, int var2);

    public Task() {
    }

    Task(int n) {
        super(n);
    }

    public Task(DataStore dataStore) {
        this(dataStore, null);
    }

    public Task(DataStore dataStore, Folder folder) {
        this(Task.createItem(dataStore.getPointer(), folder != null ? folder.getPointer() : 0));
    }

    public Date getAssignedDate() {
        int n = this.getAssignedDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(n);
        return date;
    }

    public Date getDueDate() {
        int n = this.getDueDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(n);
        return date;
    }

    public boolean setDueDate(Date date) {
        int n = EngineUtils.DateToFlaimTime(date);
        boolean bl = this.setDueDate(this.pGWItem, n);
        return bl;
    }

    public char getTaskCategory() {
        return (char)this.getTaskCategory(this.pGWItem);
    }

    public boolean setTaskCategory(char c) {
        boolean bl = this.setTaskCategory(this.pGWItem, c);
        return bl;
    }

    public int getTaskPriority() {
        return this.getTaskPriority(this.pGWItem);
    }

    public boolean setTaskPriority(int n) {
        boolean bl = this.setTaskPriority(this.pGWItem, n);
        return bl;
    }

    public boolean setNotifyWhenCompleted(int n) {
        boolean bl = this.setNotifyWhenCompleted(this.pGWItem, n);
        return bl;
    }
}

