/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.rules;

import com.novell.gw.ab.DistributionList;
import com.novell.gw.engine.DataStore;
import com.novell.gw.folder.Folder;
import com.novell.gw.rules.RuleActionAccept;
import com.novell.gw.rules.RuleActionArchive;
import com.novell.gw.rules.RuleActionDelegate;
import com.novell.gw.rules.RuleActionDelete;
import com.novell.gw.rules.RuleActionForward;
import com.novell.gw.rules.RuleActionLink;
import com.novell.gw.rules.RuleActionMarkPrivate;
import com.novell.gw.rules.RuleActionMarkRead;
import com.novell.gw.rules.RuleActionMarkUnread;
import com.novell.gw.rules.RuleActionMove;
import com.novell.gw.rules.RuleActionReply;
import com.novell.gw.rules.RuleActionSend;
import com.novell.gw.rules.RuleActionStop;

public class RuleAction {
    protected static final int RULE_ACTION_TYPE_ACCEPT = 1;
    protected static final int RULE_ACTION_TYPE_ARCHIVE = 2;
    protected static final int RULE_ACTION_TYPE_DELETE = 3;
    protected static final int RULE_ACTION_TYPE_FORWARD = 4;
    protected static final int RULE_ACTION_TYPE_MOVE = 5;
    protected static final int RULE_ACTION_TYPE_PURGE = 6;
    protected static final int RULE_ACTION_TYPE_LINK = 7;
    protected static final int RULE_ACTION_TYPE_REPLY = 8;
    protected static final int RULE_ACTION_TYPE_SEND = 10;
    protected static final int RULE_ACTION_TYPE_DELEGATE = 11;
    protected static final int RULE_ACTION_TYPE_PRIVATE = 13;
    protected static final int RULE_ACTION_TYPE_STOPRULES = 16;
    protected static final int RULE_ACTION_TYPE_READ = 17;
    protected static final int RULE_ACTION_TYPE_UNREAD = 18;
    protected static final int RULE_ACTION_TYPE_REPLY_WITH_TEXT = 19;
    private int pRuleAction = 0;

    private native void dispose(int var1);

    private native int getAcceptLevel(int var1);

    private native String getActionName(int var1);

    private static native int getActionType(int var0);

    private native int getDistributionList(int var1);

    private native String getAttachments(int var1);

    private native String getComment(int var1);

    private native String getFromText(int var1);

    private native int getFolder(int var1);

    private native String getMessageText(int var1);

    private native boolean getReplyIncludeMessage(int var1);

    private native int getReplyOptions(int var1);

    private native String getSubjectText(int var1);

    private native boolean isEditable(int var1);

    private native void setAcceptLevel(int var1, int var2);

    private native void setAddressList(int var1, int var2);

    private native void setAttachments(int var1, String var2);

    private native void setComment(int var1, String var2);

    private native void setFromText(int var1, String var2);

    private native void setFolder(int var1, int var2);

    private native void setMessageText(int var1, String var2);

    private native void setReplyIncludeMessage(int var1, boolean var2);

    private native void setReplyOptions(int var1, int var2);

    private native void setSubjectText(int var1, String var2);

    public RuleAction() {
    }

    protected RuleAction(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pRuleAction = n;
    }

    static RuleAction createRuleAction(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        int n2 = RuleAction.getActionType(n);
        if (n2 == 1) {
            return new RuleActionAccept(n);
        }
        if (n2 == 2) {
            return new RuleActionArchive(n);
        }
        if (n2 == 11) {
            return new RuleActionDelegate(n);
        }
        if (n2 == 3) {
            return new RuleActionDelete(n);
        }
        if (n2 == 4) {
            return new RuleActionForward(n);
        }
        if (n2 == 7) {
            return new RuleActionLink(n);
        }
        if (n2 == 13) {
            return new RuleActionMarkPrivate(n);
        }
        if (n2 == 5) {
            return new RuleActionMove(n);
        }
        if (n2 == 6) {
            return new RuleActionDelete(n);
        }
        if (n2 == 17) {
            return new RuleActionMarkRead(n);
        }
        if (n2 == 8 || n2 == 19) {
            return new RuleActionReply(n);
        }
        if (n2 == 10) {
            return new RuleActionSend(n);
        }
        if (n2 == 16) {
            return new RuleActionStop(n);
        }
        if (n2 == 18) {
            return new RuleActionMarkUnread(n);
        }
        return new RuleAction(n);
    }

    public boolean isEditable() {
        return this.isEditable(this.pRuleAction);
    }

    protected int getAcceptLevel() {
        return this.getAcceptLevel(this.pRuleAction);
    }

    protected void setAcceptLevel(int n) {
        this.setAcceptLevel(this.pRuleAction, n);
    }

    protected String getAttachments() {
        return this.getAttachments(this.pRuleAction);
    }

    protected void setAttachments(String string) {
        this.setAttachments(this.pRuleAction, string);
    }

    protected String getCommentToSender() {
        return this.getComment(this.pRuleAction);
    }

    protected void setCommentToSender(String string) {
        this.setComment(this.pRuleAction, string);
    }

    protected DistributionList getDistributionList() {
        DistributionList distributionList = null;
        int n = this.getDistributionList(this.pRuleAction);
        if (n != 0) {
            distributionList = new DistributionList(n);
        }
        return distributionList;
    }

    protected void setDistributionList(DistributionList distributionList) {
        this.setAddressList(this.pRuleAction, distributionList.getPointer());
    }

    protected String getFrom() {
        return this.getFromText(this.pRuleAction);
    }

    protected void setFrom(String string) {
        this.setFromText(this.pRuleAction, string);
    }

    protected Folder getFolder() {
        Folder folder = null;
        int n = this.getFolder(this.pRuleAction);
        if (n != 0) {
            folder = DataStore.getFolder(n);
        }
        return folder;
    }

    protected void setFolder(Folder folder) {
        if (folder != null) {
            this.setFolder(this.pRuleAction, folder.getPointer());
        }
    }

    protected String getMessage() {
        return this.getMessageText(this.pRuleAction);
    }

    protected void setMessage(String string) {
        this.setMessageText(this.pRuleAction, string);
    }

    public String getName() {
        return this.getActionName(this.pRuleAction);
    }

    protected boolean getReplyIncludeMessage() {
        return this.getReplyIncludeMessage(this.pRuleAction);
    }

    protected void setReplyIncludeMessage(boolean bl) {
        this.setReplyIncludeMessage(this.pRuleAction, bl);
    }

    protected int getReplyToOptionsMask() {
        return this.getReplyOptions(this.pRuleAction);
    }

    protected void setReplyToOptionsMask(int n) {
        this.setReplyOptions(this.pRuleAction, n);
    }

    protected String getSubject() {
        return this.getSubjectText(this.pRuleAction);
    }

    protected void setSubject(String string) {
        this.setSubjectText(this.pRuleAction, string);
    }

    public int getPointer() {
        return this.pRuleAction;
    }

    public String toString() {
        return this.getName();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.pRuleAction != 0) {
            this.dispose(this.pRuleAction);
            this.pRuleAction = 0;
        }
    }
}

