/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.rules;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.folder.Folder;
import com.novell.gw.rules.Rule;
import java.util.NoSuchElementException;

public class RuleList {
    private int pRuleArray = 0;
    private Rule[] rules;

    private native int addRule(int var1, int var2, int var3);

    private native int copyRule(int var1, int var2);

    private static native int create(int var0);

    private native boolean deleteRule(int var1, int var2);

    private native void dispose(int var1);

    private native void enableRule(int var1, int var2);

    private native void executeRule(int var1, int var2);

    private native void executeRule(int var1, int var2, int var3);

    private native void executeRule(int var1, int var2, int[] var3);

    private static native int get(int var0);

    private native int getRulePtrAt(int var1, int var2);

    private native int getSize(int var1);

    private native void moveRules(int var1, int var2, int var3, int var4);

    private native void moveRule(int var1, int var2, int var3);

    private native boolean saveRule(int var1, int var2);

    public RuleList() {
    }

    private RuleList(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pRuleArray = n;
        int n2 = this.getSize(n);
        this.rules = new Rule[n2];
    }

    private RuleList(DataStore dataStore) {
        this(RuleList.create(dataStore.getPointer()));
    }

    public static RuleList get(DataStore dataStore) {
        return new RuleList(RuleList.get(dataStore.getPointer()));
    }

    private Rule createRuleAt(int n) {
        int n2 = this.getRulePtrAt(this.pRuleArray, n);
        if (n2 == 0) {
            throw new NoSuchElementException();
        }
        return new Rule(n2);
    }

    public int addRule(Rule rule, int n) {
        int n2 = -1;
        if (rule != null) {
            n2 = this.addRule(this.pRuleArray, rule.getPointer(), n);
        }
        return n2;
    }

    public Rule copyRule(int n) {
        return new Rule(this.copyRule(this.pRuleArray, n));
    }

    public boolean deleteRule(int n) {
        return this.deleteRule(this.pRuleArray, n);
    }

    public void enableRule(int n) {
        this.enableRule(this.pRuleArray, n);
    }

    public void executeRule(int n) {
        this.executeRule(this.pRuleArray, n);
    }

    public void executeRule(int n, Folder folder) {
        this.executeRule(this.pRuleArray, n, folder != null ? folder.getPointer() : 0);
    }

    public void executeRule(int n, Item[] itemArray) {
        this.executeRule(this.pRuleArray, n, ItemList.getPointers(itemArray));
    }

    public Rule getRuleAt(int n) {
        Rule rule = null;
        if (this.rules.length > 0 && (rule = this.rules[n]) == null) {
            this.rules[n] = rule = this.createRuleAt(n);
        }
        return rule;
    }

    public int getSize() {
        int n = 0;
        if (this.rules != null) {
            n = this.rules.length;
        }
        return n;
    }

    public void moveRule(int n, int n2) {
        this.moveRules(n, n2, 1);
    }

    public void moveRule(Rule rule, int n) {
        if (rule != null) {
            this.moveRule(this.pRuleArray, rule.getPointer(), n);
        }
    }

    public void moveRules(int n, int n2, int n3) {
        this.moveRules(this.pRuleArray, n, n2, n3);
    }

    public boolean saveRule(int n) {
        return this.saveRule(this.pRuleArray, n);
    }

    public void toggleRuleStatus(int n) {
        this.enableRule(n);
    }

    public void dispose() {
        if (this.pRuleArray != 0) {
            this.dispose(this.pRuleArray);
            this.pRuleArray = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

