/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.CompiledTLex;
import azcheck.engine.DictionaryManager;
import azcheck.engine.SpellException;
import azcheck.engine.TLex;
import azcheck.engine.TLexRules;
import azcheck.util.CLOptions;
import azcheck.util.CharSequence;
import azcheck.util.DataWriter;
import azcheck.util.QuickSort;
import azcheck.util.StringBufferCharSeq;
import azcheck.util.StringCharSeq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;

public class CompiledTLexBuilder
extends TLex {
    Node tree_;
    DataWriter dataOut_;
    DictionaryManager dman_;
    String line_;
    int lineNum_;
    Suffix[] suffixes_;
    HashMap suffixMap_ = new HashMap();
    StringBuffer suffixBuffer_ = new StringBuffer(100);
    boolean suffixEnabled_ = true;
    int trace_ = 0;
    int wasted_;
    static final byte WORD_SHARED = 4;
    static final int MAX_SUFFIX = 128;
    byte[] encodedWord_ = new byte[256];
    private static String USAGE = "builder <options> <files>.. [ -sub <files>... ]\n  options:\n\t-rules <rule_file>\n\t-freq <frequent_word_file>\n\t-prefixes <prefix_file>\n\t-cs <coding_system>\n\t-dump <dump_file>\n\t-o <output.cdi>\n";

    public CompiledTLexBuilder() {
        super("");
        try {
            this.defineWordChars("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", 0);
            this.defineWordChars("0123456789", 1);
            this.defineWordChars("-.'", 3);
            this.defineWordChars(":", 3);
            this.defineWordChars("@\\", 2);
            this.defineWordChars("_/", 0);
            byte cost = 7;
            for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                char u = Character.toUpperCase(c);
                this.addCloseCharacter(this.encode(c), this.encode(u), cost);
                this.addCloseCharacter(this.encode(u), this.encode(c), cost);
            }
        }
        catch (SpellException e) {
            e.printStackTrace();
        }
        this.tree_ = new Node(0);
    }

    boolean addWord(String word) {
        StringCharSeq seq = new StringCharSeq(word);
        return this.addWord(seq, TLex.capType(seq, 0, seq.length()));
    }

    boolean addWord(StringBuffer word) {
        StringBufferCharSeq seq = new StringBufferCharSeq(word);
        return this.addWord(seq, TLex.capType(seq, 0, seq.length()));
    }

    boolean addWord(CharSequence word, byte type) {
        boolean tolower = type != 3;
        int L = word.length();
        for (int i = 0; i < L; ++i) {
            char c = word.charAt(i);
            byte b = this.encode(tolower ? Character.toLowerCase(c) : c);
            if (b == -1) {
                return false;
            }
            this.encodedWord_[i] = b;
        }
        return this.addWord(this.encodedWord_, L, type);
    }

    private boolean addWord(byte[] word, int length, byte type) {
        Node r = this.tree_;
        for (int i = 0; i < length; ++i) {
            r = r.getChild(word[i], true);
        }
        byte flags = CompiledTLexBuilder.wordFlags(type);
        if (r.type_ == 0 || CompiledTLexBuilder.getWordType(r.type_) > type) {
            r.type_ = flags;
        }
        return true;
    }

    void subtractWord(CharSequence word) {
        int L = word.length();
        boolean tolower = TLex.capType(word, 0, L) != 3;
        Node r = this.tree_;
        for (int i = 0; i < L; ++i) {
            char c = word.charAt(i);
            byte b = this.encode(tolower ? Character.toLowerCase(c) : c);
            if (b == -1) {
                return;
            }
            if ((r = r.getChild(b, false)) != null) continue;
            return;
        }
        r.type_ = 0;
    }

    boolean frequentWord(String word) {
        int L = word.length();
        boolean tolower = TLex.capType(new StringCharSeq(word), 0, L) != 3;
        Node r = this.tree_;
        for (int i = 0; i < L; ++i) {
            char c = word.charAt(i);
            byte b = this.encode(tolower ? Character.toLowerCase(c) : c);
            if (b == -1) {
                return false;
            }
            Node oldN = r;
            if ((r = r.getChild(b, false)) != null) continue;
            return false;
        }
        r.type_ = (byte)(r.type_ | 8);
        return true;
    }

    boolean prefixWord(String word) {
        int L = word.length();
        Node r = this.tree_;
        for (int i = 0; i < L; ++i) {
            char c = word.charAt(i);
            byte b = this.encode(Character.toLowerCase(c));
            if (b == -1) {
                return false;
            }
            r = r.getChild(b, true);
        }
        r.type_ = (byte)(r.type_ | 0x11);
        return true;
    }

    void parseRules(LineNumberReader input) throws IOException, SpellException {
        String[] tokens = new String[100];
        block0: while (true) {
            this.line_ = input.readLine();
            this.lineNum_ = input.getLineNumber();
            if (this.line_ == null) break;
            StringTokenizer tkn = new StringTokenizer(this.line_);
            int ntoken = 0;
            while (tkn.hasMoreTokens()) {
                tokens[ntoken] = tkn.nextToken();
                if (tokens[ntoken].charAt(0) == '#') break;
                ++ntoken;
            }
            if (ntoken == 0) continue;
            if (tokens[0].equals("%chars")) {
                if (ntoken != 2) {
                    this.parseError("expecting one string");
                }
                this.defineWordChars(tokens[1], 0);
                continue;
            }
            if (tokens[0].equals("%recode")) {
                if (ntoken != 3) {
                    this.parseError("expecting a character and an hexadecimal code");
                }
                this.defineRecoding(tokens[1].charAt(0), Integer.parseInt(tokens[2], 16));
                continue;
            }
            if (tokens[0].equals("%noninitial")) {
                if (ntoken != 2) {
                    this.parseError("expecting one string");
                }
                this.defineWordChars(tokens[1], 1);
                continue;
            }
            if (tokens[0].equals("%nonfinal")) {
                if (ntoken != 2) {
                    this.parseError("expecting one string");
                }
                this.defineWordChars(tokens[1], 2);
                continue;
            }
            if (tokens[0].equals("%compoundmin")) {
                if (ntoken != 2) {
                    this.parseError("expecting one integer");
                    continue;
                }
                this.compoundMin_ = Integer.parseInt(tokens[1]);
                continue;
            }
            if (tokens[0].equals("%kbline")) {
                if (ntoken != 2) {
                    this.parseError("expecting one string");
                }
                String kbline = tokens[1];
                int c = kbline.length();
                while (true) {
                    if (--c <= 0) continue block0;
                    byte b1 = this.encode(kbline.charAt(c - 1));
                    byte b2 = this.encode(kbline.charAt(c));
                    if (b1 == -1 || b2 == -1) {
                        this.parseError("illegal characters");
                    }
                    this.addCloseCharacter(b1, b2, (byte)13);
                    this.addCloseCharacter(b2, b1, (byte)13);
                }
            }
            if (tokens[0].equals("%pattern")) {
                if (ntoken == 2) continue;
                this.parseError("expecting string");
                continue;
            }
            if (tokens[0].startsWith("%mistake")) {
                int cost = this.parseModifiedCost(tokens[0], 10, 3);
                int t1 = 1;
                while (true) {
                    if (t1 >= ntoken) continue block0;
                    for (int t2 = 1; t2 < ntoken; ++t2) {
                        this.storeMistake(tokens[t1], tokens[t2], cost);
                    }
                    ++t1;
                }
            }
            this.parseError("illegal line");
        }
    }

    void generate(String path) throws IOException {
        System.out.println(Node.tcount + " nodes");
        this.shareSuffixes();
        this.dataOut_ = new DataWriter(path);
        this.dataOut_.setLength(0L);
        this.dataOut_.write(new byte[256]);
        int mainRoot = this.save();
        this.dataOut_.seek(0L);
        this.dataOut_.write(CompiledTLex.MAGIC);
        this.dataOut_.write(1);
        this.dataOut_.write(3);
        this.dataOut_.fixedInt(mainRoot, 4);
        this.dataOut_.fixedInt(this.compoundMin_, 4);
        this.dataOut_.close();
    }

    void dumpWords(Writer output) {
        this.dumpWords(this.tree_, output);
    }

    void defineWordChars(String chars, int flags) throws SpellException {
        for (int i = 0; i < chars.length(); ++i) {
            TLexRules.CProps prop = this.defineWordChar(chars.charAt(i));
            prop.flags = (byte)(prop.flags | (byte)flags);
        }
    }

    private int parseModifiedCost(String key, int basis, int incr) {
        int cost = basis;
        int m = key.length();
        while (--m > 0) {
            if (key.charAt(m) == '-') {
                cost += incr;
                continue;
            }
            if (key.charAt(m) != '+') break;
            cost -= incr;
        }
        return cost;
    }

    private void storeMistake(String seq1, String seq2, int cost) throws SpellException {
        int ruleLLen;
        byte[] bseq2;
        if (seq1.equals(seq2)) {
            return;
        }
        byte[] bseq1 = this.encode(seq1, true);
        if (bseq1 == null) {
            this.parseError(" illegal sequence <" + seq1 + ">");
        }
        if ((bseq2 = this.encode(seq2, true)) == null) {
            this.parseError(" illegal sequence <" + seq2 + ">");
        }
        if (bseq1.length == 1 && bseq2.length == 1) {
            this.addCloseCharacter(bseq1[0], bseq2[0], (byte)cost);
            return;
        }
        TLexRules.CProps props = this.getChar(bseq1[0]);
        TLexRules.MRule crule = props.mistRules;
        TLexRules.MRule last = null;
        while (!(crule == null || (ruleLLen = crule.itemSize(0)) < bseq1.length || ruleLLen == bseq1.length && crule.itemEquals(0, bseq1))) {
            last = crule;
            crule = crule.next;
        }
        if (crule == null || !crule.itemEquals(0, bseq1)) {
            TLexRules.MRule nrule = new TLexRules.MRule(bseq1, crule);
            if (last == null) {
                props.mistRules = nrule;
            } else {
                last.next = nrule;
            }
            crule = nrule;
        }
        crule.addItem(bseq2, cost);
    }

    private void parseError(String msg) throws SpellException {
        throw new SpellException(" [" + this.lineNum_ + "] " + msg + " in: " + this.line_, this.lineNum_);
    }

    private int save() throws IOException {
        int charTableOffset = (int)this.dataOut_.getFilePointer();
        for (int c = 0; c < 256; ++c) {
            TLexRules.CProps props = this.charTable_[c];
            if (props == null) {
                this.dataOut_.fixedInt(0, 2);
                continue;
            }
            this.dataOut_.fixedInt(props.xvalue, 2);
            this.dataOut_.write(props.code);
            this.dataOut_.write(props.flags);
            this.dataOut_.byteArray(props.closeFriends);
            int ncr = 0;
            TLexRules.MRule conf = props.mistRules;
            while (conf != null) {
                ++ncr;
                conf = conf.next;
            }
            this.dataOut_.fixedInt(ncr, 2);
            conf = props.mistRules;
            while (conf != null) {
                this.dataOut_.byteArray(conf.data);
                conf = conf.next;
            }
        }
        this.generateTree(this.tree_);
        this.suffixEnabled_ = false;
        for (int s = 0; s < this.suffixes_.length; ++s) {
            Suffix suffix = this.suffixes_[s];
            this.generateTree(suffix.instance);
            suffix.offset = suffix.instance.offset_;
        }
        int sharedSuffixesOffset = (int)this.dataOut_.getFilePointer();
        this.dataOut_.fixedInt(this.suffixes_.length, 4);
        for (int s = 0; s < this.suffixes_.length; ++s) {
            this.dataOut_.fixedInt(this.suffixes_[s].offset, 4);
        }
        int controlOffset = (int)this.dataOut_.getFilePointer();
        this.dataOut_.fixedInt(this.tree_.offset_, 4);
        this.dataOut_.fixedInt(charTableOffset, 4);
        this.dataOut_.fixedInt(sharedSuffixesOffset, 4);
        return controlOffset;
    }

    private void generateTree(Node head) throws IOException {
        int kidCnt = 0;
        int kidByteCnt = 0;
        int needed = 0;
        if (head.kids_ == null) {
            return;
        }
        Suffix suffix = null;
        if (this.suffixEnabled_ && head.shareKey != null && (suffix = (Suffix)this.suffixMap_.get(head.shareKey)) != null) {
            return;
        }
        Node kid = head.kids_;
        while (kid != null) {
            this.generateTree(kid);
            ++kidCnt;
            kid = kid.next_;
        }
        head.offset_ = (int)this.dataOut_.getFilePointer();
        this.dataOut_.write(kidCnt);
        kid = head.kids_;
        while (kid != null) {
            int bc;
            this.dataOut_.write(kid.ch_);
            int kc = this.kidCoding(kid, head);
            int n = kc < 256 ? 1 : (kc < 65536 ? 2 : (bc = kc < 0x1000000 ? 3 : 4));
            if (bc > kidByteCnt) {
                kidByteCnt = bc;
            }
            needed += bc;
            kid = kid.next_;
        }
        this.dataOut_.write((head.type_ << 2) + (kidByteCnt - 1));
        kid = head.kids_;
        while (kid != null) {
            this.dataOut_.fixedInt(this.kidCoding(kid, head), kidByteCnt);
            kid = kid.next_;
        }
        this.wasted_ += kidByteCnt * kidCnt - needed;
    }

    private int kidCoding(Node kid, Node parent) {
        Suffix suffix = null;
        if (this.suffixEnabled_ && kid.shareKey != null && (suffix = (Suffix)this.suffixMap_.get(kid.shareKey)) != null) {
            if (this.trace_ > 1) {
                System.err.println(" shared node -> " + suffix.code);
                this.dumpWords(kid, new BufferedWriter(new OutputStreamWriter(System.err)));
            }
            return (suffix.code << 2) + 3;
        }
        if (kid.kids_ == null) {
            return (kid.type_ << 2) + 1;
        }
        return parent.offset_ - kid.offset_ << 1;
    }

    void dumpWords(Node node, Writer output) {
        boolean asis = true;
        try {
            Iterator it = new Iterator(node);
            byte[] buffer = new byte[200];
            int L = 0;
            while ((L = it.getNextWord(buffer)) >= 0) {
                int cap = CompiledTLexBuilder.getWordType(it.getFlags());
                for (int i = 0; i < L; ++i) {
                    char c = this.decode(buffer[i]);
                    if (asis) {
                        output.write(c);
                        continue;
                    }
                    output.write(cap == 2 || cap == 1 && i == 0 ? Character.toUpperCase(c) : c);
                }
                output.write(10);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void shareSuffixes() throws IOException {
        Object suff;
        this.detectSharing(this.tree_, 0);
        Object[] tsuffixes = new Suffix[this.suffixMap_.size()];
        int nsuff = 0;
        java.util.Iterator iter = this.suffixMap_.values().iterator();
        while (iter.hasNext()) {
            tsuffixes[nsuff++] = (Suffix)iter.next();
        }
        QuickSort.Compare comp = new QuickSort.Compare(){

            public int compare(Object o1, Object o2) {
                Suffix s1 = (Suffix)o1;
                Suffix s2 = (Suffix)o2;
                return s2.key.length() * (s2.frequency - 1) - s1.key.length() * (s1.frequency - 1);
            }
        };
        QuickSort.sort(tsuffixes, comp);
        if (this.trace_ > 0) {
            System.err.println(nsuff + " suffixes found");
        }
        this.suffixes_ = new Suffix[nsuff < 128 ? nsuff : 128];
        int s = 0;
        while (s < nsuff && s < 128) {
            suff = tsuffixes[s];
            if (this.trace_ > 1) {
                System.out.println(((Suffix)suff).key + "\t" + ((Suffix)suff).frequency + "\t" + ((Suffix)suff).key.length() * (((Suffix)suff).frequency - 1));
            }
            this.suffixes_[s] = suff;
            ((Suffix)suff).code = s++;
        }
        for (s = 128; s < nsuff; ++s) {
            suff = tsuffixes[s];
            this.suffixMap_.remove(((Suffix)suff).key);
        }
    }

    private int detectSharing(Node node, int depth) {
        int leaveCnt = 0;
        if (node.kids_ == null) {
            return 1;
        }
        byte[] buffer = new byte[100];
        Node kid = node.kids_;
        while (kid != null) {
            int kidLeaves = this.detectSharing(kid, depth + 1);
            leaveCnt += kidLeaves;
            if (kidLeaves > 2 && kidLeaves < 50 && depth > 0) {
                Iterator it = new Iterator(kid);
                this.suffixBuffer_.setLength(0);
                int L = 0;
                boolean tLen = false;
                while ((L = it.getNextWord(buffer)) >= 0) {
                    for (int i = 0; i < L; ++i) {
                        this.suffixBuffer_.append(this.decode(buffer[i]));
                    }
                    this.suffixBuffer_.append((char)(48 + it.getFlags()));
                    this.suffixBuffer_.append('/');
                }
                String key = this.suffixBuffer_.toString();
                Suffix suff = (Suffix)this.suffixMap_.get(key);
                if (suff != null) {
                    ++suff.frequency;
                    kid.shareKey = suff.key;
                } else {
                    suff = new Suffix();
                    this.suffixMap_.put(key, suff);
                    suff.instance = kid;
                    kid.shareKey = suff.key = key;
                }
            }
            kid = kid.next_;
        }
        if (CompiledTLexBuilder.actualWord(node.type_)) {
            ++leaveCnt;
        }
        return leaveCnt;
    }

    static LineNumberReader openFile(String path, String coding) throws IOException {
        InputStreamReader r = coding != null ? new InputStreamReader((InputStream)new FileInputStream(path), coding) : new FileReader(path);
        return new LineNumberReader(r);
    }

    boolean processCompiledFile(String path, boolean subtract) throws SpellException {
        try {
            if (this.dman_ == null) {
                this.dman_ = new DictionaryManager(".");
            }
            if (path.indexOf(58) < 2) {
                path = "file:" + path;
            }
            CompiledTLex ctl = (CompiledTLex)this.dman_.load(new URL(path), null);
            final boolean isubtract = subtract;
            try {
                final StringBufferCharSeq seq = new StringBufferCharSeq();
                ctl.visit(new TLex.Visitor(){

                    public void getWord(char[] word, int length, int cap, int node) {
                        seq.buffer.setLength(0);
                        for (int i = 0; i < length; ++i) {
                            seq.buffer.append(word[i]);
                        }
                        seq.length = length;
                        if (isubtract) {
                            CompiledTLexBuilder.this.subtractWord(seq);
                        } else if (!CompiledTLexBuilder.this.addWord(seq, (byte)cap)) {
                            System.err.println("word rejected: " + seq.buffer);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("** error while reading compiled dictionary: " + e.getMessage());
                e.printStackTrace();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    void processTextFile(String path, String coding, boolean subtract) throws IOException {
        LineNumberReader input = CompiledTLexBuilder.openFile(path, coding);
        StringBuffer word = new StringBuffer();
        int cc = ((BufferedReader)input).read();
        while (cc > 0) {
            if (Character.isWhitespace((char)cc)) {
                cc = ((BufferedReader)input).read();
                continue;
            }
            if (cc == 35) {
                while (cc > 0 && cc != 10) {
                    cc = ((BufferedReader)input).read();
                }
                continue;
            }
            word.setLength(0);
            while (cc > 0 && !Character.isWhitespace((char)cc)) {
                word.append((char)cc);
                cc = ((BufferedReader)input).read();
            }
            if (subtract) {
                this.subtractWord(new StringBufferCharSeq(word));
                continue;
            }
            if (this.addWord(word)) continue;
            System.err.println("word rejected: " + word);
        }
    }

    public static void main(String[] args) {
        try {
            Object dict = null;
            String out = null;
            String coding = null;
            String dump = null;
            LineNumberReader rules = null;
            LineNumberReader freqw = null;
            LineNumberReader prefixes = null;
            int trace = 0;
            int dargc = 0;
            int verbosity = 0;
            CLOptions options = new CLOptions(args, USAGE);
            while (options.more()) {
                if (options.withArg("-o")) {
                    out = options.getArg();
                    continue;
                }
                if (options.withoutArg("-trace")) {
                    trace = 1;
                    continue;
                }
                if (options.withArg("-verbose")) {
                    verbosity = options.getIntArg();
                    continue;
                }
                if (options.withArg("-cs")) {
                    coding = options.getArg();
                    continue;
                }
                if (options.withArg("-dump")) {
                    dump = options.getArg();
                    continue;
                }
                if (options.withArg("-hints")) {
                    rules = CompiledTLexBuilder.openFile(options.getArg(), coding);
                    continue;
                }
                if (options.withArg("-freq")) {
                    freqw = CompiledTLexBuilder.openFile(options.getArg(), coding);
                    continue;
                }
                if (options.withArg("-prefixes")) {
                    prefixes = CompiledTLexBuilder.openFile(options.getArg(), coding);
                    continue;
                }
                args[dargc++] = options.next();
            }
            if (dargc == 0) {
                options.usage();
            }
            CompiledTLexBuilder db = new CompiledTLexBuilder();
            if (rules != null) {
                db.parseRules(rules);
            }
            db.trace_ = trace;
            boolean sub = false;
            for (int a = 0; a < dargc; ++a) {
                if (args[a].equals("-sub")) {
                    sub = true;
                    continue;
                }
                String path = args[a];
                if (!db.processCompiledFile(path, sub)) {
                    db.processTextFile(path, coding, sub);
                }
                System.err.println("file " + path + " read");
            }
            if (freqw != null) {
                String word;
                while ((word = freqw.readLine()) != null) {
                    if (db.frequentWord(word.trim()) || verbosity <= 0) continue;
                    System.err.println("unknown frequent word: " + word + "|");
                }
            }
            if (prefixes != null) {
                String word;
                while ((word = prefixes.readLine()) != null) {
                    db.prefixWord(word.trim());
                }
            }
            if (dump != null) {
                BufferedWriter w = new BufferedWriter(coding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(dump), coding) : new FileWriter(dump));
                db.dumpWords(w);
                ((Writer)w).close();
            }
            if (out != null) {
                db.generate(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("** " + e);
            System.exit(1);
        }
    }

    static class Suffix {
        String key;
        Node instance;
        int frequency = 1;
        int offset;
        int code;

        Suffix() {
        }
    }

    static class Iterator {
        Node[] stack_ = new Node[100];
        int sp_;
        int wtype_;

        Iterator(Node root) {
            this.stack_[0] = root;
            this.sp_ = 0;
        }

        int getNextWord(byte[] out) {
            Node nxt = this.next();
            while (nxt != null && !TLex.actualWord(nxt.type_)) {
                nxt = this.next();
            }
            if (nxt == null) {
                return -1;
            }
            for (int i = 1; i < this.sp_; ++i) {
                out[i - 1] = this.stack_[i].ch_;
            }
            this.wtype_ = nxt.type_;
            return this.sp_ - 1;
        }

        int getFlags() {
            return this.wtype_;
        }

        Node next() {
            if (this.sp_ == 0) {
                this.sp_ = 1;
                return this.stack_[0];
            }
            Node current = this.stack_[this.sp_ - 1];
            if (current.kids_ != null) {
                Node node = current.kids_;
                this.stack_[this.sp_++] = node;
                return node;
            }
            if (current.next_ != null) {
                Node node = current.next_;
                this.stack_[this.sp_ - 1] = node;
                return node;
            }
            while (--this.sp_ > 1) {
                current = this.stack_[this.sp_ - 1];
                if (current.next_ == null) continue;
                Node node = current.next_;
                this.stack_[this.sp_ - 1] = node;
                return node;
            }
            return null;
        }
    }

    protected static class Node {
        Node next_;
        Node kids_;
        byte ch_;
        byte type_ = 0;
        int offset_ = 0;
        String shareKey;
        static int tcount = 0;

        Node(byte ch) {
            this.ch_ = ch;
        }

        Node getChild(byte c, boolean create) {
            Node kid = this.kids_;
            Node last = null;
            while (kid != null) {
                if (kid.ch_ == c) {
                    return kid;
                }
                if (kid.ch_ > c) break;
                last = kid;
                kid = kid.next_;
            }
            if (!create) {
                return null;
            }
            ++tcount;
            Node nkid = new Node(c);
            if (last == null) {
                this.kids_ = nkid;
            } else {
                last.next_ = nkid;
            }
            nkid.next_ = kid;
            return nkid;
        }
    }
}

