/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.SpellException;
import azcheck.engine.SuggestionBox;
import azcheck.engine.TLex;
import azcheck.util.CharSequence;
import java.util.Vector;

public class CompositeTLex
extends TLex {
    Vector members_ = new Vector();

    CompositeTLex(Object location) {
        super(location);
    }

    void addMember(TLex dict) {
        this.shareRules(dict);
        this.members_.add(dict);
    }

    TLex getMember(int rank) {
        return this.members_.size() == 0 ? null : (TLex)this.members_.get(rank);
    }

    int getCompoundMin() {
        return this.members_.size() == 0 ? 0 : this.getMember(0).getCompoundMin();
    }

    int simpleSearch(CharSequence text, int wordStart, int wordLength) throws SpellException {
        int bestFlags = 4;
        int actualFlags = -1;
        for (int d = 0; d < this.members_.size(); ++d) {
            int flags = this.getMember(d).simpleSearch(text, wordStart, wordLength);
            if (CompositeTLex.actualWord(flags) && CompositeTLex.getWordType(flags) < bestFlags) {
                bestFlags = CompositeTLex.getWordType(flags);
                actualFlags = flags;
            }
            if (bestFlags != 0) continue;
            return actualFlags;
        }
        return actualFlags;
    }

    void approximateSearch(CharSequence text, int wordStart, int wordLength, SuggestionBox box, int force) throws SpellException {
        for (int i = 0; i < this.members_.size(); ++i) {
            this.getMember(i).approximateSearch(text, wordStart, wordLength, box, force);
        }
    }

    boolean compoundSearch(CharSequence text, int wordStart, int wordLength, boolean anyCompound, boolean allowPrefixes) throws SpellException {
        int flags;
        byte cap = CompositeTLex.capType(text, wordStart, wordLength);
        if (anyCompound) {
            for (int dash = 1; dash < wordLength - 1; ++dash) {
                int nLen;
                int nStart;
                if (text.charAt(wordStart + dash) != '-' || !CompositeTLex.actualWord(flags = this.simpleSearch(text, wordStart, dash)) || CompositeTLex.getWordType(flags) > cap || !CompositeTLex.actualWord(flags = this.simpleSearch(text, nStart = wordStart + dash + 1, nLen = wordLength - (dash + 1))) || CompositeTLex.getWordType(flags) > CompositeTLex.capType(text, nStart, nLen)) continue;
                return true;
            }
            int compoundMin = this.getCompoundMin();
            if (compoundMin > 0) {
                for (int pos = compoundMin; pos < wordLength - compoundMin; ++pos) {
                    int flags2 = this.simpleSearch(text, wordStart, pos);
                    if (!CompositeTLex.actualWord(flags2) || CompositeTLex.getWordType(flags2) > cap || !CompositeTLex.validWord(flags2 = this.simpleSearch(text, wordStart + pos, wordLength - pos), 1)) continue;
                    return true;
                }
            }
        }
        if (allowPrefixes) {
            for (int pos = 2; pos < wordLength - 2; ++pos) {
                flags = this.simpleSearch(text, wordStart, pos);
                if (!CompositeTLex.actualWord(flags) || !CompositeTLex.isaPrefix(flags) || !CompositeTLex.actualWord(flags = this.simpleSearch(text, wordStart + pos, wordLength - pos))) continue;
                return true;
            }
        }
        return false;
    }
}

