/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.EditableWord;
import azcheck.engine.SpellException;
import azcheck.engine.TLex;
import azcheck.engine.TLexRules;
import azcheck.util.CharSequence;
import azcheck.util.StringCharSeq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class EditableTLex
extends TLex {
    static final byte E_PLAIN = 0;
    static final byte E_REPLACE = 1;
    static final byte E_SUGGESTIONS = 2;
    static final byte E_BANNED = 3;
    static final byte E_FILEEXT = 4;
    Vector nodes_ = new Vector();

    EditableTLex(String location, TLexRules table) {
        super(location);
        this.shareRules(table);
        this.nodes_.add(null);
        this.rootNode_ = 1;
        this.nodes_.add(new Node());
    }

    Entry lookup(CharSequence chars, int start, int length) throws SpellException {
        this.encodeWord(chars, start, length);
        int fn = this.searchItem(this.rootNode_, this.word_, 0, this.wLength_);
        Node n = this.getNode(fn);
        if (n == null) {
            return null;
        }
        Entry e = new Entry();
        e.value = n.value;
        e.type = n.type;
        return e;
    }

    int addWord(String word, byte type, String value) throws SpellException {
        return this.addWord(word, type, value, true);
    }

    int addWord(String word, byte type, String value, boolean override) throws SpellException {
        int cap = this.encodeWord(new StringCharSeq(word), 0, word.length());
        int node = this.rootNode_;
        for (int i = 0; i < this.wLength_; ++i) {
            node = this.haveNode(node, this.word_[i]);
        }
        Node n = this.getNode(node);
        if (type == 2 && n.value != null) {
            StringTokenizer tok = new StringTokenizer(n.value, "\t");
            while (tok.hasMoreTokens()) {
                if (!tok.nextToken().equals(value)) continue;
                return node;
            }
            n.value = n.value + "\t" + value;
        } else if (override) {
            n.value = value;
        }
        if (override) {
            n.flags = EditableTLex.wordFlags(cap);
            n.type = type;
        }
        return node;
    }

    boolean removeWord(String word) throws SpellException {
        int cap = this.encodeWord(new StringCharSeq(word), 0, word.length());
        int node = this.rootNode_;
        for (int i = 0; i < this.wLength_ && node >= 0; ++i) {
            node = this.step(node, this.word_[i]);
        }
        if (node < 0) {
            return false;
        }
        Node n = this.getNode(node);
        n.value = null;
        n.flags = 0;
        return true;
    }

    void load(BufferedReader input, boolean override) throws IOException, SpellException {
        while (true) {
            String key = input.readLine();
            String value = null;
            if (key == null) break;
            int len = key.length();
            if (len == 0 || key.charAt(0) == '#') continue;
            int klen = key.indexOf(9);
            if (klen < 0) {
                klen = len;
            }
            byte type = 0;
            if (klen + 1 < len) {
                switch (key.charAt(klen + 1)) {
                    case '?': {
                        type = 2;
                        value = key.substring(klen + 2);
                        break;
                    }
                    case '%': {
                        type = 3;
                        break;
                    }
                    case '@': {
                        type = 4;
                        break;
                    }
                    case '!': {
                        type = 1;
                        value = key.substring(klen + 2);
                    }
                }
            }
            this.addWord(key.substring(0, klen), type, value, override);
        }
    }

    void save(final BufferedWriter out) throws IOException {
        this.fullVisit(new TLex.Visitor(){

            public void getWord(char[] chars, int depth, int cap, int node) {
                try {
                    Node n = EditableTLex.this.getNode(node);
                    for (int i = 0; i < depth; ++i) {
                        char c = chars[i];
                        if (cap == 2 || i == 0 && cap == 1) {
                            c = Character.toUpperCase(c);
                        }
                        out.write(c);
                    }
                    out.write(9);
                    switch (n.type) {
                        case 2: {
                            out.write("?");
                            out.write(n.value);
                            break;
                        }
                        case 1: {
                            out.write("!");
                            out.write(n.value);
                            break;
                        }
                        case 3: {
                            out.write("%");
                            break;
                        }
                        case 4: {
                            out.write("@");
                        }
                    }
                    out.write(10);
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
    }

    EditableWord[] getEditableWords() throws SpellException {
        final Vector list = new Vector();
        this.fullVisit(new TLex.Visitor(){

            public void getWord(char[] chars, int depth, int cap, int node) {
                Node n = EditableTLex.this.getNode(node);
                EditableWord word = new EditableWord();
                word.word = new String(chars, 0, depth);
                word.type = n.type;
                word.value = n.value;
                list.add(word);
            }
        });
        return list.toArray(new EditableWord[0]);
    }

    void fullVisit(TLex.Visitor visitor) {
        char[] chars = new char[256];
        this.fullVisit(visitor, chars, 0, this.rootNode_);
    }

    private void fullVisit(TLex.Visitor visitor, char[] chars, int depth, int node) {
        Node n = this.getNode(node);
        if (EditableTLex.actualWord(n.flags)) {
            visitor.getWord(chars, depth, EditableTLex.getWordType(n.flags), node);
        }
        KEnum iter = (KEnum)this.newKEnum(node);
        while (iter.next()) {
            chars[depth] = this.decode(iter.getCurrentChar());
            int kid = iter.getCurrentNode();
            if (kid > 0) {
                this.fullVisit(visitor, chars, depth + 1, kid);
                continue;
            }
            if (kid != 0) continue;
            visitor.getWord(chars, depth + 1, EditableTLex.getWordType(this.getFlags(kid)), kid);
        }
    }

    Node getNode(int nodeId) {
        return nodeId <= 0 ? null : (Node)this.nodes_.get(nodeId);
    }

    int getFlags(int node) {
        Node n = this.getNode(node);
        if (n == null || n.type != 0) {
            return -1;
        }
        return EditableTLex.actualWord(n.flags) ? (int)n.flags : -1;
    }

    int step(int node, byte charCode) {
        Node n = this.getNode(node);
        int kid = n.children;
        while (kid >= 0) {
            n = this.getNode(kid);
            if (n.charCode == charCode) {
                return kid;
            }
            if (n.charCode > charCode) {
                return -1;
            }
            kid = n.next;
        }
        return -1;
    }

    int haveNode(int node, byte charCode) {
        Node n = this.getNode(node);
        Node k = null;
        int kid = n.children;
        int last = -1;
        while (kid >= 0) {
            k = this.getNode(kid);
            if (k.charCode == charCode) {
                return kid;
            }
            if (k.charCode > charCode) break;
            last = kid;
            kid = k.next;
        }
        k = new Node();
        k.next = kid;
        k.charCode = charCode;
        kid = this.nodes_.size();
        if (last < 0) {
            n.children = kid;
        } else {
            this.getNode((int)last).next = kid;
        }
        this.nodes_.add(k);
        return kid;
    }

    TLex.KEnum newKEnum(int node) {
        return new KEnum(node);
    }

    class KEnum
    implements TLex.KEnum {
        int curNode_;
        boolean atStart_ = true;

        KEnum(int node) {
            this.curNode_ = node;
            this.atStart_ = true;
        }

        public boolean next() {
            if (this.atStart_) {
                this.curNode_ = EditableTLex.this.getNode((int)this.curNode_).children;
            } else if (this.curNode_ >= 0) {
                this.curNode_ = EditableTLex.this.getNode((int)this.curNode_).next;
            }
            this.atStart_ = false;
            return this.curNode_ >= 0;
        }

        public int getCurrentNode() {
            return this.curNode_;
        }

        public byte getCurrentChar() {
            return EditableTLex.this.getNode((int)this.curNode_).charCode;
        }
    }

    static class Node {
        byte charCode;
        byte flags = 0;
        byte type;
        int children = -1;
        int next = -1;
        String value;

        Node() {
        }
    }

    static class Entry {
        String value;
        byte type;

        Entry() {
        }
    }
}

