/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.SpellException;
import azcheck.engine.SuggestionBox;
import azcheck.engine.TLexRules;
import azcheck.util.CharSequence;
import java.io.IOException;
import java.io.Writer;

public abstract class TLex
extends TLexRules {
    public static final int MAX_WORD_LENGTH = 256;
    static final int FORCE_DEFAULT = 3;
    static final int FORCE_MAX = 5;
    static final int COST_OF_INSERTION = 15;
    static final int COST_OF_SWAPPING = 14;
    static final int COST_OF_DELETION = 17;
    static final int COST_OF_CHANGE = 18;
    static final int COST_OF_MISTAKE = 10;
    static final int INCR_OF_MISTAKE = 3;
    static final int COST_OF_KEYBOARD_SLIP = 13;
    static final int COST_OF_SPLIT = 27;
    static final int COST_OF_LEARNED = 0;
    static final int COST_OF_BAD_CAP = 3;
    static final int COST_OF_FREQUENT = -3;
    static final int QUICK_MIN = 4;
    Object location_;
    String copyright_ = "";
    int rootNode_;
    int stepCnt_;
    byte[] word_ = new byte[256];
    int wLength_;
    TLexRules.MRule[] matchedMRule_ = new TLexRules.MRule[257];
    SuggestionBox box_;
    boolean combinedSplit_ = true;
    int splitMax_ = 1;
    int compoundMin_ = 0;
    static final byte FREQUENT_FLAG = 8;
    static final byte PREFIX_FLAG = 16;

    TLex(Object location) {
        this.setLocation(location);
    }

    public Object getLocation() {
        return this.location_;
    }

    void setLocation(Object location) {
        this.location_ = location;
    }

    public void setCopyright(String notice) {
        this.copyright_ = notice;
    }

    public String getCopyright() {
        return this.copyright_;
    }

    int simpleSearch(CharSequence text, int wordStart, int wordLength) throws SpellException {
        this.encodeWord(text, wordStart, wordLength);
        int node = this.searchItem(this.rootNode_, this.word_, 0, wordLength);
        if (node < 0) {
            return -1;
        }
        return this.getFlags(node);
    }

    void approximateSearch(CharSequence text, int wordStart, int wordLength, SuggestionBox box, int force) throws SpellException {
        if (force <= 0) {
            return;
        }
        this.encodeWord(text, wordStart, wordLength);
        this.box_ = box;
        this.box_.setRules(this);
        this.stepCnt_ = 0;
        for (int i = 0; i <= wordLength; ++i) {
            TLexRules.CProps props = this.getChar(i < wordLength ? this.word_[i] : (byte)-2);
            TLexRules.MRule crule = props.mistRules;
            while (crule != null && !crule.matches(this.word_, i, wordLength)) {
                crule = crule.next;
            }
            this.matchedMRule_[i] = crule;
        }
        this.box_.back(0, 0);
        int quickCost = 32;
        if (force <= 1) {
            quickCost -= 10;
        }
        this.box_.setCostMaximum(quickCost);
        this.approxSearch(0, this.rootNode_);
        if (this.box_.getCount() < 5) {
            this.compoundSuggest();
        }
        if (force >= 3 && this.box_.getCount() < (force <= 3 ? 3 : 5)) {
            this.box_.back(0, 0);
            int hiCost = 45;
            if (force > 3) {
                hiCost += 6;
            }
            if (force > 4) {
                hiCost += 6;
            }
            this.box_.setCostMaximum(hiCost);
            this.approxSearch(0, this.rootNode_);
        }
        if (!this.combinedSplit_) {
            this.splitSearch(0, 0);
        }
    }

    int step(int node, byte charCode) {
        throw new RuntimeException("abstract method called");
    }

    KEnum newKEnum(int node) {
        throw new RuntimeException("abstract method called");
    }

    int getCompoundMin() {
        return 0;
    }

    int getFlags(int node) {
        throw new RuntimeException("abstract method called");
    }

    static byte wordFlags(int type) {
        return (byte)(1 + (type << 1));
    }

    static final int getWordType(int flags) {
        return (flags & 7) >> 1;
    }

    static final boolean actualWord(int flags) {
        return flags > 0 && (flags & 1) != 0;
    }

    static final boolean validWord(int flags, int cap) {
        return TLex.actualWord(flags) && TLex.getWordType(flags) <= cap;
    }

    static final boolean isaPrefix(int flags) {
        return flags > 0 && (flags & 0x10) != 0;
    }

    int encodeWord(CharSequence text, int wordStart, int wordLength) throws SpellException {
        boolean lower;
        this.wLength_ = wordLength;
        byte cap = TLex.capType(text, wordStart, wordLength);
        boolean bl = lower = cap != 3;
        if (this.wLength_ > this.word_.length) {
            this.word_ = new byte[wordLength];
        }
        for (int i = 0; i < wordLength; ++i) {
            char c = text.charAt(wordStart + i);
            this.word_[i] = this.encode(lower ? Character.toLowerCase(c) : c);
            if (this.word_[i] != -1) continue;
            throw new SpellException("character '" + c + "' not accepted", i);
        }
        return cap;
    }

    int searchItem(int node, byte[] word_, int wstart, int wend) {
        for (int i = wstart; i < wend; ++i) {
            if (node <= 0) {
                return -1;
            }
            node = this.step(node, word_[i]);
        }
        return node;
    }

    void approxSearch(int wstart, int node) {
        int savedCursor = this.box_.getCursor();
        int savedCost = this.box_.getCost();
        int flags = this.getFlags(node);
        if (wstart >= this.wLength_ && TLex.actualWord(flags)) {
            this.box_.storeWord(flags);
        }
        if (node <= 0) {
            return;
        }
        if (wstart > this.wLength_) {
            throw new RuntimeException("BUG wstart " + wstart + " > " + this.wLength_);
        }
        int nextNode = this.step(node, this.word_[wstart]);
        if (nextNode >= 0 && wstart < this.wLength_) {
            this.box_.put(this.word_[wstart]);
            this.approxSearch(wstart + 1, nextNode);
            this.box_.back(savedCursor, savedCost);
        }
        if (wstart < this.wLength_ && this.box_.checkCost(17)) {
            this.box_.putCost(17);
            this.approxSearch(wstart + 1, node);
            this.box_.back(savedCursor, savedCost);
        }
        if (wstart + 2 <= this.wLength_ && this.box_.checkCost(14)) {
            nextNode = this.step(node, this.word_[wstart + 1]);
            if (nextNode > 0 && (nextNode = this.step(nextNode, this.word_[wstart])) >= 0) {
                this.box_.put(this.word_[wstart + 1]);
                this.box_.put(this.word_[wstart]);
                this.box_.putCost(14);
                this.approxSearch(wstart + 2, nextNode);
            }
            this.box_.back(savedCursor, savedCost);
        }
        KEnum iter = this.newKEnum(node);
        while (iter.next()) {
            int cost;
            nextNode = iter.getCurrentNode();
            byte b = iter.getCurrentChar();
            if (this.box_.checkCost(15)) {
                this.box_.put(b);
                this.box_.putCost(15);
                this.approxSearch(wstart, nextNode);
                this.box_.back(savedCursor, savedCost);
            }
            if (wstart >= this.wLength_ || !this.box_.checkCost(cost = this.charCloseness(b, this.word_[wstart], 18))) continue;
            this.box_.put(b);
            this.box_.putCost(cost);
            this.approxSearch(wstart + 1, nextNode);
            this.box_.back(savedCursor, savedCost);
        }
        if (this.matchedMRule_[wstart] != null) {
            TLexRules.MRule rule = this.matchedMRule_[wstart];
            int itemIndex = rule.itemNext(0);
            int shifted = rule.matchedChars();
            int nrep = rule.itemCount();
            while (--nrep >= 0) {
                nextNode = this.tryAlternative(node, wstart, rule, itemIndex);
                if (nextNode >= 0 && this.box_.checkCost(rule.itemCost(itemIndex))) {
                    this.putAlternative(rule, itemIndex);
                    this.approxSearch(wstart + shifted, nextNode);
                    this.box_.back(savedCursor, savedCost);
                }
                itemIndex = rule.itemNext(itemIndex);
            }
        }
        if (this.combinedSplit_ && wstart > 1 && wstart <= this.wLength_ - 2 && TLex.actualWord(flags)) {
            int compCnt = this.box_.split(0);
            int compCost = 27;
            if (compCnt > 0) {
                compCost += 13;
            }
            if (this.box_.checkCost(compCost)) {
                this.box_.split(1);
                if (!TLex.isaPrefix(flags)) {
                    this.box_.put(this.encode(' '));
                }
                this.box_.putCost(compCost);
                this.approxSearch(wstart, this.rootNode_);
                this.box_.back(savedCursor, savedCost);
                this.box_.split(-1);
            }
        }
    }

    boolean splitSearch(int wstart, int count) {
        int nextNode = this.searchItem(this.rootNode_, this.word_, wstart, this.wLength_);
        int flags = this.getFlags(nextNode);
        if (TLex.actualWord(flags)) {
            this.box_.put(this.word_, wstart, this.wLength_);
            this.box_.putCost(18 * count);
            this.box_.storeWord(flags);
            return true;
        }
        if (count >= this.splitMax_) {
            return false;
        }
        int savedCursor = this.box_.getCursor();
        int savedCost = this.box_.getCost();
        boolean ok = false;
        for (int p = wstart + 1; p < this.wLength_; ++p) {
            nextNode = this.searchItem(this.rootNode_, this.word_, wstart, p);
            flags = this.getFlags(nextNode);
            if (TLex.getWordType(flags) == 0) {
                this.box_.put(this.word_, wstart, p);
                this.box_.put(this.encode(' '));
                this.box_.split(1);
                if (this.splitSearch(p, count + 1)) {
                    ok = true;
                }
                this.box_.split(-1);
            }
            this.box_.back(savedCursor, savedCost);
        }
        return ok;
    }

    void compoundSuggest() {
        byte hyphen = this.encode('-');
        for (int d = 2; d < this.wLength_ - 1; ++d) {
            if (this.word_[d] != hyphen) continue;
            int wL = d;
            int nextNode = this.searchItem(this.rootNode_, this.word_, 0, wL);
            int flags = this.getFlags(nextNode);
            if (!TLex.actualWord(flags) && !TLex.isaPrefix(flags)) {
                nextNode = this.searchItem(this.rootNode_, this.word_, 0, ++wL);
            }
            if (TLex.actualWord(flags) || TLex.isaPrefix(flags)) {
                this.box_.put(this.word_, 0, wL);
                this.box_.put(hyphen);
                this.approxSearch(d + 1, this.rootNode_);
                continue;
            }
            int nextNode2 = this.searchItem(this.rootNode_, this.word_, wL, this.wLength_);
            int flags2 = this.getFlags(nextNode2);
            if (!TLex.actualWord(flags2)) continue;
            int saveLength = this.wLength_;
            this.wLength_ = d;
            this.box_.setSuffix(this.decode(this.word_, d, saveLength - d));
            this.approxSearch(0, this.rootNode_);
            this.box_.setSuffix(null);
            this.wLength_ = saveLength;
        }
    }

    int tryAlternative(int node, int wstart, TLexRules.MRule rule, int itemIndex) {
        int curNode = node;
        int len = rule.itemSize(itemIndex);
        for (int p = 0; p < len; ++p) {
            byte ruleCode = rule.itemCode(itemIndex, p);
            if (ruleCode == -1) {
                if (wstart <= 0) continue;
                return -1;
            }
            if (ruleCode == -2) {
                if (TLex.actualWord(this.getFlags(curNode))) continue;
                return -1;
            }
            if (curNode <= 0) {
                return -1;
            }
            curNode = this.step(curNode, ruleCode);
        }
        return curNode;
    }

    void putAlternative(TLexRules.MRule rule, int itemIndex) {
        int length = rule.itemSize(itemIndex);
        for (int p = 0; p < length; ++p) {
            byte ruleCode = rule.itemCode(itemIndex, p);
            if (ruleCode == -1 || ruleCode == -2) continue;
            this.box_.put(ruleCode);
        }
        this.box_.putCost(rule.itemCost(itemIndex));
    }

    void visit(Visitor visitor) {
        char[] chars = new char[256];
        this.visit(visitor, chars, 0, this.rootNode_);
    }

    private void visit(Visitor visitor, char[] chars, int depth, int node) {
        int flags = this.getFlags(node);
        if (TLex.actualWord(flags)) {
            visitor.getWord(chars, depth, TLex.getWordType(flags), node);
        }
        KEnum iter = this.newKEnum(node);
        while (iter.next()) {
            chars[depth] = this.decode(iter.getCurrentChar());
            int kid = iter.getCurrentNode();
            if (kid > 0) {
                this.visit(visitor, chars, depth + 1, kid);
                continue;
            }
            if (kid != 0) continue;
            visitor.getWord(chars, depth + 1, TLex.getWordType(this.getFlags(kid)), kid);
        }
    }

    void dump(final Writer out) {
        this.visit(new Visitor(){

            public void getWord(char[] word, int length, int cap, int node) {
                try {
                    for (int i = 0; i < length; ++i) {
                        char c = word[i];
                        if (cap == 2 || i == 0 && cap == 1) {
                            c = Character.toUpperCase(c);
                        }
                        out.write(c);
                    }
                    out.write(10);
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
    }

    public static interface Visitor {
        public void getWord(char[] var1, int var2, int var3, int var4);
    }

    static class Fragment {
        int start;
        int length;

        Fragment(int s, int L) {
            this.start = s;
            this.length = L;
        }
    }

    static interface KEnum {
        public boolean next();

        public int getCurrentNode();

        public byte getCurrentChar();
    }
}

