/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.SpellException;
import azcheck.engine.Suggestions;
import azcheck.ui.JSpellDialog;
import azcheck.ui.JSpellOptions;
import azcheck.ui.SpellControl;
import azcheck.ui.TextSource;
import azcheck.ui.ThinBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class JSpellComponent
extends JComponent
implements ActionListener,
ListSelectionListener,
DocumentListener {
    private File spellDir = null;
    public Properties prop = new Properties();
    String rcFileName = null;
    private JTextField status_;
    private JTextField faultyWord_;
    private JTextField inputWord_;
    private JList suggestionList_;
    private JViewport suggestionPort_;
    private JComboBox dictionaryBox_;
    private JButton[] buttons_;
    private JLabel copyrightLabel_;
    private SpellControl checker_;
    private int checkStatus_;
    private TextSource source_;
    private DictionaryManagerItem[] languages_;
    private String[] dictCodes_;
    private Vector actionListeners_ = new Vector();
    private static ResourceBundle resources = null;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$java$awt$Window;

    public JSpellComponent(TextSource source, String dictPath) throws SpellException, IOException {
        this.source_ = source;
        this.checker_ = new SpellControl(dictPath);
        this.createInterface();
    }

    public JSpellComponent(TextSource source, SpellControl checker) throws SpellException {
        this.source_ = source;
        this.checker_ = checker;
        this.createInterface();
    }

    public TextSource getSource() {
        return this.source_;
    }

    public void setSource(TextSource source) {
        this.source_ = source;
    }

    public SpellControl getChecker() {
        return this.checker_;
    }

    public void check() throws SpellException {
        this.status("");
        this.clearText(this.faultyWord_);
        this.clearText(this.inputWord_);
        this.suggestionList_.setListData(new String[0]);
        this.getButton("ignore").setEnabled(true);
        this.checkStatus_ = this.checker_.check(this.source_);
        switch (this.checkStatus_) {
            case 0: {
                this.done();
                this.enableReplace(false);
                this.enableLearning(false);
                this.status(JSpellComponent.lmsg("finished"));
                break;
            }
            case 4: {
                this.status(JSpellComponent.lmsg("duplicate_word"), this.checker_.failingWord());
                this.enableReplace(true);
                this.enableLearning(false);
                break;
            }
            case 5: {
                this.showSuggestions("punctuation_problem", null);
                this.enableLearning(false);
                break;
            }
            case 3: {
                this.showSuggestions("word_should_be_capitalized", null);
                this.enableLearning(true);
                break;
            }
            case 2: {
                this.showSuggestions("unrecognized_word", null);
                this.enableLearning(true);
            }
        }
        this.inputWord_.requestFocus();
    }

    public void setSpelllDir() {
        String homeDir = null;
        try {
            homeDir = System.getProperty("HOME");
            if (homeDir == null || homeDir.length() == 0) {
                homeDir = System.getProperty("user.home");
            }
            if (!new File(homeDir).isDirectory()) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        String spellBaseName = "spell";
        this.spellDir = new File(homeDir + File.separatorChar + ".novell" + File.separatorChar + "groupwise" + File.separatorChar + spellBaseName);
        boolean directory = this.spellDir.isDirectory();
        if (!directory && !this.spellDir.mkdir()) {
            this.spellDir = new File(homeDir);
        }
    }

    public void loadPrefs() {
        String appName = "prefrences";
        if (this.spellDir == null) {
            this.setSpelllDir();
        }
        try {
            this.rcFileName = File.pathSeparatorChar == ';' ? this.spellDir.getAbsolutePath() + File.separatorChar + appName + ".ini" : this.spellDir.getAbsolutePath() + File.separatorChar + appName;
            if (!new File(this.rcFileName).isFile()) {
                return;
            }
            FileInputStream in = new FileInputStream(this.rcFileName);
            this.prop.load(in);
            ((InputStream)in).close();
            this.checker_.loadOptions(this.prop);
            return;
        }
        catch (Exception e) {
            System.err.println(appName + ": cannot load Preferences: " + e.getMessage());
            return;
        }
    }

    public void savePrefs() {
        String appName = "prefrences";
        if (this.spellDir == null) {
            this.setSpelllDir();
        }
        try {
            this.checker_.saveOptions(this.prop);
            FileOutputStream out = new FileOutputStream(this.rcFileName);
            this.prop.store(out, appName);
            ((OutputStream)out).close();
            return;
        }
        catch (Exception e) {
            System.err.println(appName + ": cannot save Preferences: " + e.getMessage());
            return;
        }
    }

    public void setPersonalDictionary(String pattern) {
        if (this.spellDir == null) {
            this.setSpelllDir();
        }
        this.checker_.setPersonalDictionaryPath(this.spellDir.getAbsolutePath() + File.separatorChar + pattern);
    }

    public void selectDictionary(String dict) throws IOException, SpellException {
        this.checker_.selectDictionary(dict);
        int L = this.languages_.length;
        while (--L >= 0) {
            if (!this.languages_[L].name.equals(dict)) continue;
            this.dictionaryBox_.setSelectedIndex(L);
            break;
        }
    }

    public void selectDictionary() throws IOException, SpellException {
        String prefsLang = this.checker_.getPrefsLang_();
        if (prefsLang != null) {
            this.selectDictionary(prefsLang);
        } else {
            this.selectDictionary("en-US");
        }
    }

    public void done() {
        this.checker_.stop();
        this.checkStatus_ = 0;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners_.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners_.remove(listener);
    }

    private void fireSpellEvent(String command) {
        ActionEvent e = new ActionEvent(this, 0, command);
        for (int i = 0; i < this.actionListeners_.size(); ++i) {
            ((ActionListener)this.actionListeners_.get(i)).actionPerformed(e);
        }
    }

    void status(String msg) {
        this.status_.setText(msg);
    }

    private void status(String msg, String arg) {
        this.status_.setText(msg + " : " + arg);
    }

    private void showSuggestions(String msgId, String typedWord) throws SpellException {
        this.status(JSpellComponent.lmsg(msgId));
        Suggestions suggestions = typedWord == null ? this.checker_.getSuggestions() : this.checker_.getSuggestions(typedWord);
        this.suggestionList_.setListData(suggestions.toArray());
        this.suggestionPort_.setViewPosition(new Point(0, 0));
        this.clearText(this.faultyWord_);
        this.faultyWord_.setText(suggestions.getWord());
        this.clearText(this.inputWord_);
        this.inputWord_.setText(suggestions.getSuggestion(0));
        this.getRootPane().setDefaultButton(this.getButton("replace"));
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        try {
            if (cmd.equals("ignore")) {
                this.check();
            } else if (cmd.equals("ignore_all")) {
                this.checker_.ignoreAll(this.faultyWord_.getText());
                this.check();
            } else if (cmd.equals("replace")) {
                this.simpleReplace();
            } else if (cmd.equals("replace_all")) {
                this.checker_.replace(this.inputWord_.getText(), true);
                this.check();
            } else if (cmd.equals("learn")) {
                this.checker_.add(this.faultyWord_.getText());
                this.check();
            } else if (cmd.equals("ban")) {
                this.checker_.learnBannedWord(this.faultyWord_.getText(), "<personal>");
            } else if (cmd.equals("check")) {
                this.checkTypedWord();
            } else if (cmd.equals("done")) {
                this.done();
                this.fireSpellEvent("spell_done");
            } else if (cmd.equals("options")) {
                this.options();
            } else if (cmd.equals("select_language")) {
                this.selectedDictionary();
            }
        }
        catch (SpellException e) {
            this.status("Error: " + e);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.status("Error: " + e);
            e.printStackTrace();
        }
    }

    public void close() {
        this.done();
        this.fireSpellEvent("spell_done");
    }

    public void valueChanged(ListSelectionEvent e) {
        this.inputWord_.setText((String)this.suggestionList_.getSelectedValue());
        this.enableReplace(true);
        this.enableLearning(false);
    }

    public void insertUpdate(DocumentEvent e) {
        this.enableReplace(true);
        this.enableLearning(true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.enableReplace(true);
        this.enableLearning(true);
    }

    public void changedUpdate(DocumentEvent e) {
        this.enableReplace(true);
        this.enableLearning(true);
    }

    private void enableReplace(boolean enabled) {
        this.getButton("replace").setEnabled(enabled);
        this.getButton("replace_all").setEnabled(enabled);
        JButton b = this.getButton("check");
        if (b != null) {
            b.setEnabled(enabled);
        }
        if ((b = this.getButton("ban")) != null) {
            b.setEnabled(enabled && this.checkStatus_ == 2);
        }
    }

    private void enableLearning(boolean enabled) {
        this.getButton("ignore_all").setEnabled(enabled);
        this.getButton("learn").setEnabled(enabled);
    }

    private void simpleReplace() {
        try {
            this.checker_.replace(this.inputWord_.getText(), false);
            this.check();
        }
        catch (SpellException e) {
            this.status("Error: " + e.getMessage());
        }
    }

    private void checkTypedWord() {
        try {
            String input = this.inputWord_.getText().trim();
            switch (this.checker_.checkWord(input)) {
                case 0: {
                    this.status(JSpellComponent.lmsg("OK"));
                    break;
                }
                case 3: {
                    this.showSuggestions("word_should_be_capitalized", input);
                    break;
                }
                case 2: {
                    this.showSuggestions("unrecognized_word", input);
                }
            }
        }
        catch (SpellException e) {
            this.status("Error: " + e.getMessage());
        }
    }

    private void options() {
        JFrame owner = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = JSpellComponent.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
        JSpellOptions options = new JSpellOptions(owner, this.checker_);
        Window where = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = JSpellComponent.class$("java.awt.Window")) : class$java$awt$Window, this);
        JSpellDialog.place(options, where, 0, 2);
        options.setVisible(true);
    }

    private void selectedDictionary() {
        String dict = this.dictCodes_[this.dictionaryBox_.getSelectedIndex()];
        try {
            this.checker_.selectDictionary(dict);
            this.status("");
            String copyright = this.checker_.getCopyright();
            copyright = copyright != null && copyright.length() > 0 ? JSpellComponent.lmsg("Dictionary_copyright_") + copyright : "";
            this.copyrightLabel_.setText(copyright);
            if (this.source_ != null) {
                this.source_.highlight(-1, 0);
            }
            this.fireSpellEvent("spell_language");
            if (this.checkStatus_ != 0) {
                this.check();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error for dictionary " + JSpellComponent.lmsg(dict) + ": " + e);
            e.printStackTrace();
            return;
        }
    }

    private JButton getButton(String cmd) {
        int c = this.buttons_.length;
        while (--c >= 0) {
            if (this.buttons_[c] == null || !cmd.equals(this.buttons_[c].getActionCommand())) continue;
            return this.buttons_[c];
        }
        return null;
    }

    private void createInterface() {
        int TEXT_FIELD_SIZE = 20;
        int V_INSET = 4;
        int H_INSET = 8;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 8, 0, 8);
        c.gridy = 0;
        c.gridx = 0;
        this.status_ = new JTextField(20);
        this.status_.setBorder(null);
        this.status_.setEditable(false);
        this.status_.setForeground(new Color(0xD00000));
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = 2;
        this.add((Component)this.status_, c);
        ++c.gridy;
        this.faultyWord_ = new JTextField(20);
        ThinBorder brdr = new ThinBorder(this.status_.getBackground(), false);
        this.faultyWord_.setEditable(false);
        this.faultyWord_.setBackground(this.status_.getBackground());
        this.faultyWord_.setBorder(brdr);
        this.faultyWord_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JSpellComponent.this.inputWord_.setText(JSpellComponent.this.faultyWord_.getText());
            }
        });
        c.weightx = 1.0;
        this.add((Component)this.faultyWord_, c);
        ++c.gridy;
        JLabel replLabel = new JLabel(JSpellComponent.lmsg("Replace_by") + ":");
        c.insets.bottom = 0;
        this.add((Component)replLabel, c);
        ++c.gridy;
        c.insets.bottom = 4;
        this.inputWord_ = new JTextField(20);
        this.inputWord_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.inputWord_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpellComponent.this.simpleReplace();
            }
        });
        this.inputWord_.getDocument().addDocumentListener(this);
        this.add((Component)this.inputWord_, c);
        ++c.gridy;
        JLabel suggLabel = new JLabel(JSpellComponent.lmsg("Suggestions") + ":");
        c.insets.bottom = 0;
        this.add((Component)suggLabel, c);
        ++c.gridy;
        int minDataSize = 10;
        String[] data = new String[10];
        for (int i = 0; i < 10; ++i) {
            data[i] = "\ufffd";
        }
        this.suggestionList_ = new JList<String>(data);
        this.suggestionList_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.suggestionList_.addListSelectionListener(this);
        this.suggestionList_.setMinimumSize(this.suggestionList_.getPreferredSize());
        this.suggestionList_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JSpellComponent.this.simpleReplace();
                }
            }
        });
        JScrollPane suggPane = new JScrollPane(this.suggestionList_);
        this.suggestionPort_ = suggPane.getViewport();
        c.fill = 1;
        c.weighty = 2.0;
        this.add((Component)suggPane, c);
        ++c.gridy;
        c.fill = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JLabel langLabel = new JLabel(JSpellComponent.lmsg("select_dictionary"));
        this.add((Component)langLabel, c);
        try {
            this.languages_ = this.checker_.listLanguages();
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this, "Error on dictionary lookup: " + ioex.getMessage());
        }
        int dictCnt = this.languages_.length;
        String[] dictNames = new String[dictCnt];
        this.dictCodes_ = new String[dictCnt];
        int dp = 0;
        for (int l = 0; l < this.languages_.length; ++l) {
            DictionaryManagerItem lgItem = this.languages_[l];
            this.dictCodes_[dp] = lgItem.name;
            dictNames[dp] = lgItem.local;
            ++dp;
        }
        this.dictionaryBox_ = new JComboBox<String>(dictNames);
        this.dictionaryBox_.setEditable(false);
        ++c.gridx;
        c.fill = 2;
        c.insets.bottom = 8;
        c.insets.top = 8;
        this.add((Component)this.dictionaryBox_, c);
        this.dictionaryBox_.setActionCommand("select_language");
        this.dictionaryBox_.addActionListener(this);
        ++c.gridy;
        this.copyrightLabel_ = new JLabel("");
        Font clfont = this.inputWord_.getFont();
        this.copyrightLabel_.setFont(clfont.deriveFont((float)clfont.getSize() - 2.0f));
        c.gridwidth = 2;
        c.gridx = 0;
        GridBagLayout buttonL = new GridBagLayout();
        JPanel buttons = new JPanel(buttonL);
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.insets.left = 15;
        c.insets.top = 4;
        c.fill = 3;
        c.gridheight = 0;
        this.add((Component)buttons, c);
        String[] buttonNames = new String[]{"replace", "replace_all", "ignore", "ignore_all", "learn", null, "options", null, "done"};
        this.buttons_ = new JButton[buttonNames.length];
        GridBagConstraints bc = new GridBagConstraints();
        bc.gridy = 0;
        bc.gridx = 0;
        bc.fill = 2;
        bc.ipady = 1;
        bc.weightx = 1.0;
        bc.gridwidth = 1;
        for (int b = 0; b < buttonNames.length; ++b) {
            String name = buttonNames[b];
            if (name == null) {
                JLabel lab = new JLabel(" ");
                bc.fill = 1;
                bc.weighty = 1.0;
                buttons.add((Component)lab, bc);
                bc.fill = 2;
                bc.weighty = 0.0;
            } else {
                JButton but = new JButton(JSpellComponent.lmsg(name));
                but.setActionCommand(name);
                but.addActionListener(this);
                buttons.add((Component)but, bc);
                this.buttons_[b] = but;
            }
            bc.insets.top = 3;
            ++bc.gridy;
        }
    }

    private void clearText(JTextComponent comp) {
        try {
            Document doc = comp.getDocument();
            doc.remove(0, doc.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String lmsg(String id) {
        try {
            String resourceString = resources.getString(id);
            return resourceString;
        }
        catch (Exception e) {
            System.err.println("JSpellComponet: Could not find string for: " + id);
            e.printStackTrace();
            return id.replace('_', ' ');
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            resources = ResourceBundle.getBundle("azcheck.ui.JSpellComponent");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

