/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.ui.JSpellComponent;
import azcheck.ui.JTextAutoSpellCheck;
import azcheck.ui.JTextSource;
import azcheck.ui.SpellControl;
import azcheck.ui.TextSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class JSpellDialog
extends JDialog
implements ActionListener {
    JSpellComponent component_;
    static JSpellDialog StaticDialog = null;
    public static final int TOP_OUT = -2;
    public static final int TOP_IN = -1;
    public static final int CENTER = 0;
    public static final int BOTTOM_IN = 1;
    public static final int BOTTOM_OUT = 2;
    public static final int LEFTS_OUT = -2;
    public static final int LEFTS_IN = -1;
    public static final int RIGHTS_IN = 1;
    public static final int RIGHTS_OUT = 2;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$javax$swing$JDialog;
    static /* synthetic */ Class class$java$awt$Window;

    public JSpellDialog(JFrame owner, JTextComponent source, String dictPath, String defaultDictionary) throws Exception {
        this(owner, (TextSource)new JTextSource(source), dictPath, defaultDictionary, true);
    }

    public JSpellDialog(JFrame owner, TextSource source, String dictPath, String defaultDictionary, boolean modal) throws Exception {
        super(owner, JSpellComponent.lmsg("Spell-Checker"), modal);
        JSpellComponent spellComponent = new JSpellComponent(source, dictPath);
        this.setComponent(spellComponent);
        spellComponent.setPersonalDictionary("%L%.tdi");
        spellComponent.loadPrefs();
        if (defaultDictionary != null) {
            spellComponent.selectDictionary(defaultDictionary);
        }
    }

    public JSpellDialog(JDialog owner, TextSource source, String dictPath, String defaultDictionary, boolean modal) throws Exception {
        super(owner, JSpellComponent.lmsg("Spell-Checker"), modal);
        JSpellComponent spellComponent = new JSpellComponent(source, dictPath);
        this.setComponent(spellComponent);
        spellComponent.setPersonalDictionary("%L%.tdi");
        spellComponent.loadPrefs();
        if (defaultDictionary != null) {
            spellComponent.selectDictionary(defaultDictionary);
        }
    }

    public static void check(JTextComponent textComponent, String dictionary) throws Exception {
        JSpellDialog.initStaticChecker(textComponent, dictionary);
        int selStart = textComponent.getSelectionStart();
        int selEnd = textComponent.getSelectionEnd();
        textComponent.setCaretPosition(0);
        StaticDialog.setSource(new JTextSource(textComponent));
        if (JSpellDialog.StaticDialog.getSize().width == 0) {
            JSpellDialog.place(StaticDialog, textComponent, 2, -1);
        }
        StaticDialog.popup(true);
        textComponent.select(selStart, selEnd);
        SpellControl checker = StaticDialog.getChecker();
        checker.savePersonalDictionaries();
        JSpellComponent spellComponent = StaticDialog.getComponent();
        spellComponent.savePrefs();
    }

    public static JTextAutoSpellCheck enableAutoCheck(JTextComponent textComponent, String dictionary) throws Exception {
        JTextAutoSpellCheck autoSpellListener = null;
        JSpellDialog.initStaticChecker(textComponent, dictionary);
        JTextAutoSpellCheck.stopChecking(textComponent);
        autoSpellListener = new JTextAutoSpellCheck(textComponent, StaticDialog.getChecker(), dictionary, true);
        return autoSpellListener;
    }

    public static void disableAutoCheck(JTextComponent textComponent) {
        try {
            JSpellDialog.initStaticChecker(textComponent, null);
            JTextAutoSpellCheck.stopChecking(textComponent);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(StaticDialog, "** Error: " + ex);
            ex.printStackTrace();
        }
    }

    public static JSpellDialog getStaticDialog() {
        return StaticDialog;
    }

    public static JSpellComponent getStaticComponent() {
        if (StaticDialog != null) {
            return StaticDialog.getComponent();
        }
        return null;
    }

    public static SpellControl getStaticChecker() {
        if (StaticDialog != null) {
            return StaticDialog.getComponent().getChecker();
        }
        return null;
    }

    static void loadPrefrences() {
        if (StaticDialog != null) {
            JSpellComponent spellComponent = StaticDialog.getComponent();
            spellComponent.loadPrefs();
        }
    }

    static void initStaticChecker(JTextComponent textComponent, String dictionary) throws Exception {
        if (textComponent == null) {
            throw new IllegalArgumentException("null Text Component");
        }
        if (StaticDialog == null) {
            String dict;
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = JSpellDialog.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, textComponent);
            String string = dict = dictionary == null ? "en" : dictionary;
            if (frame != null) {
                StaticDialog = new JSpellDialog(frame, null, null, dict, true);
            } else {
                JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = JSpellDialog.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, textComponent);
                StaticDialog = dialog != null ? new JSpellDialog(dialog, null, null, dict, true) : new JSpellDialog(new JFrame(), null, null, dict, true);
            }
        }
        if (dictionary == null) {
            StaticDialog.getComponent().selectDictionary();
        } else {
            StaticDialog.getComponent().selectDictionary(dictionary);
        }
    }

    public TextSource getSource() {
        return this.getComponent().getSource();
    }

    public void setSource(TextSource source) {
        this.getComponent().setSource(source);
    }

    public void setSource(JTextComponent source) {
        this.getComponent().setSource(new JTextSource(source));
    }

    public JSpellComponent getComponent() {
        return this.component_;
    }

    public SpellControl getChecker() {
        return this.getComponent().getChecker();
    }

    void setComponent(JSpellComponent component) {
        this.component_ = component;
        this.component_.addActionListener(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.component_, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    JSpellDialog.this.component_.done();
                    JSpellDialog.this.popup(false);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(JSpellDialog.this, "** Error: " + ex);
                }
            }
        });
        AbstractAction act = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JSpellDialog.this.component_.done();
                    JSpellDialog.this.popup(false);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(JSpellDialog.this, "** Error: " + ex);
                }
            }
        };
        this.getRootPane().getActionMap().put("close", act);
        int stdMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap im = this.getRootPane().getInputMap(1);
        im.put(KeyStroke.getKeyStroke(87, stdMask), "close");
        im.put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("spell_done")) {
            this.popup(false);
        }
    }

    public void popup(boolean visible) {
        if (visible) {
            try {
                this.component_.check();
            }
            catch (Exception e) {
                this.component_.status("** Error: " + e);
                e.printStackTrace();
            }
            this.pack();
            super.setVisible(true);
            this.toFront();
        } else {
            super.setVisible(false);
            this.dispose();
        }
    }

    public static void place(Window tool, Component parent, int xplace, int yplace) {
        Dimension screen = parent.getToolkit().getScreenSize();
        tool.pack();
        Dimension tdim = tool.getSize();
        Window top = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = JSpellDialog.class$("java.awt.Window")) : class$java$awt$Window, tool);
        Rectangle pr = top.getBounds();
        int x = pr.x;
        switch (xplace) {
            case -2: {
                x = pr.x - tdim.width;
                break;
            }
            case -1: {
                x = pr.x;
                break;
            }
            case 0: {
                x = pr.x + (pr.width - tdim.width) / 2;
                break;
            }
            case 1: {
                x = pr.x + pr.width - tdim.width;
                break;
            }
            case 2: {
                x = pr.x + pr.width;
            }
        }
        if (x < 0) {
            x = 0;
        } else if (x + tdim.width > screen.width) {
            x = screen.width - tdim.width;
        }
        int y = pr.y;
        switch (yplace) {
            case -2: {
                y = pr.y - tdim.height;
                break;
            }
            case -1: {
                y = pr.y;
                break;
            }
            case 0: {
                y = pr.y + (pr.height - tdim.height) / 2;
                break;
            }
            case 1: {
                y = pr.y + pr.height - tdim.height;
                break;
            }
            case 2: {
                y = pr.y + pr.height;
            }
        }
        if (y < 0) {
            y = 0;
        } else if (y + tdim.height > screen.height) {
            y = screen.height - tdim.height;
        }
        tool.setLocation(x, y);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

