/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.EditableWord;
import azcheck.engine.SpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JSpellDictEdit
extends JDialog
implements ActionListener,
ListSelectionListener {
    SpellChecker checker_;
    DictionaryManagerItem[] languages_;
    private JComboBox languageBox_;
    private JList dictList_;
    private JList wordList_;
    private JViewport wordPort_;
    private EditableWord[] ewords_;
    private static ResourceBundle resources = null;

    JSpellDictEdit(JFrame parent, SpellChecker checker) {
        super((Frame)parent, true);
        this.setTitle(JSpellDictEdit.lmsg("Dictionary_management"));
        this.checker_ = checker;
        Container work = this.getContentPane();
        work.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 8, 3, 8);
        c.anchor = 17;
        c.gridy = 0;
        c.gridx = 0;
        JLabel dictsLabel = new JLabel(JSpellDictEdit.lmsg("dictionaries"));
        work.add((Component)dictsLabel, c);
        ++c.gridy;
        String[] data = new String[]{" ", " ", " ", " ", " ", "mmmmmmmmmmmmmm"};
        this.dictList_ = new JList<String>(data);
        this.dictList_.addListSelectionListener(this);
        this.dictList_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.dictList_.setMinimumSize(this.dictList_.getPreferredSize());
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        work.add((Component)this.dictList_, c);
        ++c.gridy;
        c.fill = 0;
        String curLang = this.checker_.getSelectedLanguage();
        JLabel curLangLabel = new JLabel(JSpellDictEdit.lmsg("current_language"));
        work.add((Component)curLangLabel, c);
        ++c.gridy;
        try {
            this.languages_ = this.checker_.listLanguages();
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this, "Error on dictionary lookup: " + ioex.getMessage());
        }
        String[] langNames = new String[this.languages_.length];
        int index = -1;
        for (int l = 0; l < this.languages_.length; ++l) {
            DictionaryManagerItem lgItem = this.languages_[l];
            langNames[l] = lgItem.local;
            if (!lgItem.name.equals(curLang)) continue;
            index = l;
        }
        this.languageBox_ = new JComboBox<String>(langNames);
        this.languageBox_.setEditable(false);
        this.languageBox_.setActionCommand("select_language");
        this.languageBox_.addActionListener(this);
        c.fill = 2;
        work.add((Component)this.languageBox_, c);
        ++c.gridy;
        int lowestRow = c.gridy;
        ++c.gridx;
        c.gridy = 0;
        JLabel wordsLabel = new JLabel(JSpellDictEdit.lmsg("words"));
        work.add((Component)wordsLabel, c);
        ++c.gridy;
        String[] wdata = new String[]{" ", " ", " ", " ", " ", " ", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmm"};
        this.wordList_ = new JList<String>(wdata);
        this.wordList_.addListSelectionListener(this);
        this.wordList_.setBorder(BorderFactory.createLoweredBevelBorder());
        this.wordList_.setMinimumSize(this.wordList_.getPreferredSize());
        JScrollPane wordPane = new JScrollPane(this.wordList_);
        this.wordPort_ = wordPane.getViewport();
        wordPane.setMinimumSize(wordPane.getPreferredSize());
        c.fill = 1;
        c.weighty = 1.0;
        work.add((Component)wordPane, c);
        ++c.gridy;
        c.fill = 0;
        JButton removeWord_ = new JButton(JSpellDictEdit.lmsg("remove_word"));
        removeWord_.setActionCommand("remove_word");
        removeWord_.addActionListener(this);
        work.add((Component)removeWord_, c);
        ++c.gridy;
        JPanel buttons = new JPanel(new GridLayout(1, 2, 16, 0));
        c.insets.top = 20;
        c.anchor = 13;
        c.gridy = Math.max(lowestRow, c.gridy);
        work.add((Component)buttons, c);
        JButton button = new JButton(JSpellDictEdit.lmsg("OK"));
        button.setActionCommand("ok");
        button.addActionListener(this);
        buttons.add(button);
        this.getRootPane().setDefaultButton(button);
        button = new JButton(JSpellDictEdit.lmsg("Cancel"));
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttons.add(button);
        this.pack();
        wordPane.setMinimumSize(wordPane.getPreferredSize());
        this.setLanguage(index);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.dictList_) {
            this.getWords();
        } else if (e.getSource() == this.wordList_) {
            // empty if block
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        try {
            int index;
            if (command.equals("ok")) {
                this.ok();
            } else if (command.equals("cancel")) {
                this.cancel();
            } else if (command.equals("select_language")) {
                this.setLanguage(this.languageBox_.getSelectedIndex());
            } else if (command.equals("remove_word") && (index = this.wordList_.getSelectedIndex()) >= 0) {
                EditableWord word = this.ewords_[index];
                word.type = -1;
                this.checker_.changeWord(word);
                this.getWords();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void ok() {
        this.setVisible(false);
    }

    void cancel() {
        this.setVisible(false);
    }

    void setLanguage(int index) {
        this.languageBox_.setSelectedIndex(index);
        if (index >= 0) {
            try {
                this.checker_.setSelectedLanguage(this.languages_[index].name);
                String[] editables = this.checker_.listEditableDictionaries();
                this.dictList_.setListData(editables);
                this.getWords();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void getWords() {
        try {
            if (this.checker_.manageEditableDictionary((String)this.dictList_.getSelectedValue(), 0)) {
                this.ewords_ = this.checker_.getEditableWords();
                String[] words = new String[this.ewords_.length];
                for (int w = 0; w < this.ewords_.length; ++w) {
                    words[w] = this.ewords_[w].word + " " + JSpellDictEdit.lmsg("ewtype" + this.ewords_[w].type, this.ewords_[w].value);
                }
                this.wordList_.setListData(words);
            } else {
                this.wordList_.setListData(new String[]{" "});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String lmsg(String id) {
        try {
            return resources.getString(id);
        }
        catch (Exception e) {
            return id.replace('_', ' ');
        }
    }

    public static String lmsg(String id, Object arg0) {
        String message = null;
        try {
            message = resources.getString(id);
        }
        catch (MissingResourceException e) {
            return id;
        }
        return MessageFormat.format(message, arg0);
    }

    static {
        try {
            resources = ResourceBundle.getBundle("azcheck.ui.JSpellDictEdit");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

