/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.SpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JSpellOptions
extends JDialog
implements ActionListener {
    SpellChecker checker_;
    DictionaryManagerItem[] languages_;
    JCheckBox ignoreCase_;
    JCheckBox ignoreMixedCase_;
    JCheckBox ignoreDigits_;
    JCheckBox ignoreDuplicates_;
    JCheckBox ignoreURL_;
    JCheckBox checkPunctuation_;
    JCheckBox autoReplace_;
    JCheckBox allowCompound_;
    JCheckBox allowPrefixes_;
    JCheckBox allowFileExtensions_;
    JComboBox suggestForce_;
    JComboBox language_;
    private static ResourceBundle resources = null;

    JSpellOptions(JFrame parent, SpellChecker checker) {
        super((Frame)parent, true);
        this.setTitle(JSpellOptions.lmsg("option_dialog"));
        this.checker_ = checker;
        Container work = this.getContentPane();
        work.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 8, 3, 8);
        c.anchor = 17;
        c.gridy = 0;
        c.gridx = 0;
        this.ignoreCase_ = new JCheckBox(JSpellOptions.lmsg("Ignore_case"), checker.getIgnoreCase());
        work.add((Component)this.ignoreCase_, c);
        ++c.gridy;
        this.ignoreMixedCase_ = new JCheckBox(JSpellOptions.lmsg("Ignore_mixed_case_words"), checker.getIgnoreMixedCase());
        work.add((Component)this.ignoreMixedCase_, c);
        ++c.gridy;
        this.ignoreDigits_ = new JCheckBox(JSpellOptions.lmsg("Ignore_words_with_digits"), checker.getIgnoreDigits());
        work.add((Component)this.ignoreDigits_, c);
        ++c.gridy;
        this.ignoreDuplicates_ = new JCheckBox(JSpellOptions.lmsg("Ignore_duplicates"), checker.getIgnoreDuplicates());
        work.add((Component)this.ignoreDuplicates_, c);
        ++c.gridy;
        this.ignoreURL_ = new JCheckBox(JSpellOptions.lmsg("Ignore_URL"), checker.getIgnoreURL());
        work.add((Component)this.ignoreURL_, c);
        ++c.gridy;
        int lowestRow = c.gridy;
        ++c.gridx;
        c.gridy = 0;
        this.checkPunctuation_ = new JCheckBox(JSpellOptions.lmsg("Check_punctuation"), checker.getCheckPunctuation());
        work.add((Component)this.checkPunctuation_, c);
        ++c.gridy;
        this.autoReplace_ = new JCheckBox(JSpellOptions.lmsg("Enable_auto_replace"), checker.getAutoReplace());
        work.add((Component)this.autoReplace_, c);
        ++c.gridy;
        this.allowCompound_ = new JCheckBox(JSpellOptions.lmsg("Allow_compound_words"), checker.getAllowCompound());
        work.add((Component)this.allowCompound_, c);
        ++c.gridy;
        this.allowPrefixes_ = new JCheckBox(JSpellOptions.lmsg("Allow_general_prefixes"), checker.getAllowPrefixes());
        work.add((Component)this.allowPrefixes_, c);
        ++c.gridy;
        this.allowFileExtensions_ = new JCheckBox(JSpellOptions.lmsg("Allow_file_extensions"), checker.getAllowFileExtensions());
        work.add((Component)this.allowFileExtensions_, c);
        ++c.gridy;
        lowestRow = Math.max(c.gridy, lowestRow);
        JLabel forceLabel = new JLabel(JSpellOptions.lmsg("suggestion_force"));
        c.gridx = 0;
        c.gridy = lowestRow++;
        c.fill = 0;
        c.anchor = 13;
        work.add((Component)forceLabel, c);
        this.suggestForce_ = new JComboBox<String>(new String[]{JSpellOptions.lmsg("Less_suggestions"), JSpellOptions.lmsg("Normal_suggestions"), JSpellOptions.lmsg("More_suggestions")});
        this.suggestForce_.setSelectedIndex(checker.getSuggestionForce() - 2);
        c.anchor = 17;
        ++c.gridx;
        work.add((Component)this.suggestForce_, c);
        JPanel buttons = new JPanel(new GridLayout(1, 2, 16, 0));
        c.gridwidth = 2;
        c.gridy = lowestRow;
        c.insets = new Insets(15, 0, 8, 8);
        c.anchor = 13;
        work.add((Component)buttons, c);
        JButton button = new JButton(JSpellOptions.lmsg("OK"));
        button.setActionCommand("ok");
        button.addActionListener(this);
        buttons.add(button);
        this.getRootPane().setDefaultButton(button);
        button = new JButton(JSpellOptions.lmsg("Cancel"));
        button.setActionCommand("cancel");
        button.addActionListener(this);
        buttons.add(button);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("ok")) {
            this.ok();
        } else if (command.equals("cancel")) {
            this.cancel();
        }
    }

    void ok() {
        this.checker_.setIgnoreCase(this.ignoreCase_.isSelected());
        this.checker_.setIgnoreMixedCase(this.ignoreMixedCase_.isSelected());
        this.checker_.setIgnoreDigits(this.ignoreDigits_.isSelected());
        this.checker_.setIgnoreDuplicates(this.ignoreDuplicates_.isSelected());
        this.checker_.setIgnoreURL(this.ignoreURL_.isSelected());
        this.checker_.setCheckPunctuation(this.checkPunctuation_.isSelected());
        this.checker_.setAutoReplace(this.autoReplace_.isSelected());
        this.checker_.setAllowCompound(this.allowCompound_.isSelected());
        this.checker_.setAllowPrefixes(this.allowPrefixes_.isSelected());
        this.checker_.setAllowFileExtensions(this.allowFileExtensions_.isSelected());
        int force = this.suggestForce_.getSelectedIndex();
        this.checker_.setSuggestionForce(force + 2);
        this.setVisible(false);
    }

    void cancel() {
        this.setVisible(false);
    }

    private static String lmsg(String id) {
        try {
            return resources.getString(id);
        }
        catch (Exception e) {
            return id.replace('_', ' ');
        }
    }

    static {
        try {
            resources = ResourceBundle.getBundle("azcheck.ui.JSpellOptions");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

