/*
 * Decompiled with CFR 0.152.
 */
package azcheck.util;

public class ByteBuffer {
    byte[] data_ = new byte[4];
    int size_ = 0;

    public ByteBuffer(int alloc) {
        this.extend(alloc);
    }

    public byte get(int pos) {
        return this.data_[pos];
    }

    public void append(byte b) {
        if (this.size_ >= this.data_.length) {
            this.extend(this.data_.length / 2);
        }
        this.data_[this.size_++] = b;
    }

    public void insert(byte b, int position) {
        if (this.size_ >= this.data_.length) {
            this.extend(this.data_.length / 2);
        }
        System.arraycopy(this.data_, position, this.data_, position + 1, this.size_ - position);
        this.data_[position] = b;
        ++this.size_;
    }

    public void setSize(int size) {
        this.size_ = size;
    }

    public int getSize() {
        return this.size_;
    }

    public byte[] toArray() {
        byte[] ba = new byte[this.size_];
        System.arraycopy(this.data_, 0, ba, 0, this.size_);
        return ba;
    }

    void extend(int delta) {
        if (delta > 0) {
            byte[] nb = new byte[this.data_.length + delta];
            System.arraycopy(this.data_, 0, nb, 0, this.data_.length);
            this.data_ = nb;
        }
    }
}

