/*
 * Decompiled with CFR 0.152.
 */
package azcheck.util;

import azcheck.util.DataReader;

public class CoreReader
implements DataReader {
    byte[] data_;
    int ptr_;

    public CoreReader(byte[] data) {
        this.data_ = data;
        this.ptr_ = 0;
    }

    public byte[] getData() {
        return this.data_;
    }

    public void seek(int position) {
        this.ptr_ = position;
    }

    public void skip(int count) {
        this.ptr_ += count;
    }

    public byte getByte() {
        return this.data_[this.ptr_++];
    }

    public int getInt(int byteCnt) {
        int v = this.data_[this.ptr_++] & 0xFF;
        if (byteCnt > 1) {
            v += (this.data_[this.ptr_++] & 0xFF) << 8;
        }
        if (byteCnt > 2) {
            v += (this.data_[this.ptr_++] & 0xFF) << 16;
        }
        if (byteCnt > 3) {
            v += (this.data_[this.ptr_++] & 0xFF) << 24;
        }
        return v;
    }

    public int[] getIntArray(int size, int byteCnt) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.getInt(byteCnt);
        }
        return array;
    }

    public int getInt() {
        return this.getInt(4);
    }

    public int getVarInt() {
        throw new RuntimeException("not implemented");
    }

    public byte[] getBytes(int size) {
        byte[] v = new byte[size];
        System.arraycopy(this.data_, this.ptr_, v, 0, size);
        this.ptr_ += size;
        return v;
    }

    public String getString() {
        int size = this.getInt(4);
        char[] tmp = new char[size];
        for (int i = 0; i < size; ++i) {
            tmp[i] = (char)this.getInt(2);
        }
        return new String(tmp);
    }

    public int sortedArrayFind(byte b, int range) {
        int p1 = this.ptr_;
        int p2 = this.ptr_ + range;
        int basis = this.ptr_;
        this.ptr_ = p2;
        if (range == 1) {
            return this.data_[basis] == b ? 0 : -1;
        }
        while (p1 < p2) {
            int probe = (p1 + p2) / 2;
            if (this.data_[probe] == b) {
                return probe - basis;
            }
            if (this.data_[probe] > b) {
                p2 = probe;
                continue;
            }
            p1 = probe + 1;
        }
        return -1;
    }
}

