/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import com.appframework.Application;
import com.appframework.ApplicationFrameActionList;
import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.Assertions;
import com.appframework.utils.IDGenerator;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.ClickAction;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWStatusBar;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendar;
import com.novell.gw.jclient.application.frames.compose.FrameComposeAppointment;
import com.novell.gw.jclient.application.frames.compose.FrameComposeMail;
import com.novell.gw.jclient.application.frames.compose.FrameComposePhone;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.frames.compose.FrameComposeReminderNote;
import com.novell.gw.jclient.application.frames.compose.FrameComposeTask;
import com.novell.gw.jclient.application.helpsystem.HelpManager;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class ApplicationFrame
extends JFrame
implements MVCView,
IdentifiedObject {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$ApplicationFrame == null ? (class$com$appframework$ApplicationFrame = ApplicationFrame.class$("com.appframework.ApplicationFrame")) : class$com$appframework$ApplicationFrame));
    public static final int CASCADE_X = 20;
    public static final int CASCADE_Y = 20;
    public static final int SMART_CASCADE_X = 60;
    public static final int SMART_CASCADE_Y = 40;
    public static final int SMART_CASCADE_EDGE_SPACE_X = 20;
    public static final int SMART_CASCADE_EDGE_SPACE_Y = 20;
    public static final int SMART_CASCADE_MIN_X = 1;
    public static final int SMART_CASCADE_MIN_Y = 1;
    protected ApplicationFrameActionList appActionList;
    private String id;
    protected JPanel centeredContentPanel;
    protected GWStatusBar panStatusPanel;
    protected HelpManager helpManager;
    protected String optionFrameName;
    protected GWToolBarPanel gwToolBarPanel;
    protected String toolBarName;
    protected String userGuid;
    static /* synthetic */ Class class$com$appframework$ApplicationFrame;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$calendar$FrameCalendar;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$compose$FrameComposeAppointment;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$compose$FrameComposeMail;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$compose$FrameComposePhone;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$compose$FrameComposePostedItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$compose$FrameComposeReminderNote;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$compose$FrameComposeTask;

    public ApplicationFrame(String string, String string2, String string3) {
        this.userGuid = string3;
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setDefaultCloseOperation(0);
        this.id = IDGenerator.getUIDAsString();
        this.optionFrameName = string2;
        this.buildUI(string);
        Application.addFrame(this);
    }

    public void setAppActionList(ApplicationFrameActionList applicationFrameActionList) {
        this.setController(applicationFrameActionList);
        this.addWindowListener(applicationFrameActionList);
    }

    public ApplicationFrameActionList getAppActionList() {
        return this.appActionList;
    }

    protected void beforeShow() {
    }

    protected void afterShow() {
    }

    public void beforeDispose() {
    }

    public String getID() {
        return this.id;
    }

    public void showToolbar() {
        boolean bl = ApplicationOptions.getInstance().getBoolean(this.toolBarName, true);
        if (bl) {
            this.getContentPane().add((Component)this.gwToolBarPanel, "North");
        } else {
            this.getContentPane().remove(this.gwToolBarPanel);
        }
        ((JPanel)this.getContentPane()).updateUI();
    }

    public void setController(MVCController mVCController) {
        if (!(mVCController instanceof ApplicationFrameActionList)) {
            Assertions.assertIllegalArgument("Not valid controller");
        }
        this.appActionList = (ApplicationFrameActionList)mVCController;
    }

    public String getUserGuid() {
        return this.userGuid;
    }

    public void setUserGuid(String string) {
        this.userGuid = string;
    }

    public void release() {
        this.removeWindowListener(this.getAppActionList());
        this.setJMenuBar(null);
        this.getContentPane().removeAll();
        this.getRootPane().removeAll();
        this.getLayeredPane().removeAll();
        this.removeAll();
        this.setFocusTraversalPolicy(null);
        this.appActionList = null;
        this.centeredContentPanel = null;
        this.panStatusPanel = null;
        this.helpManager = null;
        this.gwToolBarPanel = null;
    }

    public MVCController getController() {
        return this.getAppActionList();
    }

    public void setMVCModel(Object object) {
    }

    public Object getMVCModel() {
        return null;
    }

    protected Dimension getFrameSize() {
        int n = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_HEIGHT", 590);
        int n2 = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_WIDTH", 700);
        return new Dimension(n2, n);
    }

    public void showMe(int n, int n2) {
        Cloneable cloneable;
        logger.debug((Object)"frame ***** ------------------- showMe(x, y) entered");
        Dimension dimension = this.getFrameSize();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setPreferredSize(dimension);
        int n3 = dimension.width;
        int n4 = dimension.height;
        if (n < 0) {
            logger.debug((Object)"frame ***** x < 0");
            n = 0;
        }
        if (n2 < 0) {
            logger.debug((Object)"frame ***** y < 0");
            n2 = 0;
        }
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (n + n3 > dimension2.width || n2 + n4 > dimension2.height) {
            cloneable = this.calculateNewCascadeStartCoords(dimension2.width - n3, dimension2.height - n4);
            n = cloneable.x;
            n2 = cloneable.y;
        }
        this.beforeShow();
        cloneable = new Rectangle(n, n2, n3, n4);
        this.setBounds((Rectangle)cloneable);
        this.setVisible(true);
        this.afterShow();
        logger.debug((Object)"frame ***** ------------------- showMe(x, y) exited");
    }

    protected Point calculateNewCascadeStartCoords(int n, int n2) {
        logger.debug((Object)"frame ***** calculation for new cascade starting point entered");
        Point[] pointArray = Application.getGWFrameCoords(this.getClass(), this);
        int n3 = 60;
        int n4 = 40;
        while (n3 > 1 & n4 > 1) {
            logger.debug((Object)("frame ***** xCascade=" + n3 + "; yCascade=" + n4));
            for (int i = 20; i < n; i += n3) {
                int n5 = 20;
                for (int j = i; n5 < n2 && j < n && j >= 20; n5 += n4, j -= n3) {
                    logger.debug((Object)("frame ***** checking space at: x=" + j + "; y=" + n5));
                    boolean bl = true;
                    for (int k = 0; k < pointArray.length; ++k) {
                        if (pointArray[k].x < j || pointArray[k].x >= j + n3 || pointArray[k].y < n5 || pointArray[k].y >= n5 + n4) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    logger.debug((Object)("frame ***** OPENING FRAME AT: x=" + j + "; y=" + n5));
                    return new Point(j, n5);
                }
            }
            n3 /= 2;
            n4 /= 2;
        }
        return new Point(0, 0);
    }

    public void showMe() {
        int n;
        int n2;
        logger.debug((Object)"frame ***** ------------------- showMe() entered");
        if (this instanceof GWMainAppFrame && Application.getGWMainAppFramesCount() >= 2 || this instanceof FrameCalendar && Application.getGWFramesCount(class$com$novell$gw$jclient$application$frames$calendar$FrameCalendar == null ? (class$com$novell$gw$jclient$application$frames$calendar$FrameCalendar = ApplicationFrame.class$("com.novell.gw.jclient.application.frames.calendar.FrameCalendar")) : class$com$novell$gw$jclient$application$frames$calendar$FrameCalendar) >= 2 || this instanceof FrameComposeAppointment && Application.getGWFramesCount(class$com$novell$gw$jclient$application$frames$compose$FrameComposeAppointment == null ? (class$com$novell$gw$jclient$application$frames$compose$FrameComposeAppointment = ApplicationFrame.class$("com.novell.gw.jclient.application.frames.compose.FrameComposeAppointment")) : class$com$novell$gw$jclient$application$frames$compose$FrameComposeAppointment) >= 2 || this instanceof FrameComposeMail && Application.getGWFramesCount(class$com$novell$gw$jclient$application$frames$compose$FrameComposeMail == null ? (class$com$novell$gw$jclient$application$frames$compose$FrameComposeMail = ApplicationFrame.class$("com.novell.gw.jclient.application.frames.compose.FrameComposeMail")) : class$com$novell$gw$jclient$application$frames$compose$FrameComposeMail) >= 2 || this instanceof FrameComposePhone && Application.getGWFramesCount(class$com$novell$gw$jclient$application$frames$compose$FrameComposePhone == null ? (class$com$novell$gw$jclient$application$frames$compose$FrameComposePhone = ApplicationFrame.class$("com.novell.gw.jclient.application.frames.compose.FrameComposePhone")) : class$com$novell$gw$jclient$application$frames$compose$FrameComposePhone) >= 2 || this instanceof FrameComposePostedItem && Application.getGWFramesCount(class$com$novell$gw$jclient$application$frames$compose$FrameComposePostedItem == null ? (class$com$novell$gw$jclient$application$frames$compose$FrameComposePostedItem = ApplicationFrame.class$("com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem")) : class$com$novell$gw$jclient$application$frames$compose$FrameComposePostedItem) >= 2 || this instanceof FrameComposeReminderNote && Application.getGWFramesCount(class$com$novell$gw$jclient$application$frames$compose$FrameComposeReminderNote == null ? (class$com$novell$gw$jclient$application$frames$compose$FrameComposeReminderNote = ApplicationFrame.class$("com.novell.gw.jclient.application.frames.compose.FrameComposeReminderNote")) : class$com$novell$gw$jclient$application$frames$compose$FrameComposeReminderNote) >= 2 || this instanceof FrameComposeTask && Application.getGWFramesCount(class$com$novell$gw$jclient$application$frames$compose$FrameComposeTask == null ? (class$com$novell$gw$jclient$application$frames$compose$FrameComposeTask = ApplicationFrame.class$("com.novell.gw.jclient.application.frames.compose.FrameComposeTask")) : class$com$novell$gw$jclient$application$frames$compose$FrameComposeTask) >= 2) {
            ApplicationFrame applicationFrame = Application.getLastFrame(this.getClass());
            if (applicationFrame != null) {
                n2 = applicationFrame.getLocation().x + 20;
                n = applicationFrame.getLocation().y + 20;
                logger.debug((Object)"frame ***** CASCADING");
            } else {
                n2 = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_X", 0);
                n = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_Y", 0);
                logger.debug((Object)"frame ***** BACK AT DEFAULT X, Y (NULL LASTFRAME)");
            }
        } else {
            n2 = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_X", 0);
            n = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_Y", 0);
            logger.debug((Object)"frame ***** BACK AT DEFAULT X, Y (NO FRAMES)");
        }
        this.showMe(n2, n);
    }

    private void buildUI(String string) {
        this.helpManager = new HelpManager(this);
        this.setTitle(string);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        boolean bl = this instanceof GWMainAppFrame;
        this.panStatusPanel = new GWStatusBar(bl);
        jPanel.add((Component)this.panStatusPanel, "South");
        this.centeredContentPanel = new OrientablePanel();
        this.centeredContentPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.centeredContentPanel, "Center");
        this.setIconImage(ImageResources.GW_ICON.getImage());
    }

    public void setStatusText(String string) {
        this.panStatusPanel.setMessage(string);
    }

    public void startStatusAnimation(ImageIcon imageIcon, String string, ClickAction clickAction) {
        this.panStatusPanel.setAnimation(imageIcon, string, clickAction);
        this.panStatusPanel.setMessage(string);
    }

    public void stopStatusAnimation() {
        this.panStatusPanel.setAnimation(null, null, null);
        this.panStatusPanel.setMessage("");
    }

    public String getOptionFrameName() {
        return this.optionFrameName;
    }

    public void setGWMenuBar(JMenuBar jMenuBar) {
        if (!(jMenuBar instanceof GWMenuBar)) {
            throw new IllegalArgumentException("Unsupported MenuBar type");
        }
        super.setJMenuBar(jMenuBar);
        jMenuBar.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    public GWMenuBar getGWMenuBar() {
        return (GWMenuBar)super.getJMenuBar();
    }

    public GWStatusBar getStatusBar() {
        return this.panStatusPanel;
    }

    public GWToolBarPanel getToolBarPanel() {
        return this.gwToolBarPanel;
    }

    public void setToolBarPanel(GWToolBarPanel gWToolBarPanel, String string) {
        this.gwToolBarPanel = gWToolBarPanel;
        this.getContentPane().add((Component)this.gwToolBarPanel, string);
    }

    public void updateOrientation(ComponentOrientation componentOrientation) {
        this.getJMenuBar().setComponentOrientation(componentOrientation);
        this.getToolBarPanel().setComponentOrientation(componentOrientation);
        this.validate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

