/*
 * Decompiled with CFR 0.152.
 */
package com.appframework;

import azcheck.engine.SpellException;
import azcheck.engine.Suggestions;
import azcheck.ui.JSpellDialog;
import azcheck.ui.SpellControl;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.ViewSourceFrame;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.apache.log4j.Logger;

public class SCMouseListener
extends MouseAdapter {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$SCMouseListener == null ? (class$com$appframework$SCMouseListener = SCMouseListener.class$("com.appframework.SCMouseListener")) : class$com$appframework$SCMouseListener));
    private JTextComponent target = null;
    private String word;
    private ApplicationOptions appOptions = ApplicationOptions.getInstance();
    private boolean isRTSpellCheckenabled = this.appOptions.getBoolean("SPELL_CHECKER_AS_YOU_TYPE", true);
    static /* synthetic */ Class class$com$appframework$SCMouseListener;

    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isDoubleClick(mouseEvent)) {
            this.doPopup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.doPopup(mouseEvent);
    }

    private void doPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && !mouseEvent.isConsumed()) {
            String string;
            JMenuItem jMenuItem;
            Object object;
            int n;
            int n2;
            int n3;
            JPopupMenu jPopupMenu = new JPopupMenu();
            SpellControl spellControl = JSpellDialog.getStaticChecker();
            Suggestions suggestions = null;
            try {
                Component component = mouseEvent.getComponent();
                if (component instanceof JTextComponent) {
                    this.target = (JTextComponent)component;
                    n3 = this.target.getSelectionStart();
                    if (n3 == (n2 = this.target.getSelectionEnd())) {
                        int n4 = this.target.viewToModel(mouseEvent.getPoint());
                        int n5 = Utilities.getWordStart(this.target, n4);
                        n = Utilities.getWordEnd(this.target, n4);
                        object = this.target.getDocument();
                        String string2 = object.getText(n5, n - n5);
                        String string3 = string2.trim();
                        boolean bl = "".equals(string3);
                        if (bl) {
                            this.word = null;
                        } else {
                            this.target.setCaretPosition(n5);
                            this.target.moveCaretPosition(n);
                            this.word = this.target.getSelectedText();
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                lookAndFeel.provideErrorFeedback(this.target);
            }
            boolean bl = this.target.isEditable();
            if (bl && spellControl != null) {
                try {
                    if (this.word != null && (n3 = spellControl.checkWord(this.word)) != 0) {
                        switch (n3) {
                            case 4: {
                                jMenuItem = new JMenuItem(StringResources.DUPLICATE_WORD);
                                jPopupMenu.add(jMenuItem);
                                break;
                            }
                            case 5: {
                                jMenuItem = new JMenuItem(StringResources.PUNCTUATION_PROBLEM);
                                jPopupMenu.add(jMenuItem);
                                break;
                            }
                            case 3: {
                                jMenuItem = new JMenuItem(StringResources.WORD_SHOULD_BE_CAPITALIZED);
                                jPopupMenu.add(jMenuItem);
                            }
                            case 2: {
                                suggestions = spellControl.getSuggestions(this.word);
                                n2 = suggestions.getCount();
                                if (n2 > 0) {
                                    ActionListener actionListener = new ActionListener(){

                                        public void actionPerformed(ActionEvent actionEvent) {
                                            String string = actionEvent.getActionCommand();
                                            SCMouseListener.this.target.replaceSelection(string);
                                        }
                                    };
                                    for (n = 0; n < n2; ++n) {
                                        String string4 = suggestions.getSuggestion(n);
                                        jMenuItem = new JMenuItem(string4);
                                        jMenuItem.addActionListener(actionListener);
                                        jPopupMenu.add(jMenuItem);
                                    }
                                    jPopupMenu.addSeparator();
                                }
                                jMenuItem = new JMenuItem(StringResources.LEARN_WORD);
                                ActionListener actionListener = new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        SpellControl spellControl = JSpellDialog.getStaticChecker();
                                        try {
                                            spellControl.add(SCMouseListener.this.word);
                                            spellControl.savePersonalDictionaries();
                                            SCMouseListener.this.target.replaceSelection(SCMouseListener.this.word);
                                        }
                                        catch (Exception exception) {
                                            logger.debug((Object)("Error: " + exception));
                                            exception.printStackTrace();
                                        }
                                    }
                                };
                                jMenuItem.addActionListener(actionListener);
                                jPopupMenu.add(jMenuItem);
                                jMenuItem = new JMenuItem(StringResources.IGNORE_WORD);
                                ActionListener actionListener2 = new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        SpellControl spellControl = JSpellDialog.getStaticChecker();
                                        try {
                                            spellControl.ignoreAll(SCMouseListener.this.word);
                                            SCMouseListener.this.target.replaceSelection(SCMouseListener.this.word);
                                        }
                                        catch (SpellException spellException) {
                                            logger.debug((Object)("Error: " + (Object)((Object)spellException)));
                                            spellException.printStackTrace();
                                        }
                                    }
                                };
                                jMenuItem.addActionListener(actionListener2);
                                jPopupMenu.add(jMenuItem);
                            }
                        }
                    }
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(StringResources.ACTION_RT_SPELL_CHECKER);
                    if (this.isRTSpellCheckenabled) {
                        jCheckBoxMenuItem.setSelected(true);
                    }
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (SCMouseListener.this.target != null) {
                                if (SCMouseListener.this.isRTSpellCheckenabled) {
                                    JSpellDialog.disableAutoCheck((JTextComponent)SCMouseListener.this.target);
                                    SCMouseListener.this.isRTSpellCheckenabled = false;
                                } else {
                                    try {
                                        JSpellDialog.enableAutoCheck((JTextComponent)SCMouseListener.this.target, (String)OS.getDictLanguage());
                                        SCMouseListener.this.isRTSpellCheckenabled = true;
                                    }
                                    catch (Exception exception) {
                                        SCMouseListener.this.appOptions.put("SPELL_CHECKER_AS_YOU_TYPE", new Boolean(false));
                                    }
                                }
                            }
                        }
                    };
                    jCheckBoxMenuItem.addActionListener(actionListener);
                    jPopupMenu.add(jCheckBoxMenuItem);
                    jPopupMenu.addSeparator();
                }
                catch (SpellException spellException) {
                    spellException.printStackTrace();
                }
            }
            n2 = (string = this.target.getSelectedText()) != null && string.length() > 0 ? 1 : 0;
            jMenuItem = new JMenuItem(StringResources.ACTION_CUT);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SCMouseListener.this.target.cut();
                }
            };
            jMenuItem.setEnabled(bl && n2 != 0);
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(StringResources.ACTION_COPY);
            ActionListener actionListener3 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SCMouseListener.this.target.copy();
                }
            };
            jMenuItem.addActionListener(actionListener3);
            jMenuItem.setEnabled(n2 != 0);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(StringResources.ACTION_PASTE);
            ActionListener actionListener4 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SCMouseListener.this.target.paste();
                }
            };
            jMenuItem.addActionListener(actionListener4);
            jMenuItem.setEnabled(bl);
            jPopupMenu.add(jMenuItem);
            if (((HTMLTextPane)this.target).getMode() == 1) {
                jPopupMenu.add(new JSeparator());
                jMenuItem = new JMenuItem(StringResources.VIEW_SOURCE);
                object = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ViewSourceFrame.display(SCMouseListener.this.target.getText());
                    }
                };
                jMenuItem.addActionListener((ActionListener)object);
                jMenuItem.setEnabled(true);
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

