/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components;

import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ArrayIcon
extends ImageIcon {
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_BOTTOM = 2;
    private Icon[] icons;
    private int width = -1;
    private int height = -1;
    private int hgap;
    private int valign;
    private BufferedImage bufferedImage;

    public ArrayIcon(Icon[] iconArray) {
        this(iconArray, 1, 2);
    }

    public ArrayIcon(Icon[] iconArray, int n) {
        this(iconArray, n, 2);
    }

    public ArrayIcon(Icon[] iconArray, int n, int n2) {
        this.icons = iconArray;
        this.hgap = n;
        this.valign = n2;
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
    }

    public int getIconHeight() {
        if (this.height < 0) {
            this.height = 0;
            for (int i = 0; i < this.icons.length; ++i) {
                this.height = Math.max(this.height, this.icons[i].getIconHeight());
            }
        }
        return this.height;
    }

    public int getIconWidth() {
        if (this.width < 0) {
            this.width = (this.icons.length - 1) * this.hgap;
            for (int i = 0; i < this.icons.length; ++i) {
                this.width += this.icons[i].getIconWidth();
            }
        }
        return this.width;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        graphics2D.setColor(graphics.getColor());
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            switch (this.valign) {
                case 1: {
                    n4 = 0;
                    break;
                }
                case 0: {
                    n4 = (this.height - this.icons[i].getIconHeight()) / 2;
                    break;
                }
                default: {
                    n4 = this.height - this.icons[i].getIconHeight();
                }
            }
            this.icons[i].paintIcon(component, graphics2D, n3, n4);
            n3 += this.icons[i].getIconWidth() + this.hgap;
        }
        graphics.drawImage(this.getImage(), n, n2, this.getImageObserver());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JLabel jLabel = new JLabel();
        jLabel.setBackground(Color.GREEN);
        jLabel.setIcon(ImageResources.ICON_UPDATING_CACHING);
        jLabel.setIcon(new ArrayIcon(new Icon[]{ImageResources.ICON_UPDATING_CACHING, ImageResources.ACT_CALENDAR_MONTHLY, ImageResources.ICON_ITEM_DELEGATED_FORWARDED, ImageResources.ICON_QUICKVIEWER, ImageResources.MSEXCEL_DOCUMENT, ImageResources.ICON_ITEM_DELEGATED_FORWARDED, ImageResources.ICON_STATUS_ALARM}, 15));
        jFrame.getContentPane().add(jLabel);
        jFrame.setSize(840, 350);
        jFrame.show();
    }
}

