/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.appframework.components.GWBorder;
import com.appframework.components.customizedbutton.ActionWithSepName;
import com.appframework.components.customizedbutton.CustomizedButton;
import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public abstract class AbstractPopupPane
extends GWToolBar
implements CustomizedButton {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$customizedbutton$AbstractPopupPane == null ? (class$com$appframework$components$customizedbutton$AbstractPopupPane = AbstractPopupPane.class$("com.appframework.components.customizedbutton.AbstractPopupPane")) : class$com$appframework$components$customizedbutton$AbstractPopupPane));
    public static final int STATE_UP = 1;
    public static final int STATE_NORMAL = 4;
    public static final int STATE_DOWN = 8;
    protected static final int BUTTON_LEFT_PRESSED = 16;
    protected static final int BUTTON_RIGHT_PRESSED = 20;
    protected JButton btnLeft = new ToolBarButton();
    protected JButton btnRight = new RightButton();
    protected JPopupMenu pumActions;
    protected List actionsList = new ArrayList();
    protected ActionWithSepName defaultAction;
    protected Icon iconNormal;
    private int iconPosition;
    private boolean isUnderMouse;
    protected boolean isPopupShowed;
    protected boolean isEnabled = true;
    private boolean isTextVisible = true;
    protected DefaultActionPropertyListener propertyListener = new DefaultActionPropertyListener();
    static /* synthetic */ Class class$com$appframework$components$customizedbutton$AbstractPopupPane;

    private AbstractPopupPane() {
        this.btnLeft.addMouseListener(new LeftButtonMouseListener());
        this.btnRight.addMouseListener(new RightButtonMouseListener());
        this.btnRight.setIcon(ImageResources.ARROW_DOWN);
        this.setBorder(null);
        this.build();
    }

    protected AbstractPopupPane(Action action, String string) {
        this();
        this.setDefaultAction(action, string);
    }

    private void build() {
        this.setIconPosition(UIUtils.getComponentOrientation().isLeftToRight() ? 2 : 4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Border border = this.btnLeft.getBorder();
        this.add((Component)this.btnLeft, gridBagConstraints);
        this.btnLeft.setBorder(border);
        this.add((Component)this.btnLeft, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.btnRight, gridBagConstraints);
    }

    public void addAction(Action action) {
        this.addAction(action, (String)action.getValue("Name"));
    }

    public void addAction(Action action, String string) {
        if (action == null || string == null) {
            throw new NullPointerException();
        }
        this.actionsList.add(new ActionWithSepName(action, string));
    }

    public Action getDefaultAction() {
        if (this.defaultAction != null) {
            return this.defaultAction.getAction();
        }
        return null;
    }

    public void setDefaultAction(Action action) {
        if (action != null) {
            this.setDefaultAction(action, (String)action.getValue("Name"));
        }
    }

    public abstract void setDefaultAction(Action var1, String var2);

    public void setIcon(Icon icon) {
        this.iconNormal = icon;
        this.btnLeft.setIcon(icon);
    }

    private void mouseEntered() {
        this.btnLeft.getModel().setRollover(true);
        this.btnRight.getModel().setRollover(true);
        this.isUnderMouse = true;
        this.changeState(1);
    }

    private void mouseExited() {
        this.btnLeft.getModel().setRollover(false);
        this.btnRight.getModel().setRollover(false);
        this.btnRight.getModel().setPressed(false);
        this.btnLeft.getModel().setArmed(false);
        this.btnLeft.getModel().setPressed(false);
        this.btnLeft.getModel().setArmed(true);
        this.btnRight.getModel().setArmed(true);
        this.isUnderMouse = false;
        this.changeState(4);
    }

    protected void changeState(int n) {
        if (!this.isPopupShowed && this.isEnabled) {
            if (n == 1 || n == 8) {
                this.btnLeft.setIcon(this.iconNormal);
                this.updateBorder(n);
            } else if (n == 4) {
                this.btnLeft.setIcon(this.iconNormal);
                this.updateBorder(n);
            }
        }
    }

    protected abstract void processEvent(int var1);

    public void addSeparator() {
        this.actionsList.add(new ActionWithSepName(null, "-"));
    }

    protected JMenuItem createPopupItem(ActionWithSepName actionWithSepName) {
        JMenuItem jMenuItem = OS.createMenuItemForAction(actionWithSepName.getAction());
        if (actionWithSepName.getAction() == this.defaultAction.getAction()) {
            boolean bl = jMenuItem.getComponentOrientation().isLeftToRight();
            jMenuItem.setText(bl ? actionWithSepName.getDisplayName() + " *" : "* " + actionWithSepName.getDisplayName());
        } else {
            jMenuItem.setText(actionWithSepName.getDisplayName());
        }
        if (!OS.isMacOS()) {
            jMenuItem.setBorderPainted(false);
        }
        return jMenuItem;
    }

    protected void restoreState() {
        this.changeState(this.isUnderMouse ? 1 : 4);
    }

    private void updateBorder(int n) {
        switch (n) {
            case 1: {
                this.btnLeft.setBorder(GWBorder.RAISED_BORDER);
                this.btnRight.setBorder(GWBorder.RAISED_BORDER);
                break;
            }
            case 8: {
                this.btnLeft.setBorder(GWBorder.LOWERED_BORDER);
                this.btnRight.setBorder(GWBorder.LOWERED_BORDER);
                break;
            }
            case 4: {
                this.btnLeft.setBorder(GWBorder.NO_BORDER);
                this.btnRight.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    public String getDisplayText() {
        return this.btnLeft.getText();
    }

    public int getIconPosition() {
        return this.iconPosition;
    }

    public boolean isTextVisible() {
        return this.isTextVisible;
    }

    public void setDisplayText(String string) {
        this.btnLeft.setText(string);
    }

    public void setIconPosition(int n) {
        switch (n) {
            case 2: {
                this.btnLeft.setVerticalTextPosition(0);
                this.btnLeft.setHorizontalTextPosition(4);
                this.iconPosition = n;
                break;
            }
            case 4: {
                this.btnLeft.setVerticalTextPosition(0);
                this.btnLeft.setHorizontalTextPosition(2);
                this.iconPosition = n;
                break;
            }
            case 1: {
                this.btnLeft.setVerticalTextPosition(3);
                this.btnLeft.setHorizontalTextPosition(0);
                this.iconPosition = n;
                break;
            }
            case 3: {
                this.btnLeft.setVerticalTextPosition(1);
                this.btnLeft.setHorizontalTextPosition(0);
                this.iconPosition = n;
            }
        }
    }

    public void setTextVisible(boolean bl) {
        if (!bl && this.getIcon() == null) {
            return;
        }
        if (bl) {
            this.btnLeft.setText(this.defaultAction.getDisplayName());
        } else {
            this.btnLeft.setText("");
        }
        this.isTextVisible = bl;
    }

    public Icon getIcon() {
        if (this.iconNormal != null) {
            return this.iconNormal;
        }
        return null;
    }

    public List getActionsList() {
        return this.actionsList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RightButtonMouseListener
    extends MouseAdapter {
        private RightButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractPopupPane.this.mouseEntered();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AbstractPopupPane.this.mouseExited();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                AbstractPopupPane.this.processEvent(20);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                AbstractPopupPane.this.changeState(1);
            }
        }
    }

    private class LeftButtonMouseListener
    extends MouseAdapter {
        private LeftButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractPopupPane.this.mouseEntered();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AbstractPopupPane.this.mouseExited();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                AbstractPopupPane.this.processEvent(16);
                AbstractPopupPane.this.btnRight.getModel().setPressed(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && AbstractPopupPane.this.btnLeft.isEnabled()) {
                JButton jButton = AbstractPopupPane.this.btnLeft;
                if (0 <= mouseEvent.getX() && mouseEvent.getX() < jButton.getSize().width && 0 <= mouseEvent.getY() && mouseEvent.getY() < jButton.getSize().height) {
                    AbstractPopupPane.this.changeState(1);
                } else {
                    AbstractPopupPane.this.changeState(4);
                }
            }
        }
    }

    private static class RightButton
    extends ToolBarButton {
        private RightButton() {
        }

        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.right = 3;
            insets.left = 3;
            return insets;
        }
    }

    protected class DefaultActionPropertyListener
    implements PropertyChangeListener {
        protected DefaultActionPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                AbstractPopupPane.this.btnRight.setEnabled(AbstractPopupPane.this.defaultAction.getAction().isEnabled());
                AbstractPopupPane.this.pumActions = null;
                AbstractPopupPane.this.isPopupShowed = false;
                AbstractPopupPane.this.restoreState();
                AbstractPopupPane.this.isEnabled = AbstractPopupPane.this.defaultAction.getAction().isEnabled();
            }
        }
    }
}

