/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;
import org.apache.log4j.Logger;

public class HTMLStyledWriter
extends HTMLWriter {
    Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$HTMLStyledWriter == null ? (class$com$appframework$components$htmleditor$HTMLStyledWriter = HTMLStyledWriter.class$("com.appframework.components.htmleditor.HTMLStyledWriter")) : class$com$appframework$components$htmleditor$HTMLStyledWriter));
    private boolean doReplaceEntities = false;
    private boolean inBody = false;
    private boolean inEmptyParagraph = false;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$HTMLStyledWriter;

    public HTMLStyledWriter(Writer writer, HTMLDocument hTMLDocument) {
        this(writer, hTMLDocument, 0, hTMLDocument.getLength());
    }

    public HTMLStyledWriter(Writer writer, HTMLDocument hTMLDocument, int n, int n2) {
        super(writer, hTMLDocument, n, n2);
        this.setLineLength(Integer.MAX_VALUE);
    }

    private boolean isParagraph(Element element) {
        return element != null && this.inBody && element.getName().equals(HTML.Tag.P.toString());
    }

    private boolean isEmptyParagraph(Element element) throws BadLocationException {
        boolean bl = false;
        if (this.isParagraph(element)) {
            String string = this.getText(element);
            return string.equals("") || string.equals(Utils.LINE_SEPARATOR);
        }
        return bl;
    }

    protected void startTag(Element element) throws IOException, BadLocationException {
        this.logger.debug((Object)("--- print start tag: [" + element.getName() + "]"));
        if (this.isEmptyParagraph(element)) {
            this.inEmptyParagraph = true;
            this.write("<" + HTML.Tag.BR + ">");
        } else {
            if (element.getName().equals(HTML.Tag.BODY.toString())) {
                this.inBody = true;
            }
            super.startTag(element);
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        if (!this.inEmptyParagraph) {
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object != null && object.equals(HTML.Tag.P)) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
                simpleAttributeSet.addAttribute(CSS.Attribute.MARGIN_TOP, "0");
                simpleAttributeSet.addAttribute(CSS.Attribute.MARGIN_BOTTOM, "0");
                attributeSet = simpleAttributeSet;
            }
            this.doWriteAttributes(attributeSet);
        }
    }

    private void doWriteAttributes(AttributeSet attributeSet) throws IOException {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        this.convertAttributes(attributeSet, simpleAttributeSet);
        Enumeration<?> enumeration = simpleAttributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof HTML.Tag || obj instanceof StyleConstants || obj == HTML.Attribute.ENDTAG) continue;
            this.write(" " + obj + "=\"" + simpleAttributeSet.getAttribute(obj) + "\"");
        }
    }

    private void convertAttributes(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof CSS.Attribute) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("; ");
                }
                stringBuffer.append(obj);
                stringBuffer.append(": ");
                stringBuffer.append(attributeSet.getAttribute(obj));
                continue;
            }
            mutableAttributeSet.addAttribute(obj, attributeSet.getAttribute(obj));
        }
        if (stringBuffer.length() > 0) {
            mutableAttributeSet.addAttribute(HTML.Attribute.STYLE, stringBuffer.toString());
        }
    }

    protected void endTag(Element element) throws IOException {
        this.logger.debug((Object)("--- print end tag: [" + element.getName() + "]"));
        try {
            if (this.isEmptyParagraph(element)) {
                this.inEmptyParagraph = false;
            } else {
                super.endTag(element);
            }
        }
        catch (BadLocationException badLocationException) {
            this.logger.error((Object)badLocationException);
            this.logger.debug((Object)badLocationException, (Throwable)badLocationException);
        }
    }

    protected void writeEmbeddedTags(AttributeSet attributeSet) throws IOException {
        if (!this.inEmptyParagraph) {
            super.writeEmbeddedTags(attributeSet);
        }
    }

    public void write() throws IOException, BadLocationException {
        this.doReplaceEntities = false;
        super.write();
    }

    protected void output(char[] cArray, int n, int n2) throws IOException {
        if (!this.doReplaceEntities) {
            if (n2 > 0) {
                this.doOutput(cArray, n, n2);
            }
            return;
        }
        boolean bl = false;
        n2 += n;
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            switch (c) {
                case ' ': {
                    if (bl) {
                        stringBuffer.append("&nbsp;");
                        continue block8;
                    }
                    if (i == n) {
                        stringBuffer.append("&nbsp;");
                    } else {
                        stringBuffer.append(" ");
                    }
                    bl = true;
                    continue block8;
                }
                case '<': {
                    bl = false;
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    bl = false;
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    bl = false;
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    bl = false;
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    bl = false;
                    continue block8;
                }
                default: {
                    BitSet bitSet = ControlsUtils.getDontNeedEncoding();
                    if (!bitSet.get(c)) {
                        stringBuffer.append("&#");
                        stringBuffer.append(String.valueOf((int)c));
                        stringBuffer.append(";");
                    } else {
                        stringBuffer.append(c);
                    }
                    bl = false;
                }
            }
        }
        String string = HTMLUtils.fixSpacesBTWUTFCharCodes(stringBuffer.toString());
        this.output(string);
    }

    private void output(String string) throws IOException {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        this.doOutput(cArray, 0, n);
    }

    private void doOutput(char[] cArray, int n, int n2) throws IOException {
        this.getWriter().write(cArray, n, n2);
        this.setCurrentLineLength(this.getCurrentLineLength() + n2);
    }

    protected void indent() throws IOException {
        boolean bl = this.doReplaceEntities;
        this.doReplaceEntities = false;
        super.indent();
        this.doReplaceEntities = bl;
    }

    protected void text(Element element) throws BadLocationException, IOException {
        this.logger.debug((Object)("--- print text: [" + this.getText(element) + "]"));
        if (!this.inEmptyParagraph) {
            this.doReplaceEntities = true;
            super.text(element);
            this.doReplaceEntities = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

