/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.components.customizedbutton.ToolBarSeparator;
import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.components.htmleditor.DirtyStateManager;
import com.appframework.components.htmleditor.HTMLConstants;
import com.appframework.components.htmleditor.HTMLTextComponent;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.InsertLinkDialog;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.textcomponent.EditableDocumentListener;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;

public class HTMLTextEditor
extends HTMLTextComponent {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$HTMLTextEditor == null ? (class$com$appframework$components$htmleditor$HTMLTextEditor = HTMLTextEditor.class$("com.appframework.components.htmleditor.HTMLTextEditor")) : class$com$appframework$components$htmleditor$HTMLTextEditor));
    protected JComponent pnlHeader;
    private ToolBarToggleButton tbtnBold;
    private ToolBarToggleButton tbtnItalic;
    private ToolBarToggleButton tbtnUnderlaine;
    private AbstractButton btnForeground;
    private JComboBox cmbFontNames;
    private JComboBox cmbFontSizes;
    private AbstractButton btnShowAlign;
    private AbstractButton btnInsertPopUp;
    protected AbstractButton btnUndo;
    protected AbstractButton btnRedo;
    private ActionUndo actionUndo;
    private ActionRedo actionRedo;
    private UndoManager undoManager;
    private BoldAction boldAction;
    private ItalicAction italicAction;
    private UnderlineAction underlineAction;
    private boolean fontActionDisabled = false;
    private int oldPos = -1;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$HTMLTextEditor;

    public HTMLTextEditor(int n, DirtyStateManager dirtyStateManager) {
        super(dirtyStateManager);
        this.setEditable(true);
        this.setMode(n);
        this.setEnableShortCuts(true);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    protected void buildUI() {
        super.buildUI();
        this.undoManager = new UndoManager();
        this.actionUndo = new ActionUndo();
        this.actionRedo = new ActionRedo();
        this.htmlTextPane.setEditableDocumentListener(new EditableDocumentListener(this.htmlTextPane, this.dirtyStateManager));
        this.htmlTextPane.setUndoableListener(new UndoChangeListener());
        this.htmlTextPane.addCaretListener(new CaretChangeListener());
        KeyStroke keyStroke = KeyStroke.getKeyStroke(90, OS.getMetaKey());
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(90, OS.getMetaKey() | 0x40);
        this.htmlTextPane.registerKeyboardAction(this.actionUndo, keyStroke, 0);
        this.htmlTextPane.registerKeyboardAction(this.actionRedo, keyStroke2, 0);
        this.buildHeaderPanel();
        this.add((Component)this.pnlHeader, "North");
    }

    private void buildHeaderPanel() {
        this.pnlHeader = new GWToolBar();
        this.pnlHeader.setLayout(new FlowLayout(3));
        this.pnlHeader.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        this.btnUndo = this.createButton(this.actionUndo, ImageResources.ACT_UNDO, null);
        this.pnlHeader.add(this.btnUndo);
        this.btnRedo = this.createButton(this.actionRedo, ImageResources.ACT_REDO, null);
        this.pnlHeader.add(this.btnRedo);
        this.pnlHeader.add(new ToolBarSeparator());
        List<String> list = Arrays.asList(UIUtils.getSystemFonts());
        this.cmbFontNames = new OrientableComboBox((Vector)new Vector<String>(list));
        this.cmbFontNames.setSelectedItem(list.get(0));
        this.cmbFontNames.setAction(new ActionFontName());
        this.cmbFontNames.addPopupMenuListener(new HTMLPopupMenuListener());
        this.cmbFontNames.addKeyListener(new FontNameKL());
        this.pnlHeader.add(this.cmbFontNames);
        this.cmbFontSizes = new OrientableComboBox(FontOptions.SIZES_HTML);
        this.cmbFontSizes.setAction(new ActionFontSize());
        this.cmbFontSizes.setSelectedItem(new Integer(HTMLConstants.getDefaultFontSize(this.getMode())));
        this.cmbFontSizes.addPopupMenuListener(new HTMLPopupMenuListener());
        this.cmbFontSizes.addKeyListener(new FontNameKL());
        this.pnlHeader.add(this.cmbFontSizes);
        this.boldAction = new BoldAction();
        this.tbtnBold = new ToolBarToggleButton(this.boldAction);
        this.tbtnBold.setToolTipText(StringResources.BOLD);
        this.tbtnBold.setText("<html><body><b>" + StringResources.BOLD_BUTTON + "</b></body></html>");
        this.pnlHeader.add(this.tbtnBold);
        this.italicAction = new ItalicAction();
        this.tbtnItalic = new ToolBarToggleButton(this.italicAction);
        this.tbtnItalic.setText("<html><body><i>" + StringResources.ITALIC_BUTTON + "</i></body></html>");
        this.tbtnItalic.setToolTipText(StringResources.ITALIC);
        this.pnlHeader.add(this.tbtnItalic);
        this.underlineAction = new UnderlineAction();
        this.tbtnUnderlaine = new ToolBarToggleButton(this.underlineAction);
        this.tbtnUnderlaine.setText("<html><body><u>" + StringResources.UNDERLINE_BUTTON + "</u></body></html>");
        this.pnlHeader.add(this.tbtnUnderlaine);
        this.tbtnUnderlaine.setToolTipText(StringResources.UNDERLINE);
        this.pnlHeader.add(new ToolBarSeparator());
        this.btnForeground = this.createButton(new ActionForeground(), ImageResources.ACT_FONT_COLOR, StringResources.FONT_COLOR);
        this.pnlHeader.add(this.btnForeground);
        this.pnlHeader.add(new ToolBarSeparator());
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.btnShowAlign = this.createButton(abstractAction, ImageResources.ACT_ALIGN_LEFT, StringResources.TEXT_ALIGNMENT);
        this.btnShowAlign.addMouseListener(new AlignmentPopupMouseListener());
        this.pnlHeader.add(this.btnShowAlign);
        this.pnlHeader.add(new ToolBarSeparator());
        this.btnInsertPopUp = this.createButton(abstractAction, ImageResources.ACT_INSERT_POPUP, StringResources.INSERT_A_HORIZONTAL_LINE_OR_LINK);
        new ToolBarButton(ImageResources.ACT_INSERT_POPUP);
        this.btnInsertPopUp.addMouseListener(new ActionInsertPopup());
        this.pnlHeader.add(this.btnInsertPopUp);
        this.pnlHeader.setFocusable(false);
    }

    private AbstractButton createButton(Action action, Icon icon, String string) {
        ToolBarButton toolBarButton = new ToolBarButton(action);
        if (icon != null) {
            toolBarButton.setIcon(icon);
        }
        if (string != null) {
            ((JComponent)toolBarButton).setToolTipText(string);
        }
        toolBarButton.setFocusable(false);
        return toolBarButton;
    }

    public void setHTMLButtonsEnabled(boolean bl) {
        if (this.btnInsertPopUp != null) {
            this.btnInsertPopUp.setEnabled(bl);
        }
        if (this.btnShowAlign != null) {
            this.btnShowAlign.setEnabled(bl);
        }
    }

    private void updateUndo() {
        if (this.undoManager.canUndo()) {
            this.actionUndo.setEnabled(true);
        } else {
            this.actionUndo.setEnabled(false);
        }
        if (this.undoManager.canRedo()) {
            this.actionRedo.setEnabled(true);
        } else {
            this.actionRedo.setEnabled(false);
        }
    }

    public void showHeaderPanel(boolean bl) {
        if (bl) {
            this.add((Component)this.pnlHeader, "North");
        } else {
            this.remove(this.pnlHeader);
        }
    }

    public void setHeaderBackground(Color color) {
        this.pnlHeader.setBackground(color);
        Component[] componentArray = this.pnlHeader.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            componentArray[i].setBackground(color);
        }
    }

    public void setHeaderForeground(Color color) {
        this.pnlHeader.setForeground(color);
        Component[] componentArray = this.pnlHeader.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            componentArray[i].setForeground(color);
        }
    }

    public void setHeaderBorder(Border border) {
        this.pnlHeader.setBorder(border);
        Component[] componentArray = this.pnlHeader.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)componentArray[i];
            jComponent.setBorder(border);
        }
        this.pnlHeader.updateUI();
    }

    public void setEnableShortCuts(boolean bl) {
        if (bl) {
            BoldAction boldAction = new BoldAction();
            this.htmlTextPane.getInputMap().put(KeyStroke.getKeyStroke(66, OS.getMetaKey(), false), "BoldAction");
            this.htmlTextPane.getActionMap().put("BoldAction", boldAction);
            StyledEditorKit.ItalicAction italicAction = new StyledEditorKit.ItalicAction();
            this.htmlTextPane.getInputMap().put(KeyStroke.getKeyStroke(73, OS.getMetaKey(), false), "ItalicAction");
            this.htmlTextPane.getActionMap().put("ItalicAction", italicAction);
            StyledEditorKit.UnderlineAction underlineAction = new StyledEditorKit.UnderlineAction();
            this.htmlTextPane.getInputMap().put(KeyStroke.getKeyStroke(85, OS.getMetaKey(), false), "UnderlineAction");
            this.htmlTextPane.getActionMap().put("UnderlineAction", underlineAction);
        } else {
            this.htmlTextPane.getActionMap().put("BoldAction", null);
            this.htmlTextPane.getActionMap().put("ItalicAction", null);
            this.htmlTextPane.getActionMap().put("UnderlineAction", null);
        }
    }

    public void setEnabled(boolean bl) {
        int n = this.pnlHeader.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.pnlHeader.getComponent(i).setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    private void updateButtons(int n) {
        boolean bl;
        boolean bl2;
        if (n == this.oldPos) {
            return;
        }
        this.oldPos = n;
        if (!this.htmlTextPane.isEditable() || !this.htmlTextPane.isEnabled()) {
            return;
        }
        this.fontActionDisabled = true;
        StyledDocument styledDocument = (StyledDocument)this.htmlTextPane.getDocument();
        MutableAttributeSet mutableAttributeSet = n > 0 ? styledDocument.getCharacterElement(n - 1).getAttributes() : this.htmlTextPane.getInputAttributes();
        String string = StyleConstants.getFontFamily(mutableAttributeSet);
        int n2 = StyleConstants.getFontSize(mutableAttributeSet);
        string = new Font(string, 0, n2).getFamily();
        this.selectFont(string, n2);
        boolean bl3 = StyleConstants.isBold(mutableAttributeSet);
        AttributeSet attributeSet = mutableAttributeSet.getResolveParent();
        if (attributeSet != null) {
            bl3 |= attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.STRONG;
        }
        if (bl3 != this.tbtnBold.isSelected()) {
            this.tbtnBold.setSelected(bl3);
        }
        if ((bl2 = StyleConstants.isItalic(mutableAttributeSet)) != this.tbtnItalic.isSelected()) {
            this.tbtnItalic.setSelected(bl2);
        }
        if ((bl = StyleConstants.isUnderline(mutableAttributeSet)) != this.tbtnUnderlaine.isSelected()) {
            this.tbtnUnderlaine.setSelected(bl);
        }
        int n3 = StyleConstants.ParagraphConstants.getAlignment(mutableAttributeSet);
        switch (n3) {
            case 0: {
                this.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_LEFT);
                break;
            }
            case 1: {
                this.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_CENTER);
                break;
            }
            case 2: {
                this.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_RIGHT);
            }
        }
        this.fontActionDisabled = false;
    }

    private void selectFont(String string, int n) {
        Object object = this.cmbFontNames.getSelectedItem();
        if (!object.equals(string)) {
            this.cmbFontNames.setSelectedItem(string);
        }
        Integer n2 = new Integer(n);
        object = this.cmbFontSizes.getSelectedItem();
        if (!object.equals(n2)) {
            this.cmbFontSizes.setSelectedItem(n2);
        }
    }

    public void setDefaultFont() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        int n = this.htmlTextPane.getDefaultFontSize();
        StyleConstants.setFontSize(simpleAttributeSet, n);
        String string = this.htmlTextPane.getDefaultFontName();
        StyleConstants.setFontFamily(simpleAttributeSet, string);
        this.htmlTextPane.setCharacterAttributes(simpleAttributeSet, true);
        this.selectFont(string, n);
    }

    private JFrame getApplicationFrame(Component component) {
        Container container = component.getParent();
        if (container instanceof JFrame) {
            return (JFrame)container;
        }
        return this.getApplicationFrame(container);
    }

    public void setMode(int n) {
        int n2 = this.getMode();
        String string = this.getPlainText();
        int n3 = this.htmlTextPane.getCaretPosition();
        Document document = this.getDocument();
        super.setMode(n);
        this.dirtyStateManager.setDirty(this.dirtyStateManager.isDirty(), false);
        this.undoManager.discardAllEdits();
        this.updateUndo();
        this.setHTMLButtonsEnabled(n == 1);
        int n4 = this.getMode();
        if (n4 != n2 && (n4 == 1 || n4 == 2 || n4 == 3)) {
            Object object;
            if (!string.trim().equals("")) {
                object = this.getDocument();
                HTMLUtils.convertDocument(n2, document, n4, (Document)object, (StyledEditorKit)this.htmlTextPane.getEditorKit());
                this.htmlTextPane.setCaretPosition(n3);
            }
            object = new DefaultComboBoxModel<Integer>(n4 == 1 ? FontOptions.SIZES_HTML : FontOptions.SIZES_PLAINTEXT);
            this.cmbFontSizes.setModel(object);
            this.oldPos = -1;
            this.updateButtons(this.htmlTextPane.getCaretPosition());
        }
    }

    public void setStyledText(String string) {
        this.oldPos = -1;
        this.htmlTextPane.setStyledText(string);
    }

    public JComponent getComponent() {
        return this.htmlTextPane;
    }

    public HTMLTextPane getHTMLTextPane() {
        return this.htmlTextPane;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HTMLPopupMenuListener
    implements PopupMenuListener {
        private HTMLPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            HTMLTextEditor.this.htmlTextPane.requestFocus();
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    class UndoChangeListener
    implements UndoableEditListener {
        UndoChangeListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            hTMLTextEditor.undoManager.addEdit(undoableEditEvent.getEdit());
            hTMLTextEditor.updateUndo();
        }
    }

    class ActionInsertPopup
    extends MouseAdapter {
        ActionInsertPopup() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(OS.createMenuItemForAction(new ActionInsertLine(StringResources.INSERT_HORIZONTAL_LINE, ImageResources.ACT_INSERT_LINE)));
            jPopupMenu.add(OS.createMenuItemForAction(new ActionInsertLink(StringResources.INSERT_HYPERLINK_TO_WEB_PAGE, ImageResources.ACT_LINK_HTML, false)));
            jPopupMenu.add(OS.createMenuItemForAction(new ActionInsertLink(StringResources.INSERT_HYPERLINK_TO_EKMAIL, ImageResources.ACT_LINK_MAILTO, true)));
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class AlignmentPopupMouseListener
    extends MouseAdapter {
        AlignmentPopupMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new ActionAlignParagraph(StringResources.ALIGN_LEFT, ImageResources.ACT_ALIGN_LEFT, 0));
            jPopupMenu.add(new ActionAlignParagraph(StringResources.ALIGN_CENTER, ImageResources.ACT_ALIGN_CENTER, 1));
            jPopupMenu.add(new ActionAlignParagraph(StringResources.ALIGN_RIGHT, ImageResources.ACT_ALIGN_RIGHT, 2));
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class ActionAlignParagraph
    extends AbstractAction {
        StyledEditorKit.AlignmentAction alignAction;
        int type;

        public ActionAlignParagraph(String string, Icon icon, int n) {
            super(string, icon);
            this.alignAction = new StyledEditorKit.AlignmentAction(string, n);
            this.type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            hTMLTextEditor.htmlTextPane.grabFocus();
            actionEvent.setSource(hTMLTextEditor.htmlTextPane);
            this.alignAction.actionPerformed(actionEvent);
            switch (this.type) {
                case 0: {
                    hTMLTextEditor.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_LEFT);
                    break;
                }
                case 1: {
                    hTMLTextEditor.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_CENTER);
                    break;
                }
                case 2: {
                    hTMLTextEditor.btnShowAlign.setIcon(ImageResources.ACT_ALIGN_RIGHT);
                }
            }
        }
    }

    class ActionInsertLink
    extends AbstractAction {
        boolean isMailto = false;

        public ActionInsertLink(String string, Icon icon, boolean bl) {
            super(string, icon);
            this.isMailto = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            hTMLTextEditor.htmlTextPane.grabFocus();
            actionEvent.setSource(hTMLTextEditor.htmlTextPane);
            InsertLinkDialog insertLinkDialog = null;
            insertLinkDialog = this.isMailto ? new InsertLinkDialog(hTMLTextEditor.getApplicationFrame(hTMLTextEditor), true, InsertLinkDialog.MAILTO) : new InsertLinkDialog(hTMLTextEditor.getApplicationFrame(hTMLTextEditor), true);
            String string = hTMLTextEditor.htmlTextPane.getSelectedText();
            boolean bl = string == null;
            int n = hTMLTextEditor.htmlTextPane.getCaretPosition();
            int n2 = -1;
            if (!bl) {
                insertLinkDialog.setLinkText(string);
                n2 = n + string.length();
            }
            UIUtils.centerWindowOnScreen(insertLinkDialog);
            insertLinkDialog.setVisible(true);
            if (!insertLinkDialog.isActionCompleteSuccessfully()) {
                return;
            }
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute("href", insertLinkDialog.getLink());
            SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
            simpleAttributeSet2.addAttribute(HTML.Tag.A, simpleAttributeSet);
            simpleAttributeSet2.addAttribute(StyleConstants.Foreground, Color.BLUE);
            simpleAttributeSet2.addAttribute(StyleConstants.Italic, new Boolean(true));
            simpleAttributeSet2.addAttribute(StyleConstants.Underline, new Boolean(true));
            if (bl) {
                AttributeSet attributeSet = ((HTMLDocument)hTMLTextEditor.htmlTextPane.getDocument()).getCharacterElement(n).getAttributes();
                string = insertLinkDialog.getLinkText();
                try {
                    hTMLTextEditor.htmlTextPane.getDocument().insertString(n, string + " ", attributeSet);
                    n2 = n + string.length();
                    hTMLTextEditor.htmlTextPane.setSelectionStart(n);
                    hTMLTextEditor.htmlTextPane.setSelectionEnd(n2);
                }
                catch (BadLocationException badLocationException) {
                    logger.debug((Object)badLocationException);
                }
            }
            hTMLTextEditor.htmlTextPane.setCharacterAttributes(simpleAttributeSet2, false);
            if (bl) {
                hTMLTextEditor.htmlTextPane.setSelectionEnd(n2 + 1);
            }
        }
    }

    private class FontNameKL
    extends KeyAdapter {
        private FontNameKL() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                Action action = ((JComboBox)keyEvent.getSource()).getAction();
                action.actionPerformed(new ActionEvent(keyEvent.getSource(), keyEvent.getID(), "", 16));
            }
        }
    }

    class ActionInsertLine
    extends AbstractAction {
        private Hashtable actions = new Hashtable();

        public ActionInsertLine(String string, Icon icon) {
            super(string, icon);
            HTMLTextEditor hTMLTextEditor2 = HTMLTextEditor.this;
            Action[] actionArray = hTMLTextEditor2.htmlTextPane.getActions();
            for (int i = 0; i < actionArray.length; ++i) {
                Action action = actionArray[i];
                this.actions.put(action.getValue("Name"), action);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            hTMLTextEditor.htmlTextPane.grabFocus();
            actionEvent.setSource(hTMLTextEditor.htmlTextPane);
            ((Action)this.actions.get("InsertHR")).actionPerformed(actionEvent);
            hTMLTextEditor.htmlTextPane.applyHTMLParagraphAttributes();
        }
    }

    class ActionRedo
    extends AbstractAction {
        ActionRedo() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            if (!hTMLTextEditor.undoManager.canRedo()) {
                return;
            }
            try {
                hTMLTextEditor.undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                logger.debug((Object)cannotRedoException);
            }
            hTMLTextEditor.updateUndo();
        }
    }

    class ActionUndo
    extends AbstractAction {
        ActionUndo() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            if (!hTMLTextEditor.undoManager.canUndo()) {
                return;
            }
            try {
                hTMLTextEditor.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                logger.debug((Object)cannotUndoException);
            }
            hTMLTextEditor.updateUndo();
        }
    }

    class ActionFontSize
    extends StyledEditorKit.FontSizeAction {
        String name = "font size";

        public ActionFontSize() {
            super("", HTMLConstants.getDefaultFontSize(HTMLTextEditor.this.getMode()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((long)actionEvent.getModifiers() == 16L) {
                HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
                if (hTMLTextEditor.fontActionDisabled) {
                    return;
                }
                int n = (Integer)hTMLTextEditor.cmbFontSizes.getSelectedItem();
                String string = (String)hTMLTextEditor.cmbFontNames.getSelectedItem();
                new StyledEditorKit.FontSizeAction(this.name, n).actionPerformed(actionEvent);
                hTMLTextEditor.htmlTextPane.setDefaultFont(string, n);
            }
        }
    }

    class ActionFontName
    extends StyledEditorKit.StyledTextAction {
        String name = "font face";

        public ActionFontName() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((long)actionEvent.getModifiers() == 16L) {
                HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
                if (hTMLTextEditor.fontActionDisabled) {
                    return;
                }
                String string = (String)hTMLTextEditor.cmbFontNames.getSelectedItem();
                int n = (Integer)hTMLTextEditor.cmbFontSizes.getSelectedItem();
                new StyledEditorKit.FontFamilyAction(this.name, string).actionPerformed(actionEvent);
                hTMLTextEditor.htmlTextPane.setDefaultFont(string, n);
            }
        }
    }

    class ActionForeground
    extends StyledEditorKit.StyledTextAction {
        String name = "foreground color";

        public ActionForeground() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            if (hTMLTextEditor.fontActionDisabled) {
                return;
            }
            if (!hTMLTextEditor.htmlTextPane.isFocusOwner()) {
                hTMLTextEditor.htmlTextPane.grabFocus();
                hTMLTextEditor.htmlTextPane.setCaretPosition(hTMLTextEditor.htmlTextPane.getDocument().getLength());
            }
            actionEvent.setSource(hTMLTextEditor.htmlTextPane);
            JColorChooser jColorChooser = new JColorChooser();
            jColorChooser.setVisible(true);
            Color color = JColorChooser.showDialog(hTMLTextEditor, StringResources.FONT_COLOR, Color.black);
            if (color == null) {
                return;
            }
            new StyledEditorKit.ForegroundAction(this.name, color).actionPerformed(actionEvent);
        }
    }

    class UnderlineAction
    extends AbstractAction {
        StyledEditorKit.UnderlineAction ua = new StyledEditorKit.UnderlineAction();

        UnderlineAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            if (hTMLTextEditor.fontActionDisabled) {
                return;
            }
            if (!hTMLTextEditor.htmlTextPane.isFocusOwner()) {
                hTMLTextEditor.htmlTextPane.grabFocus();
                hTMLTextEditor.htmlTextPane.setCaretPosition(hTMLTextEditor.htmlTextPane.getDocument().getLength());
            }
            actionEvent.setSource(hTMLTextEditor.htmlTextPane);
            this.ua.actionPerformed(actionEvent);
        }
    }

    class ItalicAction
    extends AbstractAction {
        StyledEditorKit.ItalicAction ia = new StyledEditorKit.ItalicAction();

        ItalicAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            if (hTMLTextEditor.fontActionDisabled) {
                return;
            }
            if (!hTMLTextEditor.htmlTextPane.isFocusOwner()) {
                hTMLTextEditor.htmlTextPane.grabFocus();
                hTMLTextEditor.htmlTextPane.setCaretPosition(hTMLTextEditor.htmlTextPane.getDocument().getLength());
            }
            actionEvent.setSource(hTMLTextEditor.htmlTextPane);
            this.ia.actionPerformed(actionEvent);
        }
    }

    class BoldAction
    extends AbstractAction {
        StyledEditorKit.BoldAction ba = new StyledEditorKit.BoldAction();

        BoldAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLTextEditor hTMLTextEditor = HTMLTextEditor.this;
            if (hTMLTextEditor.fontActionDisabled) {
                return;
            }
            if (!hTMLTextEditor.htmlTextPane.isFocusOwner()) {
                hTMLTextEditor.htmlTextPane.grabFocus();
                hTMLTextEditor.htmlTextPane.setCaretPosition(hTMLTextEditor.htmlTextPane.getDocument().getLength());
            }
            actionEvent.setSource(hTMLTextEditor.htmlTextPane);
            this.ba.actionPerformed(actionEvent);
        }
    }

    class CaretChangeListener
    implements CaretListener {
        CaretChangeListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            HTMLTextEditor.this.updateButtons(caretEvent.getDot());
        }
    }
}

