/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.CustomFont;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.utils.OS;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.BreakIterator;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.html.InlineView;
import org.apache.log4j.Logger;

public class MyInlineView
extends InlineView {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$MyInlineView == null ? (class$com$appframework$components$htmleditor$MyInlineView = MyInlineView.class$("com.appframework.components.htmleditor.MyInlineView")) : class$com$appframework$components$htmleditor$MyInlineView));
    private JEditorPane editor;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$MyInlineView;

    public MyInlineView(Element element, JEditorPane jEditorPane) {
        super(element);
        this.editor = jEditorPane;
    }

    private boolean isDivider(char c) {
        return c == '%' || c == '?';
    }

    public int getBreakWeight(int n, float f, float f2) {
        try {
            return super.getBreakWeight(n, f, f2);
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)runtimeException, (Throwable)runtimeException);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MyInlineView.this.editor != null && MyInlineView.this.editor instanceof HTMLTextPane) {
                        HTMLTextPane hTMLTextPane = (HTMLTextPane)MyInlineView.this.editor;
                        hTMLTextPane.clear();
                    }
                }
            });
            throw runtimeException;
        }
    }

    public View breakView(int n, int n2, float f, float f2) {
        if (n == 0) {
            this.checkPainter();
            int n3 = this.getClosestBreakSpot(n2, f2);
            int n4 = this.getBreakSpot(n2, n3);
            if (n4 == -1) {
                return this;
            }
            n3 = n4;
            if (n2 == this.getStartOffset() && n3 == this.getEndOffset()) {
                return this;
            }
            GlyphView glyphView = (GlyphView)this.createFragment(n2, n3);
            glyphView.getTabbedSpan(f, glyphView.getTabExpander());
            return glyphView;
        }
        return this;
    }

    private int getClosestBreakSpot(int n, float f) {
        int n2 = n;
        String string = this.getString(n, this.getEndOffset());
        char[] cArray = string.toCharArray();
        int n3 = 0;
        FontMetrics fontMetrics = this.getFontMetrics();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c) || Character.isSpaceChar(c) || this.isDivider(c)) {
                bl = true;
            }
            if (!((float)(n3 += fontMetrics.charWidth(c)) >= f) || !bl) continue;
            n2 = n + i + 1;
            break;
        }
        return n2;
    }

    public int getBreakSpot(int n, int n2) {
        return this.getBreakSpotUseWhitespace(n, n2);
    }

    private int getBreakSpotUseBreakIterator(int n, int n2) {
        int n3;
        int n4;
        int n5;
        Element element = this.getElement().getParentElement();
        Container container = this.getContainer();
        if (element == null) {
            n5 = n;
            n4 = n2;
        } else {
            n5 = element.getStartOffset();
            n4 = element.getEndOffset();
        }
        BreakIterator breakIterator = container != null ? BreakIterator.getWordInstance(container.getLocale()) : BreakIterator.getWordInstance();
        Segment segment = this.getText(n5, n4);
        segment.first();
        breakIterator.setText(segment);
        if (n2 == n4) {
            n3 = breakIterator.last();
        } else if (n2 + 1 == n4) {
            n3 = breakIterator.next(segment.offset + segment.count - 2);
            if (n3 >= segment.count + segment.offset) {
                n3 = breakIterator.preceding(segment.offset + segment.count - 1);
            }
        } else {
            n3 = breakIterator.preceding(n2 - n5 + segment.offset + 1);
        }
        int n6 = -1;
        if (n3 != -1 && (n3 = n3 - segment.offset + n5) > n) {
            if (n == n5 && n3 == n) {
                n6 = -1;
            } else if (n3 <= n2) {
                n6 = n3;
            }
        }
        return n6;
    }

    private int getBreakSpotUseWhitespace(int n, int n2) {
        Segment segment = this.getText(n, n2);
        char c = segment.last();
        while (c != '\uffff') {
            if (Character.isWhitespace(c) || Character.isSpaceChar(c) || this.isDivider(c)) {
                int n3 = segment.getIndex() - segment.getBeginIndex() + n + 1;
                return n3;
            }
            c = segment.previous();
        }
        return -1;
    }

    private String getString(int n, int n2) {
        Segment segment = new Segment();
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return segment.toString();
    }

    public int getFirstBreak(int n) {
        String string = this.getString(n, this.getEndOffset());
        char[] cArray = string.toCharArray();
        int n2 = n;
        FontMetrics fontMetrics = this.getFontMetrics();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c) || Character.isSpaceChar(c)) {
                return n2 + fontMetrics.charWidth(' ');
            }
            n2 += fontMetrics.charWidth(c);
        }
        return n2;
    }

    public Font getFont() {
        Font font = super.getFont();
        if ((OS.isLinuxOS() || OS.isWinOS()) && font != null && !(font instanceof CustomFont)) {
            font = new Font(font.getFontName(), font.getStyle(), font.getSize());
        }
        return font;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

