/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.RTFFontTableEntry;
import com.appframework.components.htmleditor.RTFUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RTFFontTable {
    public static final String RTF_FONTTABLE_GROUP = "fonttbl";
    public static final String RTF_FONTTABLE_GROUP_START = "{\\fonttbl";
    private String result = null;
    private boolean ok = false;
    private List entries = new ArrayList();
    private Map fontIDs = new TreeMap();

    public void addEntry(RTFFontTableEntry rTFFontTableEntry) {
        if (rTFFontTableEntry != null) {
            this.entries.add(rTFFontTableEntry);
            if (this.fontIDs.get(rTFFontTableEntry.getFontname()) == null) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                arrayList.add(new Integer(rTFFontTableEntry.getNum()));
                this.fontIDs.put(rTFFontTableEntry.getFontname(), arrayList);
            } else {
                Integer n;
                List list = (List)this.fontIDs.get(rTFFontTableEntry.getFontname());
                if (!list.contains(n = new Integer(rTFFontTableEntry.getNum()))) {
                    list.add(n);
                    this.fontIDs.put(rTFFontTableEntry.getFontname(), list);
                }
            }
        }
    }

    public RTFFontTable(String string) {
        this.parse(string);
    }

    private void parse(String string) {
        if (string == null || string.length() < 1) {
            this.result = "Null or empty input string [" + string + "]";
            return;
        }
        if (!string.startsWith(RTF_FONTTABLE_GROUP_START)) {
            this.result = "Missing START bracket and/or group name [" + string + "]";
            return;
        }
        if (!string.endsWith("}")) {
            this.result = "Missing closing bracket [" + string + "]";
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(RTF_FONTTABLE_GROUP_START.length(), string.length() - 1));
        if (stringBuffer.indexOf("\\f") == 0 && stringBuffer.lastIndexOf(";") == stringBuffer.length() - 1) {
            while (stringBuffer.length() > 0) {
                String string2 = "f" + this.entries.size();
                int n = stringBuffer.indexOf("\\" + string2);
                int n2 = stringBuffer.indexOf(";") + 1;
                if (n == -1) {
                    this.result = "Invalid entry encountered: Start tag \"" + string2 + "\" not found [[[\n" + stringBuffer + "\n]]]";
                    return;
                }
                if (n2 == -1) {
                    this.result = "Invalid entry encountered: End bracket \"" + string2 + "\" not found [[[\n" + stringBuffer + "\n]]]";
                    return;
                }
                String string3 = "{" + stringBuffer.substring(n, n2) + "}";
                RTFFontTableEntry rTFFontTableEntry = new RTFFontTableEntry(string3);
                if (rTFFontTableEntry.isOk()) {
                    this.addEntry(rTFFontTableEntry);
                    stringBuffer.delete(n, n2);
                    continue;
                }
                this.result = "Invalid entry encountered: \"" + string2 + "\" not found [[[\n" + string3 + "\n]]]";
                return;
            }
        } else {
            while (stringBuffer.length() > 0) {
                String string4 = "f" + this.entries.size();
                int n = RTFUtils.indexOfGroupBegin(stringBuffer.toString(), string4);
                int n3 = RTFUtils.indexOfGroupEnd(stringBuffer.toString(), string4) + 1;
                if (n == -1) {
                    this.result = "Invalid entry encountered: Start tag \"" + string4 + "\" not found [[[\n" + stringBuffer + "\n]]]";
                    return;
                }
                if (n3 == -1) {
                    this.result = "Invalid entry encountered: End bracket \"" + string4 + "\" not found [[[\n" + stringBuffer + "\n]]]";
                    return;
                }
                String string5 = stringBuffer.substring(n, n3);
                RTFFontTableEntry rTFFontTableEntry = new RTFFontTableEntry(string5);
                if (rTFFontTableEntry.isOk()) {
                    this.addEntry(rTFFontTableEntry);
                    stringBuffer.delete(n, n3);
                    continue;
                }
                this.result = "Invalid entry encountered: \"" + string4 + "\" not found [[[\n" + string5 + "\n]]]";
                return;
            }
        }
        this.result = "Found " + this.entries.size() + " font entries";
        this.ok = true;
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean bl) {
        this.ok = bl;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String string) {
        this.result = string;
    }

    public List getEntries() {
        return this.entries;
    }

    public Set getFontNames() {
        return this.fontIDs.keySet();
    }

    public List getFontIDsByFontName(String string) {
        List list = null;
        if (string != null) {
            list = (List)this.fontIDs.get(string);
        }
        return list;
    }

    public int getFirstEntryIDByFontName(String string) {
        List list = this.getFontIDsByFontName(string);
        int n = -1;
        if (list != null && list.size() > 0) {
            n = (Integer)list.get(0);
        }
        return n;
    }
}

