/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.apache.log4j.Logger;

public class ScaledView
extends BoxView {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$ScaledView == null ? (class$com$appframework$components$htmleditor$ScaledView = ScaledView.class$("com.appframework.components.htmleditor.ScaledView")) : class$com$appframework$components$htmleditor$ScaledView));
    static /* synthetic */ Class class$com$appframework$components$htmleditor$ScaledView;

    public ScaledView(Element element, int n) {
        super(element, n);
    }

    public double getZoomFactor() {
        Double d = (Double)this.getDocument().getProperty("ZOOM_FACTOR");
        if (d != null) {
            return d;
        }
        return 1.0;
    }

    private boolean isZoomEnabled() {
        return Double.doubleToLongBits(1.0) != Double.doubleToLongBits(this.getZoomFactor());
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.isZoomEnabled()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            double d = this.getZoomFactor();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(d, d);
            super.paint(graphics2D, shape);
            graphics2D.setTransform(affineTransform);
        } else {
            super.paint(graphics, shape);
        }
    }

    public float getMinimumSpan(int n) {
        if (this.isZoomEnabled()) {
            float f = super.getMinimumSpan(n);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }
        return super.getMinimumSpan(n);
    }

    public float getMaximumSpan(int n) {
        if (this.isZoomEnabled()) {
            float f = super.getMaximumSpan(n);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }
        return super.getMaximumSpan(n);
    }

    public float getPreferredSpan(int n) {
        if (this.isZoomEnabled()) {
            float f = super.getPreferredSpan(n);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }
        return super.getPreferredSpan(n);
    }

    protected void layout(int n, int n2) {
        if (this.isZoomEnabled()) {
            super.layout(new Double((double)n / this.getZoomFactor()).intValue(), new Double((double)n2 * this.getZoomFactor()).intValue());
        } else {
            super.layout(n, n2);
        }
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (this.isZoomEnabled()) {
            double d = this.getZoomFactor();
            Rectangle rectangle = shape.getBounds();
            Shape shape2 = super.modelToView(n, rectangle, bias);
            rectangle = shape2.getBounds();
            rectangle.x = (int)((double)rectangle.x * d);
            rectangle.y = (int)((double)rectangle.y * d);
            rectangle.width = (int)((double)rectangle.width * d);
            rectangle.height = (int)((double)rectangle.height * d);
            return rectangle;
        }
        return super.modelToView(n, shape, bias);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (this.isZoomEnabled()) {
            double d = this.getZoomFactor();
            Rectangle rectangle = shape.getBounds();
            f = (float)((double)f / d);
            f2 = (float)((double)f2 / d);
            rectangle.x = (int)((double)rectangle.x / d);
            rectangle.y = (int)((double)rectangle.y / d);
            rectangle.width = (int)((double)rectangle.width / d);
            rectangle.height = (int)((double)rectangle.height / d);
            return super.viewToModel(f, f2, rectangle, biasArray);
        }
        return super.viewToModel(f, f2, shape, biasArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

