/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.WrappedMozillaBrowser;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollBar;
import com.webrenderer.IMozillaBrowserCanvas;
import com.webrenderer.ScrollBarInfo;
import com.webrenderer.dom.IDocument;
import com.webrenderer.event.NetworkAdapter;
import com.webrenderer.event.NetworkEvent;
import com.webrenderer.event.NetworkListener;
import com.webrenderer.event.ScrollEvent;
import com.webrenderer.event.ScrollPositionListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class ScrolledMozillaBrowser
extends WrappedMozillaBrowser {
    Logger logger = Logger.getLogger((Class)(class$com$appframework$components$htmleditor$ScrolledMozillaBrowser == null ? (class$com$appframework$components$htmleditor$ScrolledMozillaBrowser = ScrolledMozillaBrowser.class$("com.appframework.components.htmleditor.ScrolledMozillaBrowser")) : class$com$appframework$components$htmleditor$ScrolledMozillaBrowser));
    private JScrollBar vScroll;
    private JScrollBar hScroll;
    private MyScrollPositionListener positionListener;
    static /* synthetic */ Class class$com$appframework$components$htmleditor$ScrolledMozillaBrowser;

    public ScrolledMozillaBrowser(IMozillaBrowserCanvas iMozillaBrowserCanvas) {
        super(iMozillaBrowserCanvas);
    }

    protected void buildUI() {
        this.vScroll = new OrientableScrollBar(1);
        this.vScroll.setFocusable(false);
        this.vScroll.addAdjustmentListener(new VerticalScrollerListener());
        this.hScroll = new OrientableScrollBar(0);
        this.hScroll.setFocusable(false);
        this.hScroll.addAdjustmentListener(new HorizontalScrollerListener());
        this.positionListener = new MyScrollPositionListener();
        this.vScroll.setUnitIncrement(30);
        this.browser.addNetworkListener((NetworkListener)new BrowserDocumentLoadListener());
        this.browser.getCanvas().addComponentListener(new BrowserResizedListener());
        this.browser.showScrollBars(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.browser, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.vScroll, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.hScroll, gridBagConstraints);
    }

    private void refreshScrollers(ScrollBarInfo scrollBarInfo) {
        this.vScroll.setValues(scrollBarInfo.getYPos(), scrollBarInfo.getCurrentHeight(), 0, scrollBarInfo.getTotalHeight());
        int n = scrollBarInfo.getXPos();
        n = !UIUtils.getComponentOrientation().isLeftToRight() ? scrollBarInfo.getTotalWidth() - scrollBarInfo.getCurrentWidth() - n : n;
        this.hScroll.setValues(n, scrollBarInfo.getCurrentWidth(), 0, scrollBarInfo.getTotalWidth());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MyScrollPositionListener
    implements ScrollPositionListener {
        private MyScrollPositionListener() {
        }

        public void onScrollPositionChange(ScrollEvent scrollEvent) {
            ScrollBarInfo scrollBarInfo = ScrolledMozillaBrowser.this.browser.getScrollBarInfo();
            ScrolledMozillaBrowser.this.refreshScrollers(scrollBarInfo);
        }
    }

    private class BrowserDocumentLoadListener
    extends NetworkAdapter {
        private BrowserDocumentLoadListener() {
        }

        public void onDocumentComplete(NetworkEvent networkEvent) {
            ScrollBarInfo scrollBarInfo = ScrolledMozillaBrowser.this.browser.getScrollBarInfo();
            ScrolledMozillaBrowser.this.refreshScrollers(scrollBarInfo);
            if (scrollBarInfo.getTotalHeight() == scrollBarInfo.getCurrentHeight()) {
                ScrolledMozillaBrowser.this.vScroll.setVisible(false);
            } else {
                ScrolledMozillaBrowser.this.vScroll.setVisible(true);
            }
            if (scrollBarInfo.getTotalWidth() == scrollBarInfo.getCurrentWidth()) {
                ScrolledMozillaBrowser.this.hScroll.setVisible(false);
            } else {
                ScrolledMozillaBrowser.this.hScroll.setVisible(true);
            }
            ScrolledMozillaBrowser.this.vScroll.getParent().validate();
            ScrolledMozillaBrowser.this.hScroll.getParent().validate();
            ScrolledMozillaBrowser.this.validate();
            ScrolledMozillaBrowser.this.repaint();
            ScrolledMozillaBrowser.this.setBounds(ScrolledMozillaBrowser.this.getBounds());
            IDocument iDocument = ScrolledMozillaBrowser.this.browser.getDocument();
            iDocument.addScrollPositionListener((ScrollPositionListener)ScrolledMozillaBrowser.this.positionListener);
        }
    }

    private class VerticalScrollerListener
    implements AdjustmentListener {
        private VerticalScrollerListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            ScrolledMozillaBrowser.this.browser.scrollToY(ScrolledMozillaBrowser.this.vScroll.getValue());
        }
    }

    private class HorizontalScrollerListener
    implements AdjustmentListener {
        private HorizontalScrollerListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = UIUtils.getComponentOrientation().isLeftToRight() ? ScrolledMozillaBrowser.this.hScroll.getValue() : ScrolledMozillaBrowser.this.hScroll.getMaximum() - ScrolledMozillaBrowser.this.hScroll.getValue() - ScrolledMozillaBrowser.this.hScroll.getVisibleAmount();
            ScrolledMozillaBrowser.this.browser.scrollToX(n);
        }
    }

    private class BrowserResizedListener
    extends ComponentAdapter {
        private BrowserResizedListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            try {
                ScrollBarInfo scrollBarInfo = ScrolledMozillaBrowser.this.browser.getScrollBarInfo();
                ScrolledMozillaBrowser.this.vScroll.setModel(new DefaultBoundedRangeModel(scrollBarInfo.getYPos(), scrollBarInfo.getCurrentHeight(), 0, scrollBarInfo.getTotalHeight()));
                ScrolledMozillaBrowser.this.vScroll.setBlockIncrement(scrollBarInfo.getCurrentHeight());
                ScrolledMozillaBrowser.this.hScroll.setModel(new DefaultBoundedRangeModel(scrollBarInfo.getXPos(), scrollBarInfo.getCurrentWidth(), 0, scrollBarInfo.getTotalWidth()));
                if (scrollBarInfo.getTotalHeight() == scrollBarInfo.getCurrentHeight()) {
                    ScrolledMozillaBrowser.this.vScroll.setVisible(false);
                    ScrolledMozillaBrowser.this.vScroll.getParent().validate();
                } else {
                    ScrolledMozillaBrowser.this.vScroll.setVisible(true);
                }
                if (scrollBarInfo.getTotalWidth() == scrollBarInfo.getCurrentWidth()) {
                    ScrolledMozillaBrowser.this.hScroll.setVisible(false);
                    ScrolledMozillaBrowser.this.vScroll.getParent().validate();
                    Container container = ScrolledMozillaBrowser.this.browser.getCanvas().getParent();
                    container.setSize(container.getWidth() + 1, container.getHeight() + 1);
                    container.setSize(container.getWidth() - 1, container.getHeight() - 1);
                } else {
                    ScrolledMozillaBrowser.this.hScroll.setVisible(true);
                }
                ScrolledMozillaBrowser.this.vScroll.getParent().validate();
                ScrolledMozillaBrowser.this.hScroll.getParent().validate();
                ScrolledMozillaBrowser.this.validate();
                ScrolledMozillaBrowser.this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

