/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.multyactionlabel;

import com.appframework.resources.GWIcons;
import com.appframework.utils.UIUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.basic.BasicIconFactory;

public class CombinedCheckedIcon
extends ImageIcon {
    private int gap = 4;
    protected Icon checkIcon;
    protected Icon mainIcon;
    private BufferedImage bufferedImage;
    private boolean isLeftToRight = true;

    public CombinedCheckedIcon(Icon icon) {
        if (icon == null) {
            icon = GWIcons.EMPTY_ICON;
        }
        this.mainIcon = icon;
        this.checkIcon = BasicIconFactory.getCheckBoxMenuItemIcon();
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        this.isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
    }

    public CombinedCheckedIcon() {
        this.checkIcon = BasicIconFactory.getCheckBoxMenuItemIcon();
        this.gap = 7;
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        this.isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = 0;
        if (this.mainIcon != null && this.checkIcon.getIconHeight() < this.mainIcon.getIconHeight()) {
            n3 = (this.mainIcon.getIconHeight() - this.checkIcon.getIconHeight()) / 2;
        }
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        graphics2D.setColor(graphics.getColor());
        if (this.isLeftToRight) {
            this.checkIcon.paintIcon(component, graphics2D, 0, n3 + 1);
            if (this.mainIcon != null) {
                this.mainIcon.paintIcon(component, graphics2D, this.checkIcon.getIconWidth() + this.gap, 0);
            }
        } else {
            this.checkIcon.paintIcon(component, graphics2D, this.getIconWidth() - this.checkIcon.getIconWidth(), n3 + 1);
            if (this.mainIcon != null) {
                this.mainIcon.paintIcon(component, graphics2D, this.getIconWidth() - (this.checkIcon.getIconWidth() + this.gap + this.mainIcon.getIconWidth()), 0);
            }
        }
        graphics.drawImage(this.getImage(), n, n2, this.getImageObserver());
    }

    public int getIconWidth() {
        if (this.mainIcon != null) {
            return this.checkIcon.getIconWidth() + this.mainIcon.getIconWidth() + this.gap;
        }
        return this.checkIcon.getIconWidth() + this.gap;
    }

    public int getIconHeight() {
        if (this.mainIcon != null) {
            return Math.max(this.checkIcon.getIconHeight(), this.mainIcon.getIconHeight());
        }
        return this.checkIcon.getIconHeight();
    }
}

