/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.event;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.LevelEventHandler;
import com.appframework.level.Level;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AppEventManager {
    private static final String ERROR_LISTENER_NOT_CONTAIN = "Listener is not contain in AppEventManager";
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$event$AppEventManager == null ? (class$com$appframework$event$AppEventManager = AppEventManager.class$("com.appframework.event.AppEventManager")) : class$com$appframework$event$AppEventManager));
    private HashMap handlers = new HashMap();
    private static AppEventManager instance;
    static /* synthetic */ Class class$com$appframework$event$AppEventManager;

    private AppEventManager() {
    }

    public static AppEventManager getInstance() {
        if (instance == null) {
            instance = new AppEventManager();
        }
        return instance;
    }

    public void addListener(Level level, int n, AppEventListener appEventListener) {
        Integer n2 = new Integer(n);
        if (this.handlers.containsKey(level)) {
            this.getLevelEventHandler(level).add(n2, appEventListener);
        } else {
            LevelEventHandler levelEventHandler = new LevelEventHandler();
            levelEventHandler.add(n2, appEventListener);
            this.handlers.put(level, levelEventHandler);
        }
    }

    public void removeListener(Level level, int n, AppEventListener appEventListener) {
        Integer n2 = new Integer(n);
        if (this.contains(level, n2, appEventListener)) {
            LevelEventHandler levelEventHandler = this.getLevelEventHandler(level);
            levelEventHandler.remove(n2, appEventListener);
            if (levelEventHandler.isEmpty()) {
                this.handlers.remove(level);
            }
        } else {
            throw new IllegalArgumentException(ERROR_LISTENER_NOT_CONTAIN);
        }
    }

    private boolean contains(Level level, Integer n, AppEventListener appEventListener) {
        boolean bl = false;
        if (this.handlers.containsKey(level)) {
            bl = this.getLevelEventHandler(level).contains(n, appEventListener);
        }
        return bl;
    }

    public void processEvent(AppEvent appEvent) {
        Level level = appEvent.getLevel();
        if (this.handlers.containsKey(level)) {
            this.getLevelEventHandler(level).process(appEvent);
        }
    }

    private LevelEventHandler getLevelEventHandler(Level level) {
        return (LevelEventHandler)this.handlers.get(level);
    }

    public void processGlobalEvent(AppEvent appEvent) {
        Collection collection = this.handlers.values();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            LevelEventHandler levelEventHandler = (LevelEventHandler)objectArray[i];
            levelEventHandler.process(appEvent);
        }
    }

    public void release(Level level) {
        this.handlers.remove(level);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

