/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.event;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;

class LevelEventHandler {
    private static final String ERROR_LISTENER_CONTAINS = "Listener already contains in LevelEventHandler";
    private HashMap handlers = new HashMap();

    LevelEventHandler() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void add(Integer n, AppEventListener appEventListener) {
        if (this.handlers.containsKey(n)) {
            if (this.contains(n, appEventListener)) throw new IllegalArgumentException(ERROR_LISTENER_CONTAINS);
            ArrayList arrayList = this.getListeners(n);
            arrayList.add(appEventListener);
            return;
        } else {
            ArrayList<AppEventListener> arrayList = new ArrayList<AppEventListener>();
            arrayList.add(appEventListener);
            this.handlers.put(n, arrayList);
        }
    }

    boolean contains(Integer n, AppEventListener appEventListener) {
        return this.getListeners(n).contains(appEventListener);
    }

    void remove(Integer n, AppEventListener appEventListener) {
        ArrayList arrayList = this.getListeners(n);
        if (arrayList != null) {
            arrayList.remove(appEventListener);
            if (arrayList.isEmpty()) {
                this.handlers.remove(n);
            }
        }
    }

    void process(AppEvent appEvent) {
        Integer n = appEvent.getEventID();
        ArrayList arrayList = this.getListeners(n);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                AppEventListener appEventListener = (AppEventListener)arrayList.get(i);
                if (!appEventListener.isListenerEnabled()) continue;
                this.handleEvent(appEvent, appEventListener);
            }
        }
    }

    private void handleEvent(AppEvent appEvent, AppEventListener appEventListener) {
        if (SwingUtilities.isEventDispatchThread()) {
            appEventListener.handle(appEvent);
        } else {
            SwingUtilities.invokeLater(new Runner(appEvent, appEventListener));
        }
    }

    ArrayList getListeners(Integer n) {
        return (ArrayList)this.handlers.get(n);
    }

    boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    int size() {
        return this.handlers.size();
    }

    private class Runner
    implements Runnable {
        private AppEvent appEvent;
        private AppEventListener appEventListener;

        public Runner(AppEvent appEvent, AppEventListener appEventListener) {
            this.appEvent = appEvent;
            this.appEventListener = appEventListener;
        }

        public void run() {
            this.appEventListener.handle(this.appEvent);
        }
    }
}

