/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.filter;

import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.EmptyFilter;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.util.Hashtable;

public class FiltersFactory {
    private Hashtable filters = new Hashtable();
    private static FiltersFactory instance;

    public static FiltersFactory getInstance() {
        if (instance == null) {
            instance = new FiltersFactory();
        }
        return instance;
    }

    private Filter createFilter(Level level) {
        EmptyFilter emptyFilter = new EmptyFilter();
        this.filters.put(level, emptyFilter);
        return emptyFilter;
    }

    public void releaseFilter(Level level) {
        this.filters.remove(level);
    }

    public Filter getFilter(MVCController mVCController) {
        Level level = LevelManager.getInstance().getFrameLevel(mVCController.getLevel());
        Filter filter = (Filter)this.filters.get(level);
        if (filter == null) {
            filter = this.createFilter(level);
        }
        return filter;
    }

    public void setFilter(MVCController mVCController, Filter filter) {
        Level level = LevelManager.getInstance().getFrameLevel(mVCController.getLevel());
        this.filters.put(level, filter);
    }

    public void clearAll() {
        this.filters.clear();
    }
}

