/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.level;

import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.mvc.ControllerManager;
import java.util.List;

public class LevelManager {
    private final Level globalLevel = new Level(0L);
    private static LevelManager instance;
    protected int levelCounter = 0;

    public static LevelManager getInstance() {
        if (instance == null) {
            instance = new LevelManager();
        }
        return instance;
    }

    private LevelManager() {
    }

    public Level getGlobalLevel() {
        return this.globalLevel;
    }

    public Level createLevel() {
        return this.createLevel(null);
    }

    public Level createLevel(Level level) {
        if (level == null) {
            level = this.getGlobalLevel();
        }
        return new Level(++this.levelCounter, level);
    }

    public Level getFrameLevel(Level level) {
        Level level2 = level;
        while (!this.getGlobalLevel().equals(level2.getParent())) {
            level2 = level2.getParent();
        }
        return level2;
    }

    public void release(Level level) {
        Level level2;
        List list = level.getChildren();
        while (list.size() > 0) {
            level2 = (Level)list.get(0);
            this.release(level2);
        }
        ControllerManager.getInstance().release(level);
        AppEventManager.getInstance().release(level);
        level2 = level.getParent();
        if (level2 != null) {
            level2.remove(level);
        }
    }
}

