/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.components.multyactionlabel.CombinedCheckedIcon;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBoxMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientableMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public final class OS {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$utils$OS == null ? (class$com$appframework$utils$OS = OS.class$("com.appframework.utils.OS")) : class$com$appframework$utils$OS));
    private static boolean MacOS = false;
    private static boolean WinOS = false;
    private static boolean LinuxOS = false;
    private static boolean i386Arch = true;
    private static boolean AquaLAF = false;
    private static boolean KDESession = false;
    private static int MetaKey;
    private static Locale myLocale;
    static /* synthetic */ Class class$com$appframework$utils$OS;

    public static void init() {
        Object object;
        String string = System.getProperty("os.arch");
        String string2 = System.getProperty("os.name");
        if (string2.equals("Mac OS X")) {
            MacOS = true;
            if (string.equals("ppc")) {
                i386Arch = false;
            }
            OS.setMacPreferences();
            object = UIManager.getLookAndFeel();
            String string3 = ((LookAndFeel)object).getName();
            if (string3.equals("Mac OS X Aqua")) {
                AquaLAF = true;
            }
        } else if (string2.indexOf("Win") != -1) {
            WinOS = true;
        } else if (string2.equals("Linux")) {
            LinuxOS = true;
            KDESession = Utils.isKDESession();
        }
        object = Toolkit.getDefaultToolkit();
        MetaKey = ((Toolkit)object).getMenuShortcutKeyMask();
        myLocale = Locale.getDefault();
    }

    private static void setMacPreferences() {
        UIManager.put("JFileChooser.appBundleIsTraversable", "never");
        UIManager.put("JFileChooser.packageIsTraversable", "never");
        System.setProperty("apple.awt.use-file-dialog-packages", "true");
        System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    public static boolean isMacOS() {
        return MacOS;
    }

    public static boolean isWinOS() {
        return WinOS;
    }

    public static boolean is_i386Arch() {
        return i386Arch;
    }

    public static boolean isKDESession() {
        return KDESession;
    }

    public static boolean isAquaLAF() {
        return AquaLAF;
    }

    public static boolean isLinuxOS() {
        return LinuxOS;
    }

    public static int getMetaKey() {
        return MetaKey;
    }

    public static String getLanguage() {
        String string = myLocale.getLanguage();
        logger.debug((Object)("language = " + string));
        return string;
    }

    public static String getDictLanguage() {
        String string = myLocale.getLanguage();
        String string2 = myLocale.getCountry();
        String string3 = myLocale.getVariant();
        if (string2 != null && !string2.equals("") && !string.equalsIgnoreCase(string2)) {
            string = string + "-" + string2;
        }
        logger.debug((Object)("country = " + string2));
        logger.debug((Object)("variant = " + string3));
        logger.debug((Object)("language = " + string));
        return string;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        boolean bl = OS.isMacOS() ? SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isControlDown() : SwingUtilities.isLeftMouseButton(mouseEvent);
        return bl;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        boolean bl = OS.isMacOS() ? SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isControlDown() || SwingUtilities.isRightMouseButton(mouseEvent) : SwingUtilities.isRightMouseButton(mouseEvent);
        return bl;
    }

    public static boolean isDoubleClick(MouseEvent mouseEvent) {
        return OS.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2;
    }

    public static JMenuItem createMenuItem(AppAction appAction) {
        KeyStroke keyStroke;
        JMenuItem jMenuItem;
        AppActionModel appActionModel = appAction.getAppActionModel();
        if (appActionModel.isCheckable()) {
            if (MacOS) {
                jMenuItem = new OrientableCheckBoxMenuItem(appAction);
            } else {
                jMenuItem = new OrientableMenuItem(appAction);
                jMenuItem.setIcon(new CombinedCheckedIcon(appAction.getAppActionModel().getIcon()));
            }
        } else {
            jMenuItem = appActionModel.isRadio() ? new OrientableRadioButtonMenuItem(appAction) : new OrientableMenuItem(appAction);
        }
        if (MacOS) {
            jMenuItem.setIcon(null);
        } else {
            keyStroke = appActionModel.getMnemonic();
            int n = appActionModel.getMnemonicIndex();
            if (keyStroke != null && n != -1) {
                char c = keyStroke.getKeyChar();
                jMenuItem.setMnemonic(c);
                jMenuItem.setDisplayedMnemonicIndex(n);
            }
        }
        if (appActionModel.getAccelerator() != null) {
            keyStroke = appActionModel.getAccelerator();
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    public static JMenuItem createMenuItemForAction(Action action) {
        return OS.createMenuItemForAction(action, false);
    }

    public static JMenuItem createMenuItemForAction(Action action, boolean bl) {
        JMenuItem jMenuItem;
        if (bl) {
            if (MacOS) {
                jMenuItem = new OrientableCheckBoxMenuItem(action);
            } else {
                jMenuItem = new OrientableMenuItem(action);
                jMenuItem.setIcon(new CombinedCheckedIcon());
            }
        } else {
            jMenuItem = new OrientableMenuItem(action);
        }
        if (MacOS) {
            jMenuItem.setIcon(null);
        }
        return jMenuItem;
    }

    public static void addButtons(JPanel jPanel, JButton jButton, JButton jButton2) {
        if (OS.isMacOS()) {
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
    }

    public static void addButtons(JPanel jPanel, JButton jButton, JButton jButton2, JButton jButton3) {
        if (OS.isMacOS()) {
            jPanel.add(jButton3);
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

