/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.components.htmleditor.hyperlink.LinkParser;
import com.appframework.utils.OS;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.frames.options.compose.country.Language;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.log4j.Logger;

public final class UIUtils {
    private static Logger logger = Logger.getLogger((Class)(class$com$appframework$utils$UIUtils == null ? (class$com$appframework$utils$UIUtils = UIUtils.class$("com.appframework.utils.UIUtils")) : class$com$appframework$utils$UIUtils));
    public static final boolean GTK_LAF_USED;
    private static Set BACKWARD_KEYS;
    private static Set FORWARD_KEYS;
    private static ComponentOrientation uiOrientation;
    public static final String GTK_CLASS = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final Dimension TOOL_BUTTON_DIMENSION;
    public static final int MAX_CHARACTERS_PER_LINE = 100;
    public static final int TREE_ROW_HEIGHT;
    private static final String[] SYSTEM_FONTS;
    private static final boolean USE_AATEXT;
    static /* synthetic */ Class class$com$appframework$utils$UIUtils;

    public static void centerWindowOnScreen(Window window) {
        UIUtils.centerWindow(window, null);
    }

    public static void centerWindow(Window window, Component component) {
        UIUtils.centerWindow(window, ControlsUtils.getWindowForComponent(component));
    }

    public static void centerWindow(Window window, Window window2) {
        window.setLocationRelativeTo(window2);
    }

    public static void setPrefferedWindowSize(int n, int n2, Window window) {
        Dimension dimension;
        if (window != null && (dimension = Toolkit.getDefaultToolkit().getScreenSize()) != null) {
            window.pack();
            window.setSize(new Dimension(Math.max(n, Math.min(window.getWidth(), (int)((double)dimension.width * 0.75))), n2));
        }
    }

    public static void setFocusTraversalKeys(JComponent jComponent) {
        jComponent.setFocusTraversalKeys(0, FORWARD_KEYS);
        jComponent.setFocusTraversalKeys(1, BACKWARD_KEYS);
    }

    public static void restoreFrameState(Frame frame) {
        if (frame != null && frame.getExtendedState() == 1) {
            frame.setExtendedState(0);
            int n = 0;
            while (frame.getExtendedState() == 1) {
                try {
                    Thread.sleep(10L);
                    ++n;
                }
                catch (InterruptedException interruptedException) {
                    logger.error((Object)interruptedException);
                    logger.debug((Object)interruptedException, (Throwable)interruptedException);
                }
                if (n != 20) continue;
                logger.debug((Object)"Returned by time-out");
                return;
            }
        }
    }

    public static void closeOpenFrameForItem(AbstractItem abstractItem) {
        FrameOpen frameOpen = GWClient.getOpenFrame(abstractItem);
        if (frameOpen != null) {
            ((ApplicationFrameActionList)frameOpen.getController()).closeFrame();
            frameOpen = null;
        }
    }

    public static List breakStringIntoSubstrings1(String string, FontMetrics fontMetrics, int n) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public static List breakStringIntoSubstrings(String string, FontMetrics fontMetrics, int n) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = string2 = string;
        while (true) {
            int n2;
            if ((n2 = fontMetrics.stringWidth(string3)) < n || string3.length() == 1) {
                int n3;
                if (string2.length() > string3.length() && (n3 = string3.lastIndexOf(" ")) > 0) {
                    string3 = string3.substring(0, n3 + 1);
                }
                arrayList.add(string3);
                if (string3.length() >= string2.length()) break;
                string3 = string2 = string2.substring(string3.length());
                continue;
            }
            string3 = string3.substring(0, string3.length() - 1);
        }
        return arrayList;
    }

    public static void setComponentsEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        UIUtils.setComponentsEnabled(componentArray, bl);
    }

    public static void setComponentsEnabled(Component[] componentArray, boolean bl) {
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setEditable(bl);
            } else if (!(component instanceof JLabel)) {
                component.setEnabled(bl);
            }
            if (!(component instanceof Container)) continue;
            UIUtils.setComponentsEnabled((Container)componentArray[i], bl);
        }
    }

    public static void setText(AbstractButton abstractButton, String string) {
        if (abstractButton != null && string != null) {
            abstractButton.setText(string);
            if (!OS.isMacOS()) {
                abstractButton.setMnemonic(StringResources.getMnemonic(string));
                abstractButton.setDisplayedMnemonicIndex(StringResources.getDisplayedMnemonicIndex(string));
            }
        }
    }

    public static void setMnemonic(AbstractButton abstractButton, int n) {
        if (!OS.isMacOS() && EngineLocale.getCurrent().getLocale().getLanguage().equals("en") && abstractButton.getText().length() > n + 1) {
            abstractButton.setDisplayedMnemonicIndex(n);
            abstractButton.setMnemonic(abstractButton.getText().charAt(n));
        }
    }

    public static int getYLocation(Container container) {
        if (container == null) {
            return 0;
        }
        return container.getY() + UIUtils.getYLocation(container.getParent());
    }

    public static void updateLabelHeight(JLabel jLabel) {
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        if (fontMetrics != null && fontMetrics.getDescent() > 0) {
            Dimension dimension = jLabel.getPreferredSize();
            dimension.height += fontMetrics.getDescent();
            jLabel.setPreferredSize(dimension);
        }
    }

    public static ComponentOrientation getComponentOrientation() {
        if (uiOrientation == null) {
            Locale locale = EngineCommandManager.getLocale();
            if (locale == null) {
                if (EngineCommandManager.getUserInfo() != null) {
                    Language language = OptionManager.getInstance().getGeneralOptions().getInterfaceLanguage();
                    if (language.getCode() != null) {
                        locale = new Locale(language.getCode().toLowerCase());
                    }
                } else {
                    String string = System.getProperty("user.lang");
                    if (string != null && string.length() > 0) {
                        locale = new Locale(string);
                    }
                }
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            uiOrientation = ComponentOrientation.getOrientation(locale);
        }
        return uiOrientation;
    }

    public static void resetOrientation() {
        uiOrientation = null;
    }

    public static void setPrefferedWindowSizeLocation(Window window, int n, int n2, int n3) {
        Dimension dimension;
        if (window != null && (dimension = Toolkit.getDefaultToolkit().getScreenSize()) != null) {
            window.setBounds(n2, n3, Math.min((int)window.getPreferredSize().getWidth(), (int)((double)dimension.width * 0.75)), n);
        }
    }

    public static AbstractButton createToolButton(AbstractAction abstractAction) {
        ToolBarButton toolBarButton = new ToolBarButton(abstractAction);
        toolBarButton.setPreferredSize(TOOL_BUTTON_DIMENSION);
        return toolBarButton;
    }

    public static void initFocusTraversalKeys(Component component) {
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        component.setFocusTraversalKeys(0, hashSet);
        hashSet.clear();
        hashSet.add(KeyStroke.getKeyStroke(9, 64));
        component.setFocusTraversalKeys(1, hashSet);
    }

    public static void initTabbedPaneMaps(JTabbedPane jTabbedPane) {
        InputMap inputMap = SwingUtilities.getUIInputMap(jTabbedPane, 1);
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeArray[i];
            int n = keyStroke.getKeyCode();
            if (n != 224 && n != 38) continue;
            inputMap.remove(keyStroke);
        }
        InputMap inputMap2 = new InputMap();
        keyStrokeArray = inputMap.allKeys();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeArray[i];
            Object object = inputMap.get(keyStroke);
            inputMap2.put(keyStroke, object);
        }
        SwingUtilities.replaceUIInputMap(jTabbedPane, 1, inputMap2);
    }

    public static void initTableFocusTraversalKeys(JTable jTable) {
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        jTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet();
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        jTable.setFocusTraversalKeys(1, hashSet);
    }

    public static void scrollComponent(Point point, JComponent jComponent, int n) {
        if (point.y + jComponent.getY() + n > jComponent.getVisibleRect().height) {
            point.y += n;
        }
        if (point.y + jComponent.getY() < n) {
            point.y -= n;
        }
        if (point.x + jComponent.getX() + n > jComponent.getVisibleRect().width) {
            point.x += n;
        }
        if (point.x + jComponent.getX() < n) {
            point.x -= n;
        }
        jComponent.scrollRectToVisible(new Rectangle(point));
    }

    public static String[] getSystemFonts() {
        return (String[])SYSTEM_FONTS.clone();
    }

    public static String cutStringToWidth(String string, Graphics graphics, int n) {
        return UIUtils.cutStringToWidth(string, graphics.getFontMetrics(), n);
    }

    public static String cutStringToWidth(String string, FontMetrics fontMetrics, int n) {
        if (n <= 0) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        if (n2 <= n) {
            return string;
        }
        double d = (double)n / (double)n2;
        int n3 = string.length();
        int n4 = (int)((double)n3 * d) - 4;
        if (n4 < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n4)).append("...");
        n2 = SwingUtilities.computeStringWidth(fontMetrics, stringBuffer.toString());
        while (n2 > n) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 4);
            n2 = SwingUtilities.computeStringWidth(fontMetrics, stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static final int computeMaxWidth(JComponent jComponent, String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = UIUtils.getStrWidthForComponent(jComponent, stringArray[i]);
        }
        Arrays.sort(nArray);
        return nArray[nArray.length - 1];
    }

    public static int getStrWidthForComponent(JComponent jComponent, String string) {
        if (string == null) {
            return 0;
        }
        return SwingUtilities.computeStringWidth(jComponent.getFontMetrics(jComponent.getFont()), string);
    }

    public static void setButtonPreferedSize(AbstractButton abstractButton, String[] stringArray) {
        int n = UIUtils.computeMaxWidth(abstractButton, stringArray);
        int n2 = abstractButton.getPreferredSize().width - UIUtils.getStrWidthForComponent(abstractButton, abstractButton.getText()) + n;
        abstractButton.setPreferredSize(new Dimension(n2, abstractButton.getPreferredSize().height));
    }

    public static boolean isJDKMoreThan5() {
        return System.getProperty("java.version").compareTo("1.5.0") >= 0;
    }

    public static String wrapIntoHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><head></head>");
        stringBuffer.append("<body>");
        stringBuffer.append(LinkParser.createLinkedText(string));
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public static String wrapIntoRTF(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setText(string);
            Document document = jTextPane.getDocument();
            int n = document.getLength();
            new RTFEditorKit().write(byteArrayOutputStream, document, 0, n);
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            logger.debug((Object)exception);
            logger.error((Object)exception, (Throwable)exception);
        }
        return byteArrayOutputStream.toString();
    }

    public static Graphics enableAntialiasing(Graphics graphics) {
        if (USE_AATEXT && graphics instanceof Graphics2D && !OS.isMacOS()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        return graphics;
    }

    public static int getColumnWidth(int n, Component component) {
        int n2 = 0;
        if (n > 0 && component != null) {
            FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
            int n3 = fontMetrics.charWidth('m');
            n2 = n * n3;
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TOOL_BUTTON_DIMENSION = new Dimension(21, 21);
        TREE_ROW_HEIGHT = (Integer)UIManager.getDefaults().get("Tree.rowHeight");
        SYSTEM_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        USE_AATEXT = new Boolean(System.getProperty("swing.aatext"));
        FORWARD_KEYS = new HashSet();
        FORWARD_KEYS.add(KeyStroke.getKeyStroke(39, 0));
        FORWARD_KEYS.add(KeyStroke.getKeyStroke(9, 0));
        FORWARD_KEYS = Collections.unmodifiableSet(FORWARD_KEYS);
        BACKWARD_KEYS = new HashSet();
        BACKWARD_KEYS.add(KeyStroke.getKeyStroke(37, 0));
        BACKWARD_KEYS.add(KeyStroke.getKeyStroke(9, 1));
        BACKWARD_KEYS = Collections.unmodifiableSet(BACKWARD_KEYS);
        GTK_LAF_USED = GTK_CLASS.equals(UIManager.getLookAndFeel().getClass().getName());
    }
}

