/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils.wait;

import com.appframework.utils.wait.DelayTimer;
import com.appframework.utils.wait.DispatchedEvent;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

class CursorManager {
    private final DelayTimer waitTimer;
    private final Stack dispatchedEvents = new Stack();
    private boolean needsCleanup;

    public CursorManager(DelayTimer delayTimer) {
        this.waitTimer = delayTimer;
    }

    private void cleanUp() {
        if (((DispatchedEvent)this.dispatchedEvents.peek()).resetCursor()) {
            this.clearQueueOfInputEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueueOfInputEvents() {
        EventQueue eventQueue;
        EventQueue eventQueue2 = eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        synchronized (eventQueue2) {
            ArrayList arrayList = this.gatherNonInputEvents(eventQueue);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                eventQueue.postEvent((AWTEvent)iterator.next());
            }
        }
    }

    private ArrayList gatherNonInputEvents(EventQueue eventQueue) {
        ArrayList<AWTEvent> arrayList = new ArrayList<AWTEvent>();
        while (eventQueue.peekEvent() != null) {
            try {
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                if (aWTEvent instanceof InputEvent) continue;
                arrayList.add(aWTEvent);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        return arrayList;
    }

    public void push(Object object) {
        if (this.needsCleanup) {
            this.waitTimer.stopTimer();
            this.cleanUp();
        }
        this.dispatchedEvents.push(new DispatchedEvent(object));
        this.needsCleanup = true;
    }

    public void pop() {
        this.cleanUp();
        this.dispatchedEvents.pop();
        if (!this.dispatchedEvents.isEmpty()) {
            this.waitTimer.startTimer();
        } else {
            this.needsCleanup = false;
        }
    }

    public void setCursor() {
        ((DispatchedEvent)this.dispatchedEvents.peek()).setCursor();
    }
}

