/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils.wait;

import com.appframework.utils.wait.CursorManager;
import com.appframework.utils.wait.DelayTimer;
import com.appframework.utils.wait.DelayTimerCallback;
import java.awt.AWTEvent;
import java.awt.EventQueue;

public class WaitCursorEventQueue
extends EventQueue
implements DelayTimerCallback {
    private final CursorManager cursorManager;
    private final DelayTimer waitTimer;
    private boolean shutdowning = false;

    public WaitCursorEventQueue() {
        this(70);
    }

    public WaitCursorEventQueue(int n) {
        this.waitTimer = new DelayTimer(this, n);
        this.cursorManager = new CursorManager(this.waitTimer);
    }

    public void close() {
        this.waitTimer.quit();
        this.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent aWTEvent) {
        if (!this.shutdowning) {
            this.cursorManager.push(aWTEvent.getSource());
            this.waitTimer.startTimer();
            try {
                super.dispatchEvent(aWTEvent);
            }
            finally {
                this.waitTimer.stopTimer();
                this.cursorManager.pop();
            }
        }
        try {
            super.dispatchEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdowning = true;
    }

    public AWTEvent getNextEvent() throws InterruptedException {
        this.waitTimer.stopTimer();
        return super.getNextEvent();
    }

    public void trigger() {
        this.cursorManager.setCursor();
    }
}

