/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.utils.UIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class ExTableUI
extends BasicTableUI {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$ExTableUI == null ? (class$com$novell$gw$jclient$application$ExTableUI = ExTableUI.class$("com.novell.gw.jclient.application.ExTableUI")) : class$com$novell$gw$jclient$application$ExTableUI));
    private int startFrom;
    private int mergedCellsCount;
    private List rows = new ArrayList();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$ExTableUI;

    public ExTableUI() {
    }

    public ExTableUI(int n, int n2, List list) {
        this.startFrom = n;
        this.mergedCellsCount = n2;
        this.rows = list;
    }

    public void setStartFrom(int n) {
        this.startFrom = n;
    }

    public void setMergedCellsCount(int n) {
        this.mergedCellsCount = n;
    }

    public void setRows(List list) {
        this.rows = list;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            return;
        }
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.columnAtPoint(this.table, (bl = this.table.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n4 = this.columnAtPoint(this.table, bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        if (this.rows.contains(new Integer(n))) {
            if (n4 == -1) {
                n4 = this.table.getColumnCount() - 1;
            }
            this.paintGrid(graphics, n, n, n3, n4);
            n4 = this.table.columnAtPoint(bl ? point2 : point);
            if (n4 == -1) {
                n4 = this.table.getColumnCount() - 1;
            }
            this.paintCells(graphics, n, n, n3, n4);
            if (n + 1 <= n2) {
                this.paintGrid(graphics, n + 1, n2, n3, n4);
                this.paintCells(graphics, n + 1, n2, n3, n4);
            }
        } else {
            this.paintGrid(graphics, n, n2, n3, n4);
            this.paintCells(graphics, n, n2, n3, n4);
        }
    }

    private int columnAtPoint(JTable jTable, Point point) {
        int n = jTable.columnAtPoint(point);
        Integer n2 = new Integer(jTable.rowAtPoint(point));
        if (n >= this.startFrom && n < this.mergedCellsCount + this.startFrom && this.rows.contains(n2)) {
            n = this.startFrom;
        }
        return n;
    }

    private void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        graphics.setColor(this.table.getGridColor());
        Rectangle rectangle = this.getCellRect(this.table, n, n3, true);
        Rectangle rectangle2 = this.getCellRect(this.table, n2, n4, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        if (this.table.getShowHorizontalLines()) {
            int n7 = rectangle3.x + rectangle3.width;
            n6 = rectangle3.y;
            for (n5 = n; n5 <= n2; ++n5) {
                graphics.drawLine(rectangle3.x, (n6 += this.table.getRowHeight(n5)) - 1, n7 - 1, n6 - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n5 = rectangle3.x;
                for (int i = n3; i <= n4; ++i) {
                    int n8 = tableColumnModel.getColumn(i).getWidth();
                    graphics.drawLine((n5 += n8) - 1, 0, n5 - 1, n6 - 1);
                }
            } else {
                n5 = rectangle3.x + rectangle3.width;
                for (int i = n3; i < n4; ++i) {
                    int n9 = tableColumnModel.getColumn(i).getWidth();
                    graphics.drawLine((n5 -= n9) - 1, 0, n5 - 1, n6 - 1);
                }
                graphics.drawLine(n5 -= tableColumnModel.getColumn(n4).getWidth(), 0, n5, n6 - 1);
            }
        }
    }

    private Rectangle getCellRect(JTable jTable, int n, int n2, boolean bl) {
        Rectangle rectangle = jTable.getCellRect(n, n2, bl);
        if (n2 == this.startFrom && this.rows.contains(new Integer(n))) {
            for (int i = this.startFrom + 1; i < this.mergedCellsCount + this.startFrom; ++i) {
                rectangle.width += jTable.getCellRect((int)n, (int)i, (boolean)true).width;
            }
            if (!UIUtils.getComponentOrientation().isLeftToRight()) {
                rectangle.x = jTable.getCellRect((int)n, (int)(this.mergedCellsCount + this.startFrom), (boolean)bl).x;
            }
        }
        if (n2 < this.mergedCellsCount + this.startFrom && n2 > this.startFrom && this.rows.contains(new Integer(n))) {
            rectangle.width = 0;
        }
        return rectangle;
    }

    private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    Rectangle rectangle = this.getCellRect(this.table, i, j, false);
                    TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                    int n6 = tableColumn2.getWidth();
                    if (j == this.startFrom && this.rows.contains(new Integer(i))) {
                        for (int k = this.startFrom + 1; k < this.startFrom + this.mergedCellsCount; ++k) {
                            n6 += tableColumnModel.getColumn(k).getWidth();
                        }
                    }
                    if (tableColumn2 == tableColumn) continue;
                    this.paintCell(graphics, rectangle, i, j);
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
                for (int j = n3; j <= n4; ++j) {
                    Rectangle rectangle = this.getCellRect(this.table, i, j, false);
                    tableColumn3 = tableColumnModel.getColumn(j);
                    int n7 = tableColumn3.getWidth();
                    if (j == this.startFrom && this.rows.contains(new Integer(i))) {
                        for (int k = this.startFrom + 1; k < this.startFrom + this.mergedCellsCount; ++k) {
                            n7 += tableColumnModel.getColumn(k).getWidth();
                        }
                    }
                    if (tableColumn3 == tableColumn) continue;
                    this.paintCell(graphics, rectangle, i, j);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.getCellRect(this.table, n, n6, true);
        Rectangle rectangle2 = this.getCellRect(this.table, n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            n4 = n7 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
            graphics.drawLine(n8, n7, n8, n4);
        }
        for (n5 = n; n5 <= n2; ++n5) {
            Rectangle rectangle4 = this.getCellRect(this.table, n5, n6, false);
            rectangle4.x += n3;
            this.paintCell(graphics, rectangle4, n5, n6);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.getCellRect(this.table, n5, n6, true);
            rectangle5.x += n3;
            n4 = rectangle5.x;
            int n9 = rectangle5.y;
            int n10 = n4 + rectangle5.width - 1;
            int n11 = n9 + rectangle5.height - 1;
            graphics.drawLine(n4, n11, n10, n11);
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getTableViewActionMap();
        SwingUtilities.replaceUIActionMap(this.table, actionMap);
        InputMap inputMap = this.getTableViewInputMap();
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
        SwingUtilities.replaceUIInputMap(this.table, 0, inputMap);
    }

    private InputMap getTableViewInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        inputMapUIResource.put(KeyStroke.getKeyStroke(40, 0), "selectNextRow");
        inputMapUIResource.put(KeyStroke.getKeyStroke(38, 0), "selectPreviousRow");
        inputMapUIResource.put(KeyStroke.getKeyStroke(40, 1), "selectNextRowExtendSelection");
        inputMapUIResource.put(KeyStroke.getKeyStroke(38, 1), "selectPreviousRowExtendSelection");
        inputMapUIResource.put(KeyStroke.getKeyStroke(33, 0), "scrollUpChangeSelection");
        inputMapUIResource.put(KeyStroke.getKeyStroke(34, 0), "scrollDownChangeSelection");
        inputMapUIResource.put(KeyStroke.getKeyStroke(33, 1), "scrollUpExtendSelection");
        inputMapUIResource.put(KeyStroke.getKeyStroke(34, 1), "scrollDownExtendSelection");
        inputMapUIResource.put(KeyStroke.getKeyStroke(36, 0), "selectFirstRow");
        inputMapUIResource.put(KeyStroke.getKeyStroke(35, 0), "selectLastRow");
        inputMapUIResource.put(KeyStroke.getKeyStroke(36, 1), "selectFirstRowExtendSelection");
        inputMapUIResource.put(KeyStroke.getKeyStroke(35, 1), "selectLastRowExtendSelection");
        return inputMapUIResource;
    }

    private ActionMap getTableViewActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectNextRow", new NavigationalAction(0, 1, false, false, false));
        actionMapUIResource.put("selectPreviousRow", new NavigationalAction(0, -1, false, false, false));
        actionMapUIResource.put("selectNextRowExtendSelection", new NavigationalAction(0, 1, false, true, false));
        actionMapUIResource.put("selectPreviousRowExtendSelection", new NavigationalAction(0, -1, false, true, false));
        actionMapUIResource.put("scrollUpChangeSelection", new PagingAction(false, false, true, false));
        actionMapUIResource.put("scrollDownChangeSelection", new PagingAction(false, true, true, false));
        actionMapUIResource.put("scrollUpExtendSelection", new PagingAction(true, false, true, false));
        actionMapUIResource.put("scrollDownExtendSelection", new PagingAction(true, true, true, false));
        actionMapUIResource.put("selectFirstRow", new PagingAction(false, false, true, true));
        actionMapUIResource.put("selectLastRow", new PagingAction(false, true, true, true));
        actionMapUIResource.put("selectFirstRowExtendSelection", new PagingAction(true, false, true, true));
        actionMapUIResource.put("selectLastRowExtendSelection", new PagingAction(true, true, true, true));
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PagingAction
    extends NavigationalAction {
        private boolean forwards;
        private boolean vertically;
        private boolean toLimit;

        private PagingAction(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(0, 0, false, bl, false);
            this.forwards = bl2;
            this.vertically = bl3;
            this.toLimit = bl4;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            if (this.toLimit) {
                if (this.vertically) {
                    int n = jTable.getRowCount();
                    this.dx = 0;
                    this.dy = this.forwards ? n : -n;
                } else {
                    int n = jTable.getColumnCount();
                    this.dx = this.forwards ? n : -n;
                    this.dy = 0;
                }
            } else {
                int n;
                if (!(jTable.getParent().getParent() instanceof JScrollPane)) {
                    return;
                }
                Dimension dimension = jTable.getParent().getSize();
                ListSelectionModel listSelectionModel = this.vertically ? jTable.getSelectionModel() : jTable.getColumnModel().getSelectionModel();
                int n2 = n = this.extend ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel.getAnchorSelectionIndex();
                if (this.vertically) {
                    Rectangle rectangle = jTable.getCellRect(n, 0, true);
                    int n3 = dimension.height - (dimension.height % jTable.getRowHeight() + jTable.getRowHeight());
                    rectangle.y = rectangle.y + (this.forwards ? n3 : -n3);
                    this.dx = 0;
                    int n4 = jTable.rowAtPoint(rectangle.getLocation());
                    if (n4 == -1 && this.forwards) {
                        n4 = jTable.getRowCount();
                    }
                    this.dy = n4 - n;
                } else {
                    Rectangle rectangle = jTable.getCellRect(0, n, true);
                    rectangle.x = rectangle.x + (this.forwards ? dimension.width : -dimension.width);
                    int n5 = jTable.columnAtPoint(rectangle.getLocation());
                    if (n5 == -1 && this.forwards) {
                        n5 = jTable.getColumnCount();
                    }
                    this.dx = n5 - n;
                    this.dy = 0;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean toggle;
        protected boolean extend;
        protected boolean inSelection;
        protected int anchorRow;
        protected int anchorColumn;
        protected int leadRow;
        protected int leadColumn;

        protected NavigationalAction(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            this.dx = n;
            this.dy = n2;
            this.toggle = bl;
            this.extend = bl2;
            this.inSelection = bl3;
        }

        private int clipToRange(int n, int n2, int n3) {
            return Math.min(Math.max(n, n2), n3 - 1);
        }

        private void moveWithinTableRange(JTable jTable, int n, int n2, boolean bl) {
            if (bl) {
                this.leadRow = this.clipToRange(this.leadRow + n2, 0, jTable.getRowCount());
                this.leadColumn = this.clipToRange(this.leadColumn + n, 0, jTable.getColumnCount());
            } else {
                this.anchorRow = this.clipToRange(this.anchorRow + n2, 0, jTable.getRowCount());
                this.anchorColumn = this.clipToRange(this.anchorColumn + n, 0, jTable.getColumnCount());
            }
        }

        private int selectionSpan(ListSelectionModel listSelectionModel) {
            return listSelectionModel.getMaxSelectionIndex() - listSelectionModel.getMinSelectionIndex() + 1;
        }

        private int compare(int n, ListSelectionModel listSelectionModel) {
            return this.compare(n, listSelectionModel.getMinSelectionIndex(), listSelectionModel.getMaxSelectionIndex() + 1);
        }

        private int compare(int n, int n2, int n3) {
            return n < n2 ? -1 : (n >= n3 ? 1 : 0);
        }

        private boolean moveWithinSelectedRange(JTable jTable, int n, int n2, boolean bl) {
            int n3;
            int n4;
            int n5;
            boolean bl2;
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            int n6 = this.anchorRow + n2;
            int n7 = this.anchorColumn + n;
            int n8 = this.selectionSpan(listSelectionModel);
            boolean bl3 = bl2 = n8 * (n5 = this.selectionSpan(listSelectionModel2)) > 1;
            if (bl2) {
                n4 = this.compare(n6, listSelectionModel);
                n3 = this.compare(n7, listSelectionModel2);
            } else {
                n8 = jTable.getRowCount();
                n5 = jTable.getColumnCount();
                n4 = this.compare(n6, 0, n8);
                n3 = this.compare(n7, 0, n5);
            }
            this.anchorRow = n6 - n8 * n4;
            this.anchorColumn = n7 - n5 * n3;
            if (!bl) {
                return this.moveWithinSelectedRange(jTable, n4, n3, true);
            }
            return bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            this.anchorRow = listSelectionModel.getAnchorSelectionIndex();
            this.leadRow = listSelectionModel.getLeadSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            this.anchorColumn = listSelectionModel2.getAnchorSelectionIndex();
            this.leadColumn = listSelectionModel2.getLeadSelectionIndex();
            int n = this.anchorRow;
            int n2 = this.anchorColumn;
            if (jTable.isEditing() && !jTable.getCellEditor().stopCellEditing()) {
                return;
            }
            if (!this.inSelection) {
                this.moveWithinTableRange(jTable, this.dx, this.dy, this.extend);
                if (!this.extend) {
                    jTable.changeSelection(this.anchorRow, this.anchorColumn, false, this.extend);
                } else {
                    jTable.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                }
            } else if (this.moveWithinSelectedRange(jTable, this.dx, this.dy, false)) {
                jTable.changeSelection(this.anchorRow, this.anchorColumn, true, true);
            } else {
                jTable.changeSelection(this.anchorRow, this.anchorColumn, false, false);
            }
        }
    }
}

