/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.AppAction;
import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.drag.DragManager;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.filter.FiltersFactory;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.appframework.selection.SelectionManagersFactory;
import com.appframework.utils.CommandLineUtils;
import com.appframework.utils.OS;
import com.appframework.utils.OSXAdapter;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.appframework.utils.wait.WaitCursorEventQueue;
import com.novell.gw.account.Account;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.LoginParameters;
import com.novell.gw.jclient.application.ClickAction;
import com.novell.gw.jclient.application.DevModeUtils;
import com.novell.gw.jclient.application.GWClientActionList;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWSplash;
import com.novell.gw.jclient.application.actions.ActionNewMail;
import com.novell.gw.jclient.application.actions.ActionShowWindow;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipUI;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.frames.options.AccountOptionsFrame;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.options.mailto.CommandLineOptions;
import com.novell.gw.jclient.application.options.mailto.MailToOptions;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GwAWTErrorHandler;
import com.novell.gw.jclient.bl.eng_impl.SSLSetup;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.impl.cache.ItemsCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.GWUserInfo;
import com.novell.gw.jclient.bl.om.PathManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.rmi.one_instance.RMIException;
import com.novell.gw.jclient.rmi.one_instance.client.GWClientRMIClient;
import com.novell.gw.jclient.rmi.one_instance.server.GWClientRMIServer;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class GWClient
extends Application {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$GWClient == null ? (class$com$novell$gw$jclient$application$GWClient = GWClient.class$("com.novell.gw.jclient.application.GWClient")) : class$com$novell$gw$jclient$application$GWClient));
    private static boolean USE_EXTERNAL_HTML_VIEWER;
    private static Application application;
    private static GWClientActionList gwClientActionList;
    private static final int WINDOW_MENU_ITEMS_COUNT = 2;
    private static WaitCursorEventQueue waitQueue;
    private static boolean performingExit;
    private static boolean inSync;
    private static GWClientRMIServer rmiServer;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$GWClient;

    public static void setperformingExit(boolean bl) {
        performingExit = bl;
    }

    public static boolean isPerformingExit() {
        return performingExit;
    }

    public static boolean isInSync() {
        return inSync;
    }

    public static void setInSync(boolean bl) {
        inSync = bl;
    }

    public GWClient() {
        this((String[])null);
    }

    public GWClient(String[] stringArray) {
        this.migrateAndCleanupOldOptions();
        LoginParameters loginParameters = EngineCommandManager.parseCommandLine(stringArray);
        Locale locale = EngineCommandManager.getLocale();
        if (locale != null) {
            try {
                Locale.setDefault(locale);
                System.setProperty("user.language", locale.getLanguage());
                System.setProperty("user.country", locale.getCountry());
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                logger.debug((Object)exception);
            }
        }
        this.beforeCreating();
        if (OS.isMacOS() && OS.is_i386Arch()) {
            USE_EXTERNAL_HTML_VIEWER = false;
        }
        StringResources.init(locale);
        PLAFChanger.changePlafWithSettingsFonts();
        PLAFChanger.bindOptionPaneStrings();
        PLAFChanger.bindFileChooserStrings();
        PLAFChanger.bindColorChooserStrings();
        GWSplash gWSplash = GWSplash.getInstance();
        gWSplash.pack();
        UIUtils.centerWindowOnScreen(gWSplash);
        gWSplash.setVisible(true);
        gWSplash.startConnecting();
        this.login(loginParameters, gWSplash);
        UIUtils.resetOrientation();
        PLAFChanger.bindOptionPaneStrings();
        if (DevModeUtils.useTestResources()) {
            StringResources.initTestStringResources();
        }
        OptionManager.getInstance().clearOptions();
        gWSplash.stopConnecting();
        this.checkWebRendererVerion();
        GWMainAppFrame gWMainAppFrame = new GWMainAppFrame();
        GlobalCommand globalCommand = new GlobalCommand(480, gWMainAppFrame);
        gWMainAppFrame.getController().processCommand(globalCommand);
        gWSplash.setVisible(false);
        gWSplash.dispose();
        gWMainAppFrame.showMe();
        this.afterCreating(stringArray);
    }

    private void migrateAndCleanupOldOptions() {
        Object object;
        File file;
        File file2;
        boolean bl;
        File file3 = new File(PathManager.getInstance().getBaseOptionsPath());
        if (!file3.exists()) {
            bl = file3.mkdirs();
            logger.debug((Object)("Created new base dir: " + bl));
        }
        if ((file2 = new File(PathManager.OLDOPTIONSPATH)).exists()) {
            file = new File(file2, "Engine");
            if (file.exists()) {
                Utils.clearDir(file);
                bl = file.delete();
                logger.debug((Object)("Deleted old temp Engine dir: " + bl));
            }
            if ((file = new File(file2, "XpGWViews")).exists()) {
                Utils.clearDir(file);
                bl = file.delete();
                logger.debug((Object)("Deleted old temp XpGWViews dir: " + bl));
            }
            if ((file = new File(file2, ".unknown_user")).exists()) {
                Utils.clearDir(file);
                bl = file.delete();
                logger.debug((Object)("Deleted old temp .unknown_user dir: " + bl));
            }
            if (((File[])(object = file2.listFiles())).length == 0) {
                bl = file2.delete();
                logger.debug((Object)("Deleted old .Groupwise dir: " + bl));
            }
        }
        if ((file = new File(Utils.USER_HOME + File.separator + ".gwuser.xml")).exists()) {
            object = new File(file3, "gwuser.xml");
            if (!((File)object).exists()) {
                bl = file.renameTo((File)object);
                logger.debug((Object)("Renamed old .gwuser.xml file to new area: " + bl));
            } else {
                bl = file.delete();
                logger.debug((Object)("Deleted old .gwuser.xml file: " + bl));
            }
        }
        if (((File)(object = new File(Utils.USER_HOME + File.separator + ".spell" + File.separator))).exists()) {
            File file4 = new File(file3, "spell" + File.separator);
            if (!file4.exists()) {
                bl = ((File)object).renameTo(file4);
                logger.debug((Object)("Renamed old .spell dir to new area: " + bl));
            } else {
                File[] fileArray = ((File)object).listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file5 = fileArray[i];
                    File file6 = new File(file4, file5.getName());
                    if (file6.exists()) continue;
                    bl = file5.renameTo(file6);
                    logger.debug((Object)("Moved file (" + file5.getName() + ") from old spell dir to new spell dir: " + bl));
                }
                Utils.clearDir((File)object);
                bl = ((File)object).delete();
                logger.debug((Object)("Deleted old .spell dir: " + bl));
            }
        }
    }

    private void checkWebRendererVerion() {
        String string = OptionManager.getInstance().getGeneralOptions().getWebRendererVersion();
        String string2 = GWBrowserFactory.getWebrendererVersion();
        if (string2 == null) {
            logger.warn((Object)"Incorrect WebRenderer version received: [null]");
        } else if (!string2.equals(string)) {
            GWMozillaBrowser.SHOW_WEBRENDERER_ABOUT_DIALOG = true;
        }
    }

    private void beforeCreating() {
        GwAWTErrorHandler.init();
        OS.init();
        if (OS.isMacOS()) {
            OSXAdapter.registerMacOSXApplication(this);
            OSXAdapter.enablePrefs(true);
        }
        GWToolTipUI.initialize();
        waitQueue = new WaitCursorEventQueue();
        new GarbageCollector();
        application = this;
        logger.debug((Object)("awt.toolkit=" + Toolkit.getDefaultToolkit()));
    }

    private void afterCreating(String[] stringArray) {
        File file = CommandLineUtils.getOpenEmlFile(stringArray);
        if (file != null) {
            this.actionOpenEml(file);
        }
    }

    public static boolean USE_EXTERNAL_HTML_VIEWER() {
        return USE_EXTERNAL_HTML_VIEWER;
    }

    public static GWClientActionList getGwClientActionList() {
        if (gwClientActionList == null) {
            gwClientActionList = new GWClientActionList();
        }
        return gwClientActionList;
    }

    public static Application getApplication() {
        return application;
    }

    public static void logout() {
        logger.debug((Object)"logout entered");
        try {
            EngineCommandManager.logoutUser();
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
            logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
        }
        logger.debug((Object)"logout exited");
    }

    private void login(LoginParameters loginParameters, GWSplash gWSplash) {
        try {
            GWUserInfo gWUserInfo = EngineCommandManager.loginUser(loginParameters);
            if (gWUserInfo == null) {
                gWSplash.stopConnecting();
                GWClient.EXIT();
            }
            PathManager.getInstance().deleteUserTempDir();
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException, (Throwable)gWCommandException);
            GWClient.EXIT();
        }
    }

    protected void initListeners() {
        Level level = LevelManager.getInstance().getGlobalLevel();
        AppEventListener appEventListener = new SYNC_STARTED_listener();
        AppEventListenerDescriptor appEventListenerDescriptor = new AppEventListenerDescriptor(level, 830, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new SYNC_FINISHED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 840, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new SYNC_UPDATE_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 1220, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new SYNC_CANCELED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 910, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new NEW_WINDOW_CREATED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 480, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
        appEventListener = new WINDOW_CLOSED_listener();
        appEventListenerDescriptor = new AppEventListenerDescriptor(level, 490, appEventListener);
        this.addListenerDescriptor(appEventListenerDescriptor);
    }

    public static void relogin() {
        application.processCommand(new GlobalCommand(930));
        if (GWClient.closeAllFrames()) {
            GWClient.freeResources();
            GWSplash gWSplash = GWSplash.getInstance();
            gWSplash.pack();
            UIUtils.centerWindowOnScreen(gWSplash);
            gWSplash.setVisible(true);
            gWSplash.startConnecting();
            try {
                EngineCommandManager.relogin();
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException, (Throwable)engineException);
                gWSplash.stopConnecting();
                GWClient.EXIT();
            }
            OptionManager.getInstance().clearOptions();
            gWSplash.stopConnecting();
            GWMainAppFrame gWMainAppFrame = new GWMainAppFrame();
            GlobalCommand globalCommand = new GlobalCommand(480, gWMainAppFrame);
            gWMainAppFrame.getController().processCommand(globalCommand);
            gWSplash.setVisible(false);
            gWSplash.dispose();
            gWMainAppFrame.showMe();
        }
    }

    public static void freeResources() {
        AccountOptionsFrame.freeInstance();
        OptionManager.getInstance().clearOptions();
        OptionManager.freeInstance();
        PathManager.freeInstance();
        SelectionManagersFactory.getInstance().clearAll();
        DragManager.getInstance().setItem(null);
        FiltersFactory.getInstance().clearAll();
        ItemsCache.clear();
        FoldersCache.clear();
        ItemListsCache.clear();
    }

    private static void notifyNewWindow(ApplicationFrame applicationFrame) {
        for (int i = 0; i < appFrames.size(); ++i) {
            ApplicationFrame applicationFrame2 = (ApplicationFrame)appFrames.getIDObjectAt(i);
            if (applicationFrame == applicationFrame2) continue;
            ActionShowWindow actionShowWindow = new ActionShowWindow(applicationFrame2);
            GWClient.addWindowMenuItem(applicationFrame, actionShowWindow);
            actionShowWindow = new ActionShowWindow(applicationFrame);
            GWClient.addWindowMenuItem(applicationFrame2, actionShowWindow);
        }
    }

    private static void notifyCloseWindow(ApplicationFrame applicationFrame) {
        for (int i = 0; i < appFrames.size(); ++i) {
            GWMenu gWMenu;
            if (appFrames.getIDObjectAt(i) == applicationFrame || (gWMenu = GWClient.getWindowMenu((ApplicationFrame)appFrames.getIDObjectAt(i))) == null) continue;
            for (int j = 3; j < gWMenu.getItemCount(); ++j) {
                Action action = gWMenu.getItem(j).getAction();
                if (action == null || !(action instanceof ActionShowWindow) || ((ActionShowWindow)action).getShowFrame() != applicationFrame) continue;
                gWMenu.remove(j);
                break;
            }
            if (gWMenu.getMenuComponentCount() != 3) continue;
            gWMenu.remove(2);
        }
    }

    private static void addWindowMenuItem(ApplicationFrame applicationFrame, AbstractAction abstractAction) {
        GWMenu gWMenu = GWClient.getWindowMenu(applicationFrame);
        if (gWMenu != null) {
            if (gWMenu.getMenuComponentCount() == 2) {
                gWMenu.addSeparator();
            }
            JMenuItem jMenuItem = OS.createMenuItemForAction(abstractAction);
            jMenuItem.setComponentOrientation(UIUtils.getComponentOrientation());
            gWMenu.add(jMenuItem);
        }
    }

    private static GWMenu getWindowMenu(ApplicationFrame applicationFrame) {
        GWMenuBar gWMenuBar;
        if (applicationFrame != null && (gWMenuBar = applicationFrame.getGWMenuBar()) != null) {
            for (int i = 0; i < gWMenuBar.getMenuCount(); ++i) {
                if (!"Menu Window".equals(gWMenuBar.getMenu(i).getName())) continue;
                return (GWMenu)gWMenuBar.getMenu(i);
            }
        }
        return null;
    }

    public static FrameOpen getOpenFrame(AbstractItem abstractItem) {
        for (int i = 0; i < Application.appFrames.size(); ++i) {
            if (!(Application.appFrames.getIDObjectAt(i) instanceof FrameOpen) || !((FrameOpen)Application.appFrames.getIDObjectAt(i)).getGwItem().equals(abstractItem)) continue;
            return (FrameOpen)Application.appFrames.getIDObjectAt(i);
        }
        return null;
    }

    public static FrameCompose getComposeFrame(AbstractItem abstractItem) {
        for (int i = 0; i < Application.appFrames.size(); ++i) {
            if (!(Application.appFrames.getIDObjectAt(i) instanceof FrameCompose) || !((FrameCompose)Application.appFrames.getIDObjectAt(i)).getGwItem().equals(abstractItem)) continue;
            return (FrameCompose)Application.appFrames.getIDObjectAt(i);
        }
        return null;
    }

    public static String getNovellWebSiteLanguageName() {
        String string = "";
        Locale locale = EngineCommandManager.getLocale();
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        if ("en".equals(string2)) {
            string = "";
        } else if ("zh".equals(string2) && "CN".equals(string3)) {
            string = "zh-cn";
        } else if ("zh".equals(string2) && "TW".equals(string3)) {
            string = "zh-tw";
        } else if ("da".equals(string2)) {
            string = "da-da";
        } else if ("fi".equals(string2)) {
            string = "fi-fi";
        } else if ("fr".equals(string2)) {
            string = "fr-fr";
        } else if ("de".equals(string2)) {
            string = "de-de";
        } else if ("it".equals(string2)) {
            string = "it-it";
        } else if ("ja".equals(string2)) {
            string = "ja-jp";
        } else if ("ko".equals(string2)) {
            string = "ko-ko";
        } else if ("no".equals(string2)) {
            string = "no-no";
        } else if ("pl".equals(string2)) {
            string = "pl-pl";
        } else if ("pt".equals(string2)) {
            string = "pt-br";
        } else if ("ru".equals(string2)) {
            string = "ru-ru";
        } else if ("es".equals(string2)) {
            string = "es-es";
        } else if ("sv".equals(string2)) {
            string = "sv-se";
        } else if ("ar".equals(string2)) {
            string = "ar-ar";
        } else if ("he".equals(string2) || "iw".equals(string2)) {
            string = "he-he";
        } else if ("cs".equals(string2)) {
            string = "cs-cz";
        } else if ("nl".equals(string2)) {
            string = "nl-nl";
        } else if ("hu".equals(string2)) {
            string = "hu-hu";
        }
        return string;
    }

    private static String getBooleanOption(String[] stringArray, int n, ID iD) {
        int n2 = iD.getI();
        int n3 = n2 + 1;
        String string = null;
        if (n3 < n) {
            string = stringArray[n3];
            if (GWClient.isBooleanOption(string)) {
                n2 = n3;
                iD.setI(n2);
            } else {
                string = null;
            }
        }
        return string;
    }

    private static String getBooleanOption(String string) {
        if (GWClient.isBooleanOption(string)) {
            return string;
        }
        return null;
    }

    private static boolean isBooleanOption(String string) {
        return string != null && string.equalsIgnoreCase("on") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("no") || string.equals("1") || string.equals("0");
    }

    private static CommandLineOptions processCommandLineArgs(String[] stringArray) {
        int n;
        CommandLineOptions commandLineOptions = CommandLineOptions.getOptions();
        int n2 = n = stringArray == null ? -1 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n3;
            logger.debug((Object)("param [" + i + "] = " + stringArray[i]));
            String string = stringArray[i];
            String string2 = string.toLowerCase();
            if (string.startsWith("-aa=")) {
                n3 = string.indexOf("=");
                commandLineOptions.setAAFontsEnabled(GWClient.getBooleanOption(string.substring(n3 + 1)));
                continue;
            }
            if (string.equals("-r") || string.equals("--rmi")) {
                ID iD = new ID(i);
                commandLineOptions.setRmiEnabled(GWClient.getBooleanOption(stringArray, n, iD));
                i = iD.getI();
                continue;
            }
            if (string.startsWith("-r=") || string.startsWith("--rmi=")) {
                n3 = string.indexOf("=");
                commandLineOptions.setRmiEnabled(GWClient.getBooleanOption(string.substring(n3 + 1)));
                continue;
            }
            if (string.startsWith("-wr=")) {
                n3 = string.indexOf("=");
                commandLineOptions.setWREnabled(GWClient.getBooleanOption(string.substring(n3 + 1)));
                continue;
            }
            if (string.equals("-h") || string.equals("--help")) {
                commandLineOptions.setHelp(true);
                continue;
            }
            if (!string2.startsWith("--mailto:") && !string2.startsWith("-mailto:") && !string2.startsWith("mailto:")) continue;
            commandLineOptions.setMailTo(string.substring(string2.indexOf("mailto:")));
        }
        return commandLineOptions;
    }

    public static void main(String[] stringArray) {
        CommandLineOptions commandLineOptions = GWClient.processCommandLineArgs(stringArray);
        if (commandLineOptions.isHelp()) {
            System.out.print(commandLineOptions.toString());
            System.exit(0);
        }
        System.setProperty("swing.aatext", Boolean.toString(commandLineOptions.isAAFontsEnabled()));
        USE_EXTERNAL_HTML_VIEWER = commandLineOptions.isWREnabled();
        if (GWClient.isRmiEnabled()) {
            if (GWClient.instanceExists()) {
                logger.debug((Object)"Starting 'New Mail' Window");
                return;
            }
            boolean bl = false;
            try {
                GWClient.initializeRMIServer();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            SSLSetup.overrideTrustManager();
            new GWClient(stringArray);
        } else {
            SSLSetup.overrideTrustManager();
            new GWClient(stringArray);
        }
        if (!commandLineOptions.getMailTo().equals("")) {
            MailToOptions mailToOptions = MailToOptions.createMailToOptions(commandLineOptions.getMailTo());
            GWClient.composeMail(mailToOptions);
        }
    }

    private static void initializeRMIServer() {
        if (!GWClient.isRmiEnabled()) {
            return;
        }
        rmiServer = new GWClientRMIServer();
        logger.debug((Object)"Try to initialise RMI Server");
        try {
            rmiServer.initialise();
        }
        catch (RMIException rMIException) {
            logger.debug((Object)("Unable to create RMI Server " + rMIException.getMessage()));
        }
        logger.debug((Object)"RMI Server is Initialized");
    }

    private static boolean isRmiEnabled() {
        return CommandLineOptions.getOptions().isRmiEnabled();
    }

    private static boolean instanceExists() {
        GWClientRMIClient gWClientRMIClient = new GWClientRMIClient();
        try {
            gWClientRMIClient.initialise();
            logger.debug((Object)"One instance of GWClient is already started in system...");
            CommandLineOptions commandLineOptions = CommandLineOptions.getOptions();
            if (!commandLineOptions.getMailTo().equals("")) {
                MailToOptions mailToOptions = MailToOptions.createMailToOptions(commandLineOptions.getMailTo());
                gWClientRMIClient.showComposeNewMailForm(mailToOptions);
            }
        }
        catch (RMIException rMIException) {
            logger.debug((Object)("GWClient is not started in this system." + rMIException.getMessage()));
            return false;
        }
        return true;
    }

    public static void doExit() {
        logger.debug((Object)"doExit entered");
        new Closer().start();
        logger.debug((Object)"doExit exited");
    }

    public void actionOpenEml(File file) {
        AppAction appAction = GWClient.getGwClientActionList().getAction("open eml item");
        appAction.setMVCModel(file);
        GWClient.getGwClientActionList().performAction("open eml item");
    }

    public void actionPreferences() {
        GWClient.getGwClientActionList().performAction("Options");
    }

    public void actionOpenFile() {
        logger.debug((Object)"actionOpenFile");
    }

    public void actionExit() {
        GWClient.getGwClientActionList().performAction("Exit");
    }

    public static void composeMail(MailToOptions mailToOptions) {
        logger.info((Object)"Performing compose mail action for mailto: ...");
        ActionNewMail actionNewMail = new ActionNewMail(Application.getGWMainAppFrame().getAppActionList());
        List list = ControlsUtils.convertToRecipientsList(mailToOptions.getToListAsString(), 1);
        List list2 = ControlsUtils.convertToRecipientsList(mailToOptions.getCcListAsString(), 2);
        List list3 = ControlsUtils.convertToRecipientsList(mailToOptions.getBccListAsString(), 4);
        actionNewMail.setToRecipients(list);
        actionNewMail.setCCRecipients(list2);
        actionNewMail.setBCRecipients(list3);
        actionNewMail.setSubject(mailToOptions.getSubject());
        actionNewMail.setMessage(mailToOptions.getBody());
        actionNewMail.setAttachments(mailToOptions.getAttachments());
        actionNewMail.actionPerformed(null);
    }

    public static void composeMail(String string, String[] stringArray) {
        logger.info((Object)"Performing compose mail action...");
        ActionNewMail actionNewMail = new ActionNewMail(Application.getGWMainAppFrame().getAppActionList());
        List list = ControlsUtils.convertToRecipientsList(string, 1);
        actionNewMail.setToRecipients(list);
        actionNewMail.actionPerformed(null);
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            File file = new File(string2);
            if (!file.isFile()) continue;
            arrayList.add(file);
        }
    }

    public static void EXIT() {
        logger.debug((Object)"EXIT entered");
        waitQueue.shutdown();
        PathManager.getInstance().deleteUserTempDir();
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalizersOnExit((boolean)true);
        logger.debug((Object)"EXIT exiting...");
        logger.debug((Object)"JVM exiting...");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        performingExit = false;
        inSync = false;
        rmiServer = null;
    }

    private class WINDOW_CLOSED_listener
    extends AppEventListener {
        private WINDOW_CLOSED_listener() {
        }

        public void handle(AppEvent appEvent) {
            ApplicationFrame applicationFrame = (ApplicationFrame)appEvent.getData();
            GWClient.notifyCloseWindow(applicationFrame);
            GWCommandManager.removeFrameRef(applicationFrame.getUserGuid());
        }
    }

    private class NEW_WINDOW_CREATED_listener
    extends AppEventListener {
        private NEW_WINDOW_CREATED_listener() {
        }

        public void handle(AppEvent appEvent) {
            ApplicationFrame applicationFrame = (ApplicationFrame)appEvent.getData();
            GWClient.notifyNewWindow(applicationFrame);
            GWCommandManager.addFrameRef(applicationFrame.getUserGuid());
        }
    }

    private class SYNC_CANCELED_listener
    extends AppEventListener {
        private SYNC_CANCELED_listener() {
        }

        public synchronized void handle(AppEvent appEvent) {
            for (int i = 0; i < appFrames.size(); ++i) {
                ApplicationFrame applicationFrame = (ApplicationFrame)appFrames.getIDObjectAt(i);
                if (!(applicationFrame instanceof GWMainAppFrame)) continue;
                GWMainAppFrame gWMainAppFrame = (GWMainAppFrame)applicationFrame;
                gWMainAppFrame.stopStatusAnimation();
                gWMainAppFrame.setStatusText("");
                if (EngineCommandManager.getCurrentMode() != 6) continue;
                gWMainAppFrame.setStatusText(Account.getLastConnectedMsg());
            }
        }
    }

    private class SYNC_FINISHED_listener
    extends AppEventListener {
        private SYNC_FINISHED_listener() {
        }

        public synchronized void handle(AppEvent appEvent) {
            Boolean bl = (Boolean)appEvent.getData();
            boolean bl2 = bl;
            for (int i = 0; i < appFrames.size(); ++i) {
                ApplicationFrame applicationFrame = (ApplicationFrame)appFrames.getIDObjectAt(i);
                if (!(applicationFrame instanceof GWMainAppFrame)) continue;
                GWMainAppFrame gWMainAppFrame = (GWMainAppFrame)applicationFrame;
                if (EngineCommandManager.getCurrentMode() == 6) {
                    gWMainAppFrame.stopStatusAnimation();
                    gWMainAppFrame.setStatusText(Account.getLastConnectedMsg());
                    continue;
                }
                if (bl2) {
                    gWMainAppFrame.stopStatusAnimation();
                    gWMainAppFrame.setStatusText("");
                    continue;
                }
                gWMainAppFrame.setStatusText(StringResources.ERROR_DURING_UPDATING_MAILBOX);
            }
        }
    }

    private class SYNC_UPDATE_listener
    extends AppEventListener {
        private SYNC_UPDATE_listener() {
        }

        public synchronized void handle(AppEvent appEvent) {
            for (int i = 0; i < appFrames.size(); ++i) {
                ApplicationFrame applicationFrame = (ApplicationFrame)appFrames.getIDObjectAt(i);
                if (!(applicationFrame instanceof GWMainAppFrame)) continue;
                GWMainAppFrame gWMainAppFrame = (GWMainAppFrame)applicationFrame;
                gWMainAppFrame.setStatusText(appEvent.getData().toString());
            }
        }
    }

    private class SYNC_STARTED_listener
    extends AppEventListener {
        private SYNC_STARTED_listener() {
        }

        public synchronized void handle(AppEvent appEvent) {
            for (int i = 0; i < appFrames.size(); ++i) {
                ApplicationFrame applicationFrame = (ApplicationFrame)appFrames.getIDObjectAt(i);
                if (!(applicationFrame instanceof GWMainAppFrame)) continue;
                GWMainAppFrame gWMainAppFrame = (GWMainAppFrame)applicationFrame;
                gWMainAppFrame.startStatusAnimation(ImageResources.ICON_UPDATING_CACHING, StringResources.ICON_UPDATING_CACHING, new ClickAction(this){
                    private final /* synthetic */ SYNC_STARTED_listener this$1;
                    {
                        this.this$1 = sYNC_STARTED_listener;
                    }

                    public void click() {
                        EngineCommandManager.getCallBackListener().getSyncFrame().switchView();
                    }
                });
            }
        }
    }

    class GarbageCollector
    extends Thread {
        public GarbageCollector() {
            super("Garbage Collector");
            this.start();
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(30000L);
                    System.runFinalization();
                    System.gc();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                logger.error((Object)interruptedException, (Throwable)interruptedException);
                return;
            }
        }
    }

    private static class Closer
    extends Thread {
        private Closer() {
        }

        public void run() {
            logger.debug((Object)"CLOSER ENTERED");
            GWClient.setperformingExit(true);
            ApplicationOptions.getInstance().saveChanges();
            EngineCommandManager.cancelSync();
            GWClient.getApplication().processCommand(new GlobalCommand(910));
            while (GWClient.isInSync()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (EngineCommandManager.canExit()) {
                application.processCommand(new GlobalCommand(930));
                if (Application.closeAllFrames()) {
                    if (GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).isCachingDataStore()) {
                        GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).performBackupOnDB(false, true);
                    }
                    GWClient.freeResources();
                    GWClient.logout();
                    logger.debug((Object)"CLOSER EXITED JVM WILL CLOSE");
                    if (USE_EXTERNAL_HTML_VIEWER) {
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            public void run() {
                                logger.debug((Object)"Executing shutdown hook...");
                                GWBrowserFactory.destroySpawnedBrowsers();
                                logger.debug((Object)"Shutdown hook finished");
                            }
                        });
                    }
                    GWClient.EXIT();
                }
            }
            GWClient.setperformingExit(false);
        }
    }

    private static class ID {
        private int i;

        public ID(int n) {
            this.setI(n);
        }

        public int getI() {
            return this.i;
        }

        public void setI(int n) {
            this.i = n;
        }
    }
}

