/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemListListener;
import com.novell.gw.jclient.application.CalendarFolderChangeListener;
import com.novell.gw.jclient.application.ContactsTable;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.controls.Borders;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.FocusTraversalPolicyDecorator;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.header.HeaderPanel;
import com.novell.gw.jclient.application.controls.header.HeaderPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.QuickViewer;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FilterGWItemsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.GWApplicationFrameMenuBar;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.controls.standardgwitemtable.ItemListTable;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.ComponentWithMenu;
import com.novell.gw.jclient.application.controls.storageswitcher.StorageSwitcher;
import com.novell.gw.jclient.application.controls.toolbars.CheckListToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ContactsFolderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.controls.toolbars.ItemOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.NavigationBar;
import com.novell.gw.jclient.application.controls.toolbars.QueryFolderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.SentItemOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.TrashFolderToolBar;
import com.novell.gw.jclient.application.frames.addressbook.FilterOffAction;
import com.novell.gw.jclient.application.frames.addressbook.GroupFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.OrganizationFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.ResourceFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.UserFilterAction;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.CheckListFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class GWMainAppFrame
extends ApplicationFrame {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$GWMainAppFrame == null ? (class$com$novell$gw$jclient$application$GWMainAppFrame = GWMainAppFrame.class$("com.novell.gw.jclient.application.GWMainAppFrame")) : class$com$novell$gw$jclient$application$GWMainAppFrame));
    private static final String CALENDAR_VIEW = "CALENDAR_VIEW";
    private static final String ITEMS_TABLE_VIEW = "ITEMS_TABLE_VIEW";
    private static final String CONTACTS_VIEW = "CONTACTS_VIEW";
    public static final int MAIN_WINDOW_DEFAULT_WIDTH = 820;
    public static final int VIEW_TABLE_STATE = 0;
    public static final int VIEW_CALENDAR_STATE = 1;
    public static final int VIEW_CONTACTS_STATE = 2;
    private int viewState = 0;
    private JPanel toolBarPanel;
    private JPanel tablePanelHolder;
    private boolean fullSizedQV = true;
    private static String basicTitle;
    private JToolBar toolbarMain;
    private JToolBar toolbarItemOperations;
    private JToolBar toolbarSentItemOperations;
    private JToolBar toolbarBottom;
    private JToolBar toolbarTrash;
    private JSplitPane treeSplitPane;
    private JSplitPane tableSplitPaneBig;
    private JSplitPane tableSplitPaneSmall;
    private JSplitPane quickViewerHolder;
    private JPanel mainPanel;
    private JPanel tablePanel;
    private JPanel treePanel;
    private JPanel quickViewerPanel;
    private MainGWFoldersTree tree;
    private ItemListTable table;
    private QuickViewer quickViewer;
    private GWCalendar gwCalendar;
    private CalendarFolderChangeListener calendarFolderChangedListener;
    private boolean calendarFolderViewEnabled = false;
    private boolean showQuickViewer = false;
    private JPanel tableHeaderPanel;
    private JPanel treeHeaderPanel;
    private JLabel lbFilter = new OrientableLabel(ImageResources.ICON_UNACTIVE_FILTER);
    private JLabel folderLabel;
    private AbstractFolder folder;
    private AbstractAddressBookTable tableContacts;
    private ComponentWithMenu filterComp;
    private FilterGWItemsPopupMenu popupFilterGWItems;
    private FilterPopupMenu popupFilterContacts;
    private HeaderPopupMenu headerPopupMenu;
    private NavigationBar navigationBar = new NavigationBar();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$GWMainAppFrame;

    public GWMainAppFrame() {
        this(EngineCommandManager.getUserGuid());
    }

    public GWMainAppFrame(String string) {
        super(StringResources.NOVELL_GROUPWISE, "MAIN_FRAME", string);
        basicTitle = StringResources.NOVELL_GROUPWISE;
        if (EngineCommandManager.getCurrentMode() == 6) {
            basicTitle = basicTitle + " " + StringResources.CACHING;
        }
        this.setTitle(basicTitle);
        this.setAppActionList(new GWMainAppFrameActionList(this, (MVCController)GWClient.getApplication()));
        this.tableContacts = new ContactsTable(this.getAppActionList());
        this.createContactFilterActions();
        this.buildUI();
        this.getAppActionList().setEnabled(true);
        this.calendarFolderChangedListener = new CalendarFolderChangeListener(string, this.gwCalendar);
    }

    public void setUserGuid(String string) {
        super.setUserGuid(string);
        this.calendarFolderChangedListener.setUserGuid(string);
    }

    protected Dimension getFrameSize() {
        int n = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_HEIGHT", 590);
        int n2 = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_WIDTH", 820);
        return new Dimension(n2, n);
    }

    private void createContactFilterActions() {
        this.getAppActionList().addAction(new FilterOffAction((ActionList)this.getAppActionList(), this.tableContacts));
        this.getAppActionList().addAction(new GroupFilterAction((ActionList)this.getAppActionList(), this.tableContacts));
        this.getAppActionList().addAction(new OrganizationFilterAction((ActionList)this.getAppActionList(), this.tableContacts));
        this.getAppActionList().addAction(new ResourceFilterAction((ActionList)this.getAppActionList(), this.tableContacts));
        this.getAppActionList().addAction(new UserFilterAction((ActionList)this.getAppActionList(), this.tableContacts));
    }

    private void buildUI() {
        this.toolBarPanel = new OrientablePanel(new GridLayout(0, 1, 0, 0));
        this.toolBarPanel.setBorder(BorderFactory.createEmptyBorder());
        this.popupFilterGWItems = new FilterGWItemsPopupMenu(this.appActionList);
        this.filterComp = new ComponentWithMenu(this.lbFilter, this.popupFilterGWItems);
        this.popupFilterContacts = new FilterPopupMenu();
        this.headerPopupMenu = new HeaderPopupMenu(this.appActionList);
        this.initToolbars();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.quickViewerPanel = new JPanel();
        this.quickViewerPanel.setLayout(new BorderLayout());
        this.quickViewerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.tablePanel = new JPanel(new CardLayout());
        this.tablePanel.setMinimumSize(new Dimension(0, 0));
        this.tablePanel.setBorder(BorderFactory.createEmptyBorder());
        this.buildTableHeader();
        this.tablePanelHolder = new JPanel(new BorderLayout());
        this.tablePanelHolder.setBorder(BorderFactory.createEmptyBorder());
        this.tablePanelHolder.add((Component)this.tableHeaderPanel, "North");
        this.tablePanelHolder.add((Component)this.tablePanel, "Center");
        this.table = new ItemListTable(this.getController());
        this.table.setBorder(BorderFactory.createEmptyBorder());
        ColoredScrollPane coloredScrollPane = new ColoredScrollPane(this.table);
        coloredScrollPane.setBorder(Borders.getEmptyTextComponentBorder(false));
        this.tablePanel.add((Component)coloredScrollPane, ITEMS_TABLE_VIEW);
        ColoredScrollPane coloredScrollPane2 = new ColoredScrollPane(this.tableContacts);
        coloredScrollPane2.setBorder(Borders.getEmptyTextComponentBorder(false));
        this.tablePanel.add((Component)coloredScrollPane2, CONTACTS_VIEW);
        this.gwCalendar = new GWCalendar(GWCalendarUtils.getToday(), false, this.getController());
        this.gwCalendar.setBorder(BorderFactory.createEmptyBorder());
        this.tablePanel.add((Component)this.gwCalendar, CALENDAR_VIEW);
        this.quickViewer = new QuickViewer(this.getController());
        this.setFocusTraversalPolicy(new FocusTraversalPolicyDecorator(this.quickViewer.getFocusPolicy()){

            public Component getDefaultComponent(Container container) {
                return GWMainAppFrame.this.table;
            }

            public Component getInitialComponent(Window window) {
                return GWMainAppFrame.this.table;
            }
        });
        this.quickViewer.setBorder(BorderFactory.createEmptyBorder());
        this.quickViewerPanel.add((Component)this.quickViewer, "Center");
        this.tableSplitPaneBig = new GWSplitPane(0);
        this.tableSplitPaneBig.setOneTouchExpandable(false);
        this.tableSplitPaneBig.setBorder(BorderFactory.createEmptyBorder());
        this.tableSplitPaneBig.addPropertyChangeListener(new DividerPositionListener("QUICKVIEWER_SPLITPOS", this.tableSplitPaneBig));
        this.tableSplitPaneSmall = new GWSplitPane(0);
        this.tableSplitPaneSmall.setOneTouchExpandable(false);
        this.tableSplitPaneSmall.setBorder(BorderFactory.createEmptyBorder());
        this.tableSplitPaneSmall.addPropertyChangeListener(new DividerPositionListener("QUICKVIEWER_SPLITPOS", this.tableSplitPaneSmall));
        this.buildTreeHeader();
        this.showQuickViewer = !ApplicationOptions.getInstance().getBoolean("QUICKVIEWER_VISIBLE", false);
        this.fullSizedQV = ApplicationOptions.getInstance().getInteger("FOLDERLIST_VIEWTYPE", 0) == 0;
        this.tree = new MainGWFoldersTree(this.getController(), this.getUserGuid());
        this.tree.setBorder(BorderFactory.createEmptyBorder());
        this.treePanel = new JPanel();
        this.treePanel.setLayout(new BorderLayout());
        this.treePanel.setBorder(BorderFactory.createEmptyBorder());
        this.treePanel.add((Component)this.treeHeaderPanel, "North");
        this.treePanel.addMouseListener(AbstractActionsPopupMenu.createMenuMouseListener(this.headerPopupMenu));
        ColoredScrollPane coloredScrollPane3 = new ColoredScrollPane(this.tree);
        coloredScrollPane3.setBorder(Borders.getEmptyTextComponentBorder(false));
        this.treePanel.add((Component)coloredScrollPane3, "Center");
        this.buildTreeSplitPane();
        this.mainPanel.add((Component)this.treeSplitPane, "Center");
        this.setGWMenuBar(this.getMainMenu());
        this.updateQuickViewerSize();
        this.switchQuickViewerVisibility();
    }

    private void buildTreeSplitPane() {
        this.treeSplitPane = new GWSplitPane(1);
        this.treeSplitPane.setOneTouchExpandable(true);
        this.treeSplitPane.setBorder(BorderFactory.createEmptyBorder());
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.treeSplitPane.setLeftComponent(this.treePanel);
        } else {
            this.treeSplitPane.setRightComponent(this.treePanel);
        }
        int n = ApplicationOptions.getInstance().getInteger("FOLDERLIST_SPLITPOS", 150);
        this.treeSplitPane.setDividerLocation(n);
        this.treeSplitPane.setDividerLocation(0.2);
        this.treeSplitPane.addPropertyChangeListener(new DividerPositionListener("FOLDERLIST_SPLITPOS", this.treeSplitPane));
    }

    private void buildTableHeader() {
        this.tableHeaderPanel = new HeaderPanel(new OrientablePanel(new GridBagLayout()), this.getAppActionList());
        this.tableHeaderPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.folderLabel = new OrientableLabel();
        this.tableHeaderPanel.add(Box.createHorizontalStrut(10), gridBagConstraints);
        this.tableHeaderPanel.add((Component)this.folderLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.tableHeaderPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.tableHeaderPanel.add((Component)new OrientableLabel(StringResources.SHOW_C), gridBagConstraints);
        this.tableHeaderPanel.add((Component)this.filterComp, gridBagConstraints);
        this.tableHeaderPanel.add(Box.createHorizontalStrut(10), gridBagConstraints);
        this.tableHeaderPanel.addMouseListener(AbstractActionsPopupMenu.createMenuMouseListener(this.headerPopupMenu));
    }

    private void buildTreeHeader() {
        this.treeHeaderPanel = new HeaderPanel(new OrientablePanel(new BorderLayout()), this.getAppActionList());
        this.treeHeaderPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        StorageSwitcher storageSwitcher = new StorageSwitcher(this.getAppActionList());
        JComponent jComponent = ((HeaderPanel)this.treeHeaderPanel).getInnerComponent();
        jComponent.setLayout(new BoxLayout(jComponent, 0));
        this.treeHeaderPanel.add(Box.createHorizontalStrut(10));
        this.treeHeaderPanel.add(storageSwitcher);
    }

    public void updateTitle() {
        String string = "";
        if (GWCommandManager.getInstance(this.getUserGuid()).isProxyDataStore()) {
            string = GWCommandManager.getInstance(this.getUserGuid()).getProxyUserName() + " - ";
        } else if (GWCommandManager.getInstance(this.getUserGuid()).isArchive()) {
            string = "(" + StringResources.ARCHIVE + ")" + " - ";
        } else if (GWCommandManager.getInstance(this.getUserGuid()).isBackupDB()) {
            string = "(" + StringResources.BACKUP + ")" + " - ";
        }
        string = string + basicTitle;
        if (this.folder != null) {
            string = string + "  -  " + this.folder.getName();
        }
        this.setTitle(string);
    }

    public void changeLook(int n) {
        if (n == 0) {
            this.toolBarPanel.add((Component)this.navigationBar, 0);
            this.toolbarMain.setBackground(NavigationBar.COLOR_BACKGROUND);
        } else {
            this.toolBarPanel.remove(this.navigationBar);
            this.toolbarMain.setBackground(this.getBackground());
        }
        this.toolBarPanel.updateUI();
        this.toolbarMain.invalidate();
    }

    public void setFolder(AbstractFolder abstractFolder) {
        if (this.calendarFolderViewEnabled) {
            this.folder.getItemList().removeItemListListener((ItemListListener)this.calendarFolderChangedListener);
        }
        if (this.folder != abstractFolder) {
            this.folder = abstractFolder;
            this.changeFolderLabel();
            this.updateTitle();
            this.rebuildToolBars();
        }
        this.calendarFolderViewEnabled = this.folder.isCalendarViewEnabled();
        this.gwCalendar.activate(this.calendarFolderViewEnabled);
        if (this.calendarFolderViewEnabled) {
            this.folder.getItemList().addItemListListener((ItemListListener)this.calendarFolderChangedListener);
            this.gwCalendar.setFolder(this.folder);
            this.viewCalendar();
        } else if (this.folder instanceof ContactsFolder) {
            this.viewContactsTable();
        } else {
            this.viewTable();
        }
    }

    private void viewCalendar() {
        this.viewState = 1;
        this.panStatusPanel.clearCounts();
        ((CardLayout)this.tablePanel.getLayout()).show(this.tablePanel, CALENDAR_VIEW);
    }

    private void viewTable() {
        this.viewState = 0;
        ((CardLayout)this.tablePanel.getLayout()).show(this.tablePanel, ITEMS_TABLE_VIEW);
    }

    private void viewContactsTable() {
        this.viewState = 2;
        ((CardLayout)this.tablePanel.getLayout()).show(this.tablePanel, CONTACTS_VIEW);
    }

    public void setTotalItemsCount(int n) {
        this.panStatusPanel.setTotalItemsCount(n);
    }

    private void changeFolderLabel() {
        if (this.folder != null) {
            this.folderLabel.setText(this.folder.getName());
            this.folderLabel.setIcon(ControlsUtils.getImageForFolder(this.folder));
        }
    }

    public int getViewState() {
        return this.viewState;
    }

    public void initToolbars() {
        this.toolbarMain = new GWApplicationFrameToolBar(this.getAppActionList());
        this.toolbarMain.setOpaque(true);
        this.toolbarMain.setBorder(BorderFactory.createEmptyBorder());
        boolean bl = ApplicationOptions.getInstance().getBoolean("MAIN_TOOLBAR_VISIBLE", true);
        if (bl) {
            this.toolBarPanel.add(this.toolbarMain);
        }
        this.toolbarItemOperations = new ItemOperationsToolBar(this.getAppActionList());
        this.toolbarTrash = new TrashFolderToolBar(this.getAppActionList());
        this.toolbarSentItemOperations = new SentItemOperationsToolBar(this.getAppActionList());
        this.addItemToolbarToPanel();
        GWToolBarPanel gWToolBarPanel = new GWToolBarPanel();
        gWToolBarPanel.add((Component)this.toolBarPanel, "Center");
        this.setToolBarPanel(gWToolBarPanel, "North");
    }

    private void rebuildToolBars() {
        this.toolBarPanel.remove(this.toolbarItemOperations);
        this.toolBarPanel.remove(this.toolbarSentItemOperations);
        if (this.folder instanceof CalendarFolder) {
            this.quickViewer.setHiden(true);
            this.quickViewerHolder.remove(this.quickViewerPanel);
            if (ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true)) {
                this.toolBarPanel.add(this.toolbarItemOperations);
            }
        } else if (this.folder instanceof ContactsFolder) {
            this.quickViewer.setHiden(true);
            this.quickViewerHolder.remove(this.quickViewerPanel);
        } else if (this.showQuickViewer) {
            if (this.quickViewer.isHiden()) {
                this.quickViewer.setHiden(false);
                this.quickViewerHolder.add((Component)this.quickViewerPanel, "bottom");
                this.quickViewerHolder.updateUI();
                int n = ApplicationOptions.getInstance().getInteger("QUICKVIEWER_SPLITPOS", 200);
                this.quickViewerHolder.setDividerLocation(n);
            }
        } else {
            this.quickViewer.setHiden(true);
            this.quickViewerHolder.remove(this.quickViewerPanel);
            if (ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true)) {
                if (this.folder instanceof SentItemsFolder) {
                    this.toolBarPanel.add(this.toolbarSentItemOperations);
                } else {
                    this.toolBarPanel.add(this.toolbarItemOperations);
                }
            }
        }
        this.rebuildBottomToolBar();
        this.toolBarPanel.updateUI();
        if (this.folder instanceof ContactsFolder) {
            this.filterComp.setPopupMenu(this.popupFilterContacts);
        } else {
            this.filterComp.setPopupMenu(this.popupFilterGWItems);
        }
    }

    private void rebuildBottomToolBar() {
        if (this.toolbarBottom != null) {
            this.toolBarPanel.remove(this.toolbarBottom);
            this.toolbarBottom = null;
        }
        if (!ApplicationOptions.getInstance().getBoolean("FOLDER_CONTEXT_TOOLBAR_VISIBLE", true)) {
            return;
        }
        if (this.folder instanceof CheckListFolder) {
            this.toolbarBottom = new CheckListToolBar(this.getAppActionList());
            this.toolBarPanel.add(this.toolbarBottom);
        } else if (this.folder instanceof QueryFolder) {
            this.toolbarBottom = new QueryFolderToolBar(this.getAppActionList());
            this.toolBarPanel.add(this.toolbarBottom);
        } else if (this.folder instanceof ContactsFolder) {
            this.toolbarBottom = new ContactsFolderToolBar(this.getAppActionList());
            this.toolBarPanel.add(this.toolbarBottom);
        } else if (this.folder instanceof TrashFolder) {
            this.toolbarBottom = this.toolbarTrash;
            this.toolBarPanel.add(this.toolbarBottom);
        }
    }

    public void setFilterLabelIcon(ImageIcon imageIcon) {
        this.lbFilter.setIcon(imageIcon);
        this.lbFilter.invalidate();
    }

    private GWMenuBar getMainMenu() {
        if (this.getGWMenuBar() == null) {
            return new GWApplicationFrameMenuBar(this.getAppActionList());
        }
        return this.getGWMenuBar();
    }

    public void switchQuickViewerVisibility() {
        boolean bl = this.showQuickViewer = !this.showQuickViewer;
        if (!this.showQuickViewer) {
            this.getAppActionList().processCommand(new Command(1160, null));
        }
        this.rebuildToolBars();
        if (this.showQuickViewer) {
            Command command = new Command(350, this.showQuickViewer ? Boolean.TRUE : Boolean.FALSE);
            this.getController().processCommand(command);
            this.quickViewer.setShowToolbar(this.folder instanceof SentItemsFolder);
        }
        ApplicationOptions.getInstance().put("QUICKVIEWER_VISIBLE", this.showQuickViewer ? Boolean.TRUE : Boolean.FALSE);
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public void switchQuickViewerSize() {
        this.fullSizedQV = !this.fullSizedQV;
        this.updateQuickViewerSize();
    }

    private void updateQuickViewerSize() {
        JPanel jPanel = (JPanel)this.getContentPane();
        int n = ApplicationOptions.getInstance().getInteger("FOLDERLIST_SPLITPOS", 150);
        int n2 = ApplicationOptions.getInstance().getInteger("QUICKVIEWER_SPLITPOS", 200);
        int n3 = ApplicationOptions.getInstance().getInteger(this.optionFrameName + '.' + "WIN_WIDTH", 700);
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            n = n3 - n;
        }
        if (this.fullSizedQV) {
            this.mainPanel.add((Component)this.treeSplitPane, "Center");
            if (UIUtils.getComponentOrientation().isLeftToRight()) {
                this.treeSplitPane.setRightComponent(this.tablePanelHolder);
            } else {
                this.treeSplitPane.setLeftComponent(this.tablePanelHolder);
            }
            this.tableSplitPaneBig.setTopComponent(this.treeSplitPane);
            this.tableSplitPaneBig.setBottomComponent(this.quickViewerPanel);
            this.tableSplitPaneBig.setDividerLocation(n2);
            this.treeSplitPane.setDividerLocation(n);
            this.centeredContentPanel.add((Component)this.tableSplitPaneBig, "Center");
            this.quickViewerHolder = this.tableSplitPaneBig;
        } else {
            this.mainPanel.remove(this.treeSplitPane);
            this.centeredContentPanel.remove(this.tableSplitPaneBig);
            this.treeSplitPane.remove(this.tablePanelHolder);
            if (UIUtils.getComponentOrientation().isLeftToRight()) {
                this.treeSplitPane.setRightComponent(this.tableSplitPaneSmall);
            } else {
                this.treeSplitPane.setLeftComponent(this.tableSplitPaneSmall);
            }
            this.treeSplitPane.setDividerLocation(n);
            this.tableSplitPaneSmall.setLeftComponent(this.tablePanelHolder);
            this.tableSplitPaneSmall.setRightComponent(this.quickViewerPanel);
            this.tableSplitPaneSmall.setDividerLocation(n2);
            this.centeredContentPanel.add((Component)this.treeSplitPane, "Center");
            this.quickViewerHolder = this.tableSplitPaneSmall;
        }
        jPanel.updateUI();
        int n4 = this.fullSizedQV ? 0 : 1;
        ApplicationOptions.getInstance().put("FOLDERLIST_VIEWTYPE", new Integer(n4));
    }

    protected void afterShow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doAfterShow();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GWMainAppFrame.this.doAfterShow();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)interruptedException, (Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.error((Object)invocationTargetException, (Throwable)invocationTargetException);
            }
        }
        super.afterShow();
    }

    public void beforeDispose() {
        if (this.calendarFolderViewEnabled) {
            this.folder.getItemList().removeItemListListener((ItemListListener)this.calendarFolderChangedListener);
        }
        this.gwCalendar.activate(false);
        super.beforeDispose();
    }

    private void doAfterShow() {
        this.tree.selectMailBox();
        AbstractAddressBook abstractAddressBook = EngineCommandManager.getContactsFolderAddressBook();
        Command command = new Command(360, abstractAddressBook);
        this.appActionList.processCommand(command);
        command = new Command(1080);
        this.appActionList.processCommand(command);
    }

    public boolean isShowQuickViewer() {
        return this.showQuickViewer;
    }

    public void fireTableDataChanged() {
        ((AbstractTableModel)this.tableContacts.getModel()).fireTableDataChanged();
    }

    public void release() {
        super.release();
        this.toolBarPanel = null;
        this.tablePanelHolder = null;
        this.toolbarMain = null;
        this.toolbarItemOperations = null;
        this.toolbarSentItemOperations = null;
        this.toolbarBottom = null;
        this.toolbarTrash = null;
        this.treeSplitPane = null;
        this.tableSplitPaneBig = null;
        this.tableSplitPaneSmall = null;
        this.quickViewerHolder = null;
        this.mainPanel = null;
        this.tablePanel = null;
        this.treePanel = null;
        this.quickViewerPanel = null;
        this.tree = null;
        this.table = null;
        this.quickViewer = null;
        this.gwCalendar = null;
        this.tableHeaderPanel = null;
        this.treeHeaderPanel = null;
        this.lbFilter = null;
        this.folderLabel = null;
        this.folder = null;
        this.tableContacts = null;
        this.filterComp = null;
        this.popupFilterGWItems = null;
        this.popupFilterContacts = null;
        this.navigationBar = null;
    }

    public void showToolbar() {
        boolean bl = ApplicationOptions.getInstance().getBoolean("MAIN_TOOLBAR_VISIBLE", true);
        if (bl) {
            this.toolBarPanel.add(this.toolbarMain);
        } else {
            this.toolBarPanel.remove(this.toolbarMain);
        }
        this.addItemToolbarToPanel();
        this.rebuildBottomToolBar();
        this.toolBarPanel.updateUI();
    }

    private void addItemToolbarToPanel() {
        if (!ApplicationOptions.getInstance().getBoolean("QUICKVIEWER_VISIBLE", false) && ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true)) {
            if (this.folder instanceof SentItemsFolder) {
                this.toolBarPanel.add(this.toolbarSentItemOperations);
            } else {
                this.toolBarPanel.add(this.toolbarItemOperations);
            }
        } else if (this.folder instanceof SentItemsFolder) {
            this.toolBarPanel.remove(this.toolbarSentItemOperations);
        } else {
            this.toolBarPanel.remove(this.toolbarItemOperations);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FilterPopupMenu
    extends JPopupMenu {
        ButtonGroup buttonGroup = new ButtonGroup();
        private ItemListener itemListener = new FilterItemListener();
        private JMenuItem menuClear = new JMenuItem(GWMainAppFrame.this.getAppActionList().getAction("AB Filter Off"));
        private JPopupMenu.Separator separator = new JPopupMenu.Separator();

        public FilterPopupMenu() {
            this.menuClear.setText(StringResources.CLEAR_FILTER);
            this.menuClear.addActionListener(new ActionListener(this, GWMainAppFrame.this){
                private final /* synthetic */ GWMainAppFrame val$this$0;
                private final /* synthetic */ FilterPopupMenu this$1;
                {
                    this.this$1 = filterPopupMenu;
                    this.val$this$0 = gWMainAppFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    GWMainAppFrame.access$200(FilterPopupMenu.access$400(this.this$1)).setIcon(ImageResources.ICON_UNACTIVE_FILTER);
                    FilterPopupMenu.access$500(this.this$1);
                }
            });
            this.build();
        }

        private void build() {
            OrientableRadioButtonMenuItem orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(GWMainAppFrame.this.getAppActionList().getAction("AB Filter Group"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_FOR_GROUPS);
            this.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(GWMainAppFrame.this.getAppActionList().getAction("AB Filter User"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_FOR_CONTACTS);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(GWMainAppFrame.this.getAppActionList().getAction("AB Filter Resource"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_FOR_RESOURCES);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(GWMainAppFrame.this.getAppActionList().getAction("AB Filter Organization"));
            orientableRadioButtonMenuItem.setText(StringResources.FILTER_FOR_ORGANIZATIONS);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            this.add(orientableRadioButtonMenuItem);
            this.rebuild();
        }

        private void rebuild() {
            if (this.buttonGroup.getSelection() != null && this.buttonGroup.getSelection().isSelected()) {
                this.insert(this.menuClear, 0);
                this.insert(this.separator, 1);
            } else {
                this.remove(this.menuClear);
                this.remove(this.separator);
            }
        }

        private void clearSelection() {
            this.buttonGroup.setSelected(null, true);
            Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                abstractButton.getModel().setGroup(null);
                abstractButton.setSelected(false);
                abstractButton.getModel().setGroup(this.buttonGroup);
            }
        }

        public void show(Component component, int n, int n2) {
            this.rebuild();
            super.show(component, n, n2);
        }

        static /* synthetic */ GWMainAppFrame access$400(FilterPopupMenu filterPopupMenu) {
            return filterPopupMenu.GWMainAppFrame.this;
        }

        static /* synthetic */ void access$500(FilterPopupMenu filterPopupMenu) {
            filterPopupMenu.clearSelection();
        }
    }

    private class FilterItemListener
    implements ItemListener {
        private FilterItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Action action = ((JMenuItem)itemEvent.getItem()).getAction();
                if (action instanceof FilterOffAction) {
                    GWMainAppFrame.this.lbFilter.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
                } else {
                    GWMainAppFrame.this.lbFilter.setIcon(ImageResources.ICON_ACTIVE_FILTER);
                }
            }
        }
    }
}

