/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.ClickAction;
import com.novell.gw.jclient.application.DevModeUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.impl.cache.ItemsCache;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class GWStatusBar
extends JPanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$GWStatusBar == null ? (class$com$novell$gw$jclient$application$GWStatusBar = GWStatusBar.class$("com.novell.gw.jclient.application.GWStatusBar")) : class$com$novell$gw$jclient$application$GWStatusBar));
    private JPanel memoryPanel = null;
    private CachePanel cachePanel = null;
    private ThreadsPanel threadsPanel = null;
    private JPanel debugPanel = null;
    private Timer cacheInfoTimer = null;
    private Timer threadsTimer = null;
    private MessagePanel messagePanel = null;
    private ItemsInfoPanel itemsInfoPanel = null;
    Color bkColor = new Color(236, 233, 176);
    Color fgColor = Color.BLACK;
    Color borderColor = new Color(128, 128, 128);
    private boolean showDevModeInfo = true;
    private int CAHE_INFO_REFRESH_DELLAY = 100;
    private int THREADS_REFRESH_DELLAY = 100;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$GWStatusBar;

    public GWStatusBar() {
        this(false);
    }

    public GWStatusBar(boolean bl) {
        this.showDevModeInfo = bl && DevModeUtils.isShowStatus();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        int n = 0;
        gridBagConstraints.gridx = n++;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.messagePanel = new MessagePanel();
        this.messagePanel.setBorder(BorderFactory.createLineBorder(this.borderColor));
        this.add((Component)this.messagePanel, gridBagConstraints);
        gridBagConstraints.gridx = n;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = OS.isMacOS() ? new Insets(0, 0, 0, 16) : new Insets(0, 0, 0, 2);
        this.itemsInfoPanel = new ItemsInfoPanel();
        this.itemsInfoPanel.setVisible(bl);
        this.add((Component)this.itemsInfoPanel, gridBagConstraints);
        ++n;
        if (this.showDevModeInfo) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 2);
            this.debugPanel = new OrientablePanel(new BorderLayout());
            this.threadsPanel = new ThreadsPanel();
            this.debugPanel.add((Component)this.threadsPanel, "Before");
            this.memoryPanel = new MemoryPanel();
            this.debugPanel.add((Component)this.memoryPanel, "After");
            this.cachePanel = new CachePanel();
            this.debugPanel.add((Component)this.cachePanel, "Center");
            this.setComponentsBackground(this.debugPanel, Color.WHITE);
            this.add((Component)this.debugPanel, gridBagConstraints);
            this.initCacheInfoTimer();
            this.initThreadsTimer();
        }
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    private void setComponentsBackground(JComponent jComponent, Color color) {
        jComponent.setBackground(color);
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof JComponent)) continue;
            this.setComponentsBackground((JComponent)component, color);
        }
    }

    public boolean isItemsInfoPanelVisible() {
        return this.itemsInfoPanel.isVisible();
    }

    public void setItemsInfoPanelVisible(boolean bl) {
        this.itemsInfoPanel.setVisible(bl);
    }

    private void doSetTotalItemsCount(int n) {
        this.itemsInfoPanel.updateTotalCount(n);
    }

    public void setTotalItemsCount(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetTotalItemsCount(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doSetTotalItemsCount(n);
                }
            });
        }
    }

    private void doSetMessage(String string) {
        this.messagePanel.setMessage(string);
    }

    public void setMessage(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetMessage(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doSetMessage(string);
                }
            });
        }
    }

    private void doSetAnimation(ImageIcon imageIcon, String string, ClickAction clickAction) {
        this.messagePanel.setAnimation(imageIcon, string, clickAction);
    }

    public void setAnimation(final ImageIcon imageIcon, final String string, final ClickAction clickAction) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetAnimation(imageIcon, string, clickAction);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doSetAnimation(imageIcon, string, clickAction);
                }
            });
        }
    }

    private void doSetSelectedItemsCount(int n) {
        this.itemsInfoPanel.updateSelectedCount(n);
    }

    public void setSelectedItemsCount(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetSelectedItemsCount(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doSetSelectedItemsCount(n);
                }
            });
        }
    }

    private void initCacheInfoTimer() {
        this.cacheInfoTimer = new Timer(this.CAHE_INFO_REFRESH_DELLAY, new CacheInfoTimerAction());
        this.cacheInfoTimer.start();
    }

    private void initThreadsTimer() {
        this.threadsTimer = new Timer(this.THREADS_REFRESH_DELLAY, new ThreadsTimerAction());
        this.threadsTimer.start();
    }

    private void doUpdateCacheInfo() {
        ApplicationFrame applicationFrame = (ApplicationFrame)SwingUtilities.getWindowAncestor(this);
        int n = ItemsCache.getCount(applicationFrame.getUserGuid());
        int n2 = FoldersCache.getCount(applicationFrame.getUserGuid());
        this.cachePanel.updateInfo(n, n2);
    }

    private void updateCacheInfo() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateCacheInfo();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doUpdateCacheInfo();
                }
            });
        }
    }

    private void doUpdateThreadsInfo() {
        this.threadsPanel.updateInfo(Thread.activeCount());
    }

    private void updateThreadsInfo() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateThreadsInfo();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doUpdateThreadsInfo();
                }
            });
        }
    }

    public void clearCounts() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doClearCounts();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doClearCounts();
                }
            });
        }
    }

    private void doClearCounts() {
        this.itemsInfoPanel.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ThreadsPanel
    extends JPanel {
        private String threadsText;
        private JLabel lblThreads;

        public ThreadsPanel() {
            this.setLayout(new BorderLayout());
            this.threadsText = "Threads : ";
            this.lblThreads = new OrientableLabel(this.threadsText);
            this.add((Component)this.lblThreads, "Center");
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.setToolTipText("Client's Threads Info");
        }

        public void updateInfo(int n) {
            this.lblThreads.setText(this.threadsText + n);
        }
    }

    private final class ItemsInfoPanel
    extends JPanel {
        private String selectedText;
        private JLabel lblSelected;
        private String totalText;
        private JLabel lblTotal;

        public ItemsInfoPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 4, 0, 4);
            gridBagConstraints.anchor = 13;
            this.selectedText = StringResources.SELECTED_C + " ";
            this.lblSelected = new OrientableLabel(this.selectedText);
            this.add((Component)this.lblSelected, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 10;
            StatusBarSeparator statusBarSeparator = new StatusBarSeparator();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 3;
            this.add((Component)statusBarSeparator, gridBagConstraints);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(0, 4, 0, 4);
            gridBagConstraints.anchor = 13;
            this.totalText = StringResources.TOTAL_C + " ";
            this.lblTotal = new OrientableLabel(this.totalText);
            this.add((Component)this.lblTotal, gridBagConstraints);
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.updateTotalCount(0);
            this.updateSelectedCount(0);
        }

        public void updateTotalCount(int n) {
            this.lblTotal.setText(this.totalText + n);
        }

        public void updateSelectedCount(int n) {
            this.lblSelected.setText(this.selectedText + n);
        }

        public void clear() {
            this.lblTotal.setText(this.totalText + 0);
            this.lblSelected.setText(this.selectedText + 0);
        }
    }

    private class StatusBarSeparator
    extends JPanel {
        public StatusBarSeparator() {
            this.setPreferredSize(new Dimension(2, 14));
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
        }
    }

    private final class ThreadsTimerAction
    extends AbstractAction {
        private ThreadsTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GWStatusBar.this.updateThreadsInfo();
        }
    }

    private final class CacheInfoTimerAction
    extends AbstractAction {
        private CacheInfoTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GWStatusBar.this.updateCacheInfo();
        }
    }

    private final class CachePanel
    extends JPanel {
        private JLabel lblFolders = null;
        private JLabel lblItems = null;
        private String foldersText;
        private String itemsText;

        public CachePanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            this.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(0, 2, 0, 2);
            this.foldersText = "Folders : ";
            this.lblFolders = new OrientableLabel(this.foldersText);
            this.add((Component)this.lblFolders, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 10;
            StatusBarSeparator statusBarSeparator = new StatusBarSeparator();
            this.add((Component)statusBarSeparator, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 2);
            gridBagConstraints.anchor = 13;
            this.itemsText = "Items : ";
            this.lblItems = new OrientableLabel(this.itemsText);
            this.add((Component)this.lblItems, gridBagConstraints);
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.setToolTipText("Client's Cache Info");
        }

        public void updateInfo(int n, int n2) {
            this.lblItems.setText(this.itemsText + n);
            this.lblFolders.setText(this.foldersText + n2);
        }
    }

    private final class MemoryPanel
    extends JPanel {
        private MemoryStatus memoryStatus = null;
        private JLabel lblGCLock = null;

        public MemoryPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            this.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(0, 2, 0, 2);
            this.memoryStatus = new MemoryStatus();
            this.add((Component)this.memoryStatus, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 2);
            this.lblGCLock = new OrientableLabel();
            this.lblGCLock.setIcon(ImageResources.ICON_GC);
            this.lblGCLock.setToolTipText("Run Garbage Collector");
            this.lblGCLock.setPreferredSize(new Dimension(18, 18));
            this.lblGCLock.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.lblGCLock.addMouseListener(new GCMouseListener());
            this.add((Component)this.lblGCLock, gridBagConstraints);
        }

        private class GCMouseListener
        extends MouseAdapter {
            private GCMouseListener() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                System.gc();
                MemoryPanel.this.memoryStatus.repaint();
            }
        }
    }

    private final class MessagePanel
    extends JPanel {
        private JLabel messageLabel = null;
        private JLabel lblAnimeStatus = null;
        private ClickAction clickAction;
        private ClickListener clickListener;

        public MessagePanel() {
            this.setLayout(new BorderLayout());
            this.lblAnimeStatus = new OrientableLabel("");
            this.lblAnimeStatus.setPreferredSize(new Dimension(18, 18));
            this.lblAnimeStatus.setBorder(new EmptyBorder(0, 4, 0, 0));
            this.add((Component)this.lblAnimeStatus, "Before");
            this.messageLabel = new OrientableLabel();
            this.messageLabel.setBorder(new EmptyBorder(0, 4, 0, 4));
            this.add((Component)this.messageLabel, "Center");
            this.clickListener = new ClickListener();
        }

        public void setMessage(String string) {
            this.messageLabel.setText(string);
        }

        public void setAnimation(ImageIcon imageIcon, String string, ClickAction clickAction) {
            this.lblAnimeStatus.setIcon(imageIcon);
            this.lblAnimeStatus.setIconTextGap(0);
            this.lblAnimeStatus.setHorizontalAlignment(0);
            this.lblAnimeStatus.setVerticalAlignment(0);
            this.lblAnimeStatus.setToolTipText(string);
            this.setClickAction(clickAction);
        }

        private void setClickAction(ClickAction clickAction) {
            this.clickAction = clickAction;
            MouseListener[] mouseListenerArray = this.lblAnimeStatus.getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                MouseListener mouseListener = mouseListenerArray[i];
                this.lblAnimeStatus.removeMouseListener(mouseListener);
            }
            if (this.clickAction != null) {
                this.lblAnimeStatus.addMouseListener(this.clickListener);
            }
        }

        private class ClickListener
        implements MouseListener {
            private ClickListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                MessagePanel.this.clickAction.click();
            }
        }
    }

    private class MemoryStatus
    extends JComponent
    implements ActionListener {
        static final String memoryTestStr = "O99,9/O99,9Mb";
        private LineMetrics lm;
        private Color progressForeground;
        private Color progressBackground;
        private Timer timer;
        private NumberFormat numberFormat;

        public MemoryStatus() {
            Font font = UIManager.getFont("Label.font");
            Dimension dimension = null;
            this.setFont(font);
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            Rectangle2D rectangle2D = font.getStringBounds(memoryTestStr, fontRenderContext);
            dimension = new Dimension((int)rectangle2D.getWidth(), 18);
            this.lm = font.getLineMetrics(memoryTestStr, fontRenderContext);
            this.progressForeground = GWStatusBar.this.fgColor;
            this.progressBackground = GWStatusBar.this.bkColor;
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.setDoubleBuffered(true);
            this.setForeground(UIManager.getColor("Label.foreground"));
            this.setBackground(UIManager.getColor("Label.background"));
            this.setFont(UIManager.getFont("Label.font"));
            this.numberFormat = NumberFormat.getNumberInstance();
            this.numberFormat.setMaximumIntegerDigits(3);
            this.numberFormat.setMaximumFractionDigits(1);
            this.numberFormat.setMinimumFractionDigits(1);
        }

        public void addNotify() {
            super.addNotify();
            this.timer = new Timer(2000, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            Insets insets = new Insets(0, 0, 0, 0);
            Insets insets2 = new Insets(2, 0, 0, 0);
            Runtime runtime = Runtime.getRuntime();
            int n = (int)(runtime.freeMemory() / 1024L);
            int n2 = (int)(runtime.totalMemory() / 1024L);
            int n3 = n2 - n;
            int n4 = this.getWidth() - insets.left - insets.right;
            int n5 = this.getHeight() - insets.top - insets.bottom - 1;
            float f = (float)n3 / (float)n2;
            graphics.setColor(this.progressBackground);
            graphics.fillRect(insets.left, insets.top, (int)((float)n4 * f), n5);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.numberFormat.format((double)n3 / 1024.0));
            stringBuffer.append("/");
            stringBuffer.append(this.numberFormat.format((double)n2 / 1024.0));
            stringBuffer.append("Mb");
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            Rectangle2D rectangle2D = graphics.getFont().getStringBounds(stringBuffer.toString(), fontRenderContext);
            Graphics graphics2 = graphics.create();
            graphics2.setClip(insets2.left, insets2.top, (int)((float)n4 * f), n5);
            graphics2.setColor(this.progressForeground);
            graphics2.drawString(stringBuffer.toString(), insets2.left + (int)((double)n4 - rectangle2D.getWidth()) / 2, (int)((float)insets2.top + this.lm.getAscent()));
            graphics2.dispose();
            graphics2 = graphics.create();
            graphics2.setClip(insets.left + (int)((float)n4 * f), insets.top, this.getWidth() - insets.left - (int)((float)n4 * f), n5);
            graphics2.setColor(this.getForeground());
            graphics2.drawString(stringBuffer.toString(), insets2.left + (int)((double)n4 - rectangle2D.getWidth()) / 2, (int)((float)insets2.top + this.lm.getAscent()));
            graphics2.dispose();
        }
    }
}

