/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.ExTableUI;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class OrientableTable
extends JTable {
    public static final int TABLE_DEFAULT_HEIGHT = PLAFChanger.getFontSize() + 8;
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$OrientableTable == null ? (class$com$novell$gw$jclient$application$OrientableTable = OrientableTable.class$("com.novell.gw.jclient.application.OrientableTable")) : class$com$novell$gw$jclient$application$OrientableTable));
    static /* synthetic */ Class class$com$novell$gw$jclient$application$OrientableTable;
    static /* synthetic */ Class class$java$lang$Object;

    public OrientableTable() {
        this.initUI();
    }

    public OrientableTable(TableModel tableModel) {
        super(tableModel);
        this.initUI();
    }

    protected void initUI() {
        this.setShowGrid(false);
        this.setUI(new OrientableTableUI());
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = OrientableTable.class$("java.lang.Object")) : class$java$lang$Object, new OrientableTableCellRenderer());
        UIUtils.initTableFocusTraversalKeys(this);
        this.getTableHeader().setPreferredSize(new Dimension(this.getTableHeader().getPreferredSize().width, TABLE_DEFAULT_HEIGHT));
        this.adjustRowHeight();
    }

    private void adjustRowHeight() {
        FontMetrics fontMetrics;
        int n;
        int n2 = 15;
        Font font = this.getFont();
        if (font != null && (n = (fontMetrics = this.getFontMetrics(font)).getHeight()) > n2) {
            n2 = n;
        }
        n2 = (int)((double)n2 * 1.2);
        this.setRowHeight(n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class OrientableTableUI
    extends ExTableUI {
        private OrientableTableUI() {
        }

        protected MouseInputListener createMouseInputListener() {
            return new TUMouseListener();
        }

        private class TUMouseListener
        extends MyMouseInputHandler {
            private TUMouseListener() {
            }

            private boolean isSelectionAlowed(MouseEvent mouseEvent) {
                boolean bl = OrientableTable.this.isRowSelected(OrientableTable.this.rowAtPoint(mouseEvent.getPoint()));
                boolean bl2 = OS.isMacOS() ? mouseEvent.isShiftDown() || mouseEvent.isMetaDown() || bl : mouseEvent.isShiftDown() || mouseEvent.isControlDown() || bl;
                return bl2;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.isSelectionAlowed(mouseEvent)) {
                    // empty if block
                }
            }
        }
    }

    public class MyMouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;
        private boolean pressedInSelection = false;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = OrientableTable.this.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(OrientableTable.this, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null || !OrientableTable.this.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(OrientableTable.this, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private void setValueIsAdjusting(boolean bl) {
            OrientableTable.this.getSelectionModel().setValueIsAdjusting(bl);
            OrientableTable.this.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !OS.isLeftMouseButton(mouseEvent) || !OrientableTable.this.isEnabled();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(mouseEvent);
        }

        void adjustFocusAndSelection(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = OrientableTable.this.rowAtPoint(point);
            int n2 = OrientableTable.this.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            if (OrientableTable.this.editCellAt(n, n2, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            } else if (OrientableTable.this.isRequestFocusEnabled()) {
                OrientableTable.this.requestFocus();
            }
            TableCellEditor tableCellEditor = OrientableTable.this.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                boolean bl;
                boolean bl2 = mouseEvent.getID() == 501;
                this.setValueIsAdjusting(bl2);
                int n3 = OrientableTable.this.rowAtPoint(mouseEvent.getPoint());
                if (OS.isMacOS()) {
                    bl = mouseEvent.isShiftDown() || mouseEvent.isMetaDown();
                } else {
                    boolean bl3 = bl = mouseEvent.isShiftDown() || mouseEvent.isControlDown();
                }
                if (n3 >= 0 && this.inSelection(n3) && !mouseEvent.isPopupTrigger() && !bl && !this.pressedInSelection) {
                    this.pressedInSelection = true;
                    this.selectedOnPress = false;
                } else {
                    this.pressedInSelection = false;
                    this.doChangeSelection(n, n2, mouseEvent);
                }
            }
        }

        private void doChangeSelection(int n, int n2, MouseEvent mouseEvent) {
            if (OS.isMacOS()) {
                OrientableTable.this.changeSelection(n, n2, mouseEvent.isMetaDown(), mouseEvent.isShiftDown());
            } else {
                OrientableTable.this.changeSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
        }

        private boolean inSelection(int n) {
            OrientableTable orientableTable = OrientableTable.this;
            int[] nArray = orientableTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
            return false;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                this.repostEvent(mouseEvent);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.repostEvent(mouseEvent);
            TableCellEditor tableCellEditor = OrientableTable.this.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                int n = OrientableTable.this.rowAtPoint(point);
                int n2 = OrientableTable.this.columnAtPoint(point);
                if (n2 == -1 || n == -1) {
                    return;
                }
                OrientableTable.this.changeSelection(n, n2, false, true);
            }
        }
    }
}

