/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppActionModel;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.ab.Recipient;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.AbstractAddressBookAction;
import com.novell.gw.jclient.application.actions.ActionNewCalendarItem;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameComposeAppointment;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionNewAppointment
extends AbstractAddressBookAction
implements ActionNewCalendarItem {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$ActionNewAppointment == null ? (class$com$novell$gw$jclient$application$actions$ActionNewAppointment = ActionNewAppointment.class$("com.novell.gw.jclient.application.actions.ActionNewAppointment")) : class$com$novell$gw$jclient$application$actions$ActionNewAppointment));
    private boolean isCreatedFromBusySearch;
    private Date selectedDate = new Date();
    private boolean calendarView = false;
    private TimeInterval appointmentTime = new TimeInterval();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$ActionNewAppointment;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$AppointmentItem;

    public ActionNewAppointment(ApplicationFrameActionList applicationFrameActionList) {
        this(applicationFrameActionList, new AppActionModel("New Appointment", StringResources.ACTION_APPOINTMENT, ImageResources.ICON_ACT_NEW_APPOINTMENT));
        this.appActionModel.setAccelerator(KeyStroke.getKeyStroke(65, 1 + OS.getMetaKey()));
    }

    protected ActionNewAppointment(ActionList actionList, AppActionModel appActionModel) {
        super(actionList, appActionModel);
    }

    protected void performAction(ActionEvent actionEvent) {
        if (!this.validateRecipients()) {
            return;
        }
        try {
            Object object;
            AppointmentItem appointmentItem = null;
            appointmentItem = this.getAppointment();
            this.setAppointmentInitialDates(appointmentItem);
            FrameComposeAppointment frameComposeAppointment = new FrameComposeAppointment(appointmentItem, GWClient.getApplication(), true, this.getUserGuid());
            frameComposeAppointment.getItemEdit().setSendingFromAddressBook(this.isSendingFromAddressBook);
            if ((this.allRecipients.isEmpty() || this.isCreatedFromBusySearch) && (object = GWCommandManager.getInstance(this.getUserGuid()).getUserFields()) != null) {
                this.validRecipients.add(new Recipient(object));
            }
            this.sendRecipients(frameComposeAppointment);
            this.allRecipients.clear();
            this.isCreatedFromBusySearch = false;
            frameComposeAppointment.showMe();
            object = new GlobalCommand(480, frameComposeAppointment);
            frameComposeAppointment.getController().processCommand((Command)object);
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException, (Throwable)gWCommandException);
            ErrorDialog.processGWException(gWCommandException);
        }
    }

    protected void setAppointmentInitialDates(AppointmentItem appointmentItem) {
        if (this.isCreatedFromBusySearch) {
            appointmentItem.setStartDates(new Date[]{this.appointmentTime.getStartDateAsDate()});
            appointmentItem.setEndDate(this.appointmentTime.getEndDateAsDate());
        } else if (this.isCalendarView()) {
            appointmentItem.setStartDates(new Date[]{this.getSelectedDate()});
            appointmentItem.setEndDate(new Date(this.getSelectedDate().getTime() + 3600000L));
        } else {
            appointmentItem.changeDuration(60);
        }
    }

    protected AppointmentItem getAppointment() throws GWCommandException {
        AppointmentItem appointmentItem = (AppointmentItem)GWCommandManager.getInstance(this.getUserGuid()).composeNewItem(class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = ActionNewAppointment.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem);
        return appointmentItem;
    }

    public JComponent getToolBarComponent() {
        ListPopupPane listPopupPane = new ListPopupPane(this, StringResources.NEW_APPT);
        listPopupPane.addAction(this.getActionList().getAction("Posted Appointment"));
        listPopupPane.addSeparator();
        listPopupPane.addAction(this.getActionList().getAction("New Appointment"), StringResources.APPOINTMENT);
        return listPopupPane;
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        AppEventListener appEventListener = new SELECTED_DATE_CHANGED_Listener();
        AppEventManager.getInstance().addListener(level, 70, appEventListener);
        appEventListener = new FOLDER_SELECTED_Listener();
        AppEventManager.getInstance().addListener(level, 10, appEventListener);
    }

    public void setMVCModel(Object object) {
        super.setMVCModel(object);
        if (object instanceof GWBusySearch) {
            this.isCreatedFromBusySearch = true;
            GWBusySearch gWBusySearch = (GWBusySearch)object;
            this.appointmentTime = gWBusySearch.getAppointmentTime();
            this.allRecipients = gWBusySearch.getRecipientsList().getSelectedRecipients(-1);
        }
    }

    public boolean isCalendarView() {
        return this.calendarView;
    }

    public void setCalendarView(boolean bl) {
        this.calendarView = bl;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date date) {
        this.selectedDate = date;
    }

    protected boolean checkAccess() {
        return GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().checkAccess(1, 8, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FOLDER_SELECTED_Listener
    extends AppEventListener {
        private FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            if (appEvent.getData() instanceof CalendarFolder) {
                ActionNewAppointment.this.setCalendarView(true);
            } else {
                ActionNewAppointment.this.setCalendarView(false);
            }
        }
    }

    private class SELECTED_DATE_CHANGED_Listener
    extends AppEventListener {
        private SELECTED_DATE_CHANGED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionNewAppointment.this.setSelectedDate((Date)appEvent.getData());
        }
    }
}

