/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ActionSwitchArchiveStorage
extends AppAction {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$ActionSwitchArchiveStorage == null ? (class$com$novell$gw$jclient$application$actions$ActionSwitchArchiveStorage = ActionSwitchArchiveStorage.class$("com.novell.gw.jclient.application.actions.ActionSwitchArchiveStorage")) : class$com$novell$gw$jclient$application$actions$ActionSwitchArchiveStorage));
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$ActionSwitchArchiveStorage;

    public ActionSwitchArchiveStorage(ActionList actionList) {
        super(actionList, new AppActionModel("Show Archive Store", StringResources.ARCHIVE, ImageResources.FLD_WORLD, 2));
    }

    protected void performAction(ActionEvent actionEvent) {
        if (!GWCommandManager.getInstance(this.getUserGuid()).isArchive()) {
            try {
                if (!Utils.checkArchivePath(this.getUserGuid())) {
                    return;
                }
                String string = GWCommandManager.getInstance(this.getUserGuid()).switchToArchiveMode();
                Command command = new Command(800, new StorageMode(1, string));
                this.getActionList().processCommand(command);
                this.getActionList().performAction("Refresh");
            }
            catch (GWCommandException gWCommandException) {
                logger.error((Object)gWCommandException, (Throwable)gWCommandException);
                ErrorDialog.processGWException(gWCommandException);
            }
        }
    }

    protected void registerListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        AppEventListener appEventListener = new PROXY_DATA_STORE_INSTALLED_Listener();
        AppEventManager.getInstance().addListener(level, 750, appEventListener);
        appEventListener = new STORE_MODE_CHANGED_Listener();
        AppEventManager.getInstance().addListener(level, 800, appEventListener);
        appEventListener = new ACTION_SWITCH_ONLINE_PERFORMED_Listener();
        AppEventManager.getInstance().addListener(level, 740, appEventListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            StorageMode storageMode = (StorageMode)appEvent.getData();
            if (storageMode.isNormal()) {
                ActionSwitchArchiveStorage.this.setEnabled(true);
            }
        }
    }

    private class ACTION_SWITCH_ONLINE_PERFORMED_Listener
    extends AppEventListener {
        private ACTION_SWITCH_ONLINE_PERFORMED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionSwitchArchiveStorage.this.setEnabled(true);
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionSwitchArchiveStorage.this.setEnabled(false);
        }
    }
}

