/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.event.ActionEvent;

public class ActionSwitchCaching
extends AppAction {
    public ActionSwitchCaching(ApplicationFrameActionList applicationFrameActionList) {
        super(applicationFrameActionList, new AppActionModel("Caching", StringResources.CACHING, ImageResources.ACT_SWITCH_CACHING, 2));
        this.setSelected();
        this.setEnabled(EngineCommandManager.canSwitchCaching());
    }

    private void setSelected() {
        this.setSelected(EngineCommandManager.getCurrentMode() == 6);
    }

    protected void performAction(ActionEvent actionEvent) {
        if (!this.isSelected()) {
            GWCommandManager.getInstance(this.getUserGuid()).switchToCaching();
            if (this.getController() != null) {
                this.getController().processCommand(new GlobalCommand(730));
            }
        }
    }

    protected void registerListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        AppEventListener appEventListener = new PROXY_DATA_STORE_INSTALLED_Listener();
        AppEventManager.getInstance().addListener(level, 750, appEventListener);
        appEventListener = new STORE_MODE_CHANGED_Listener();
        AppEventManager.getInstance().addListener(level, 800, appEventListener);
        appEventListener = new ACTION_SWITCH_CACHING_PERFORMED_ACTION_SWITCH_ONLINE_PERFORMED_Listener();
        AppEventManager.getInstance().addListener(level, 730, appEventListener);
        AppEventManager.getInstance().addListener(level, 740, appEventListener);
    }

    private class ACTION_SWITCH_CACHING_PERFORMED_ACTION_SWITCH_ONLINE_PERFORMED_Listener
    extends AppEventListener {
        private ACTION_SWITCH_CACHING_PERFORMED_ACTION_SWITCH_ONLINE_PERFORMED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionSwitchCaching.this.setSelected();
            ActionSwitchCaching.this.setEnabled(EngineCommandManager.canSwitchCaching());
        }
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            StorageMode storageMode = (StorageMode)appEvent.getData();
            ActionSwitchCaching.this.setEnabled(storageMode.isNormal());
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionSwitchCaching.this.setEnabled(false);
        }
    }
}

