/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.novell.gw.jclient.application.dialogs.DeleteFolderPane;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.JunkMailFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SharedRefFolder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionDeleteFolder
extends AppAction {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$actions$folder$ActionDeleteFolder == null ? (class$com$novell$gw$jclient$application$actions$folder$ActionDeleteFolder = ActionDeleteFolder.class$("com.novell.gw.jclient.application.actions.folder.ActionDeleteFolder")) : class$com$novell$gw$jclient$application$actions$folder$ActionDeleteFolder));
    private WeakHashMap menuItems = new WeakHashMap();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$actions$folder$ActionDeleteFolder;

    public ActionDeleteFolder(ApplicationFrameActionList applicationFrameActionList) {
        super(applicationFrameActionList, new AppActionModel("Delete Folder", StringResources.ACTION_DELETE, ImageResources.ICON_ACT_DELETE));
        this.setEnabled(false);
        this.appActionModel.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
    }

    protected void performAction(ActionEvent actionEvent) {
        ActionDeleteFolder.doPerformAction((AbstractFolder)this.getMVCModel(), this.getActionList().getOwnerComponent(), this.getUserGuid());
    }

    public static void doPerformAction(AbstractFolder abstractFolder, Component component, String string) {
        if (abstractFolder == null) {
            JOptionPane.showMessageDialog(component, StringResources.FOLDER_IS_NOT_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
        if (abstractFolder instanceof SharedRefFolder || abstractFolder instanceof QueryFolder) {
            int n = JOptionPane.showConfirmDialog(component, StringResources.formatString(StringResources.ARE_YOU_SURE_YOU_WANT_TO_DELETE_FOLDER, new String[]{abstractFolder.getName()}), StringResources.CONFIRM_FOLDER_DELETE, 0);
            if (n == 0) {
                ActionDeleteFolder.deleteFolder(abstractFolder, string);
            }
        } else {
            int n = DeleteFolderPane.showDeleteDialog(component);
            if (n == 0) {
                ActionDeleteFolder.emptyFolder(abstractFolder);
            } else if (n == 1) {
                ActionDeleteFolder.deleteFolder(abstractFolder, string);
            }
        }
    }

    private static boolean emptyFolder(AbstractFolder abstractFolder) {
        return abstractFolder.getNativeFolder().deleteItems();
    }

    private static void deleteFolder(AbstractFolder abstractFolder, String string) {
        boolean bl = abstractFolder.getNativeFolder().delete();
        if (bl) {
            FoldersCache.removeFolder(abstractFolder, string);
        }
    }

    protected void registerListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        AppEventListener appEventListener = new ITEM_DELETE_KEY_CHANGED_listener();
        AppEventManager.getInstance().addListener(level, 1380, appEventListener);
        appEventListener = new FOLDER_SELECTED_Listener();
        AppEventManager.getInstance().addListener(level, 10, appEventListener);
    }

    public JMenuItem getMenuItem() {
        JMenuItem jMenuItem = super.getMenuItem();
        this.menuItems.put(jMenuItem, jMenuItem);
        return jMenuItem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ITEM_DELETE_KEY_CHANGED_listener
    extends AppEventListener {
        private ITEM_DELETE_KEY_CHANGED_listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionDeleteFolder.this.appActionModel.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
            Iterator iterator = ActionDeleteFolder.this.menuItems.values().iterator();
            while (iterator.hasNext()) {
                JMenuItem jMenuItem = (JMenuItem)iterator.next();
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
            }
        }
    }

    class FOLDER_SELECTED_Listener
    extends AppEventListener {
        FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractFolder abstractFolder = (AbstractFolder)appEvent.getData();
            ActionDeleteFolder.this.setMVCModel(abstractFolder);
            if (abstractFolder instanceof JunkMailFolder) {
                ActionDeleteFolder.this.setEnabled(false);
            } else {
                ActionDeleteFolder.this.setEnabled(abstractFolder.canDelete());
            }
        }
    }
}

