/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.AppAction;
import com.appframework.AppActionModel;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.dialogs.newfolder.CreateFolderDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;

public class ActionNewFolder
extends AppAction {
    public ActionNewFolder(ApplicationFrameActionList applicationFrameActionList) {
        super(applicationFrameActionList, new AppActionModel("New Folder", StringResources.NEW_FOLDER, ImageResources.ICON_ACT_NEW_FOLDER));
    }

    protected void performAction(ActionEvent actionEvent) {
        ActionNewFolder.doPerformAction((JFrame)((Object)this.getActionList().getMVCView()), (AbstractFolder)this.getMVCModel());
    }

    public static void doPerformAction(JFrame jFrame, AbstractFolder abstractFolder) {
        CreateFolderDialog createFolderDialog = new CreateFolderDialog(jFrame, abstractFolder);
        createFolderDialog.showMe();
    }

    private boolean checkAccess() {
        return GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().checkAccess(1, 512, 0);
    }

    protected void registerListeners() {
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        AppEventListener appEventListener = new FOLDER_SELECTED_Listener();
        AppEventManager.getInstance().addListener(level, 10, appEventListener);
        appEventListener = new StoreModeChangedListener();
        AppEventManager.getInstance().addListener(level, 800, appEventListener);
        appEventListener = new PROXY_DATA_STORE_INSTALLED_Listener();
        AppEventManager.getInstance().addListener(level, 750, appEventListener);
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionNewFolder.this.setEnabled(ActionNewFolder.this.checkAccess());
        }
    }

    private class StoreModeChangedListener
    extends AppEventListener {
        private StoreModeChangedListener() {
        }

        public void handle(AppEvent appEvent) {
            StorageMode storageMode = (StorageMode)appEvent.getData();
            ActionNewFolder.this.setEnabled(storageMode.isNormal());
        }
    }

    protected class FOLDER_SELECTED_Listener
    extends AppEventListener {
        protected FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            AbstractFolder abstractFolder = (AbstractFolder)appEvent.getData();
            ActionNewFolder.this.setMVCModel(abstractFolder);
        }
    }
}

