/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.AppActionModel;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.resources.CheckedIcon;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ActionMoveToArchive
extends AbstractMultipleItemsAction {
    private boolean inArchive = false;
    private JMenuItem menuItem = OS.createMenuItem(this);
    private JMenuItem popupMenuItem = OS.createMenuItem(this);

    public ActionMoveToArchive(ActionList actionList) {
        super(actionList, new AppActionModel("Move to Archive", StringResources.MOVE_TO_ARCHIVE, StringResources.MOVE_TO_ARCHIVE, ImageResources.ACT_MOVE_TO_ARCHIVE, 2));
    }

    protected void performAction(ActionEvent actionEvent) {
        if (this.isSingleItemModel()) {
            IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
            iDObjectsCollection.addIDObject(this.getGWItem());
            this.moveToArchive(iDObjectsCollection);
        } else if (this.isMultipleItemsModel()) {
            this.moveToArchive(this.getMultipleItems());
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
        this.resetMenuCheck();
        this.wasPerformed = true;
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public JMenuItem getPopupMenuItem() {
        return this.popupMenuItem;
    }

    private void resetMenuCheck() {
        if (OS.isMacOS()) {
            if (this.inArchive) {
                this.menuItem.setSelected(true);
                this.popupMenuItem.setSelected(true);
            } else {
                this.menuItem.setSelected(false);
                this.popupMenuItem.setSelected(false);
            }
        }
    }

    private void moveToArchive(IDObjectsCollection iDObjectsCollection) {
        try {
            GWCommandManager.getInstance(this.getUserGuid()).archiveItems(iDObjectsCollection);
        }
        catch (GWCommandException gWCommandException) {
            ErrorDialog.processGWException(gWCommandException);
        }
    }

    protected boolean checkEnableOnSelect() {
        IDObjectsCollection iDObjectsCollection;
        this.resetMenuCheck();
        if (this.isSingleItemModel()) {
            return this.getGWItem().canArchive();
        }
        if (this.isMultipleItemsModel() && (iDObjectsCollection = this.getMultipleItems()).size() > 0) {
            AbstractItem abstractItem = (AbstractItem)iDObjectsCollection.getIDObjectAt(0);
            return abstractItem.canArchive();
        }
        return false;
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = LevelManager.getInstance().getFrameLevel(this.getActionList().getLevel());
        AppEventListener appEventListener = new STORE_MODE_CHANGED_Listener();
        AppEventManager.getInstance().addListener(level, 800, appEventListener);
        appEventListener = new PROXY_DATA_STORE_INSTALLED_Listener();
        AppEventManager.getInstance().addListener(level, 750, appEventListener);
        appEventListener = new ACTION_SWITCH_ONLINE_PERFORMED_Listener();
        AppEventManager.getInstance().addListener(level, 740, appEventListener);
    }

    private void handle_STORE_MODE_CHANGED(AppEvent appEvent) {
        boolean bl = this.inArchive = !this.inArchive;
        if (OS.isMacOS()) {
            this.resetMenuCheck();
        } else if (this.inArchive) {
            this.putValue("SmallIcon", new CheckedIcon());
        } else {
            this.putValue("SmallIcon", ImageResources.ACT_MOVE_TO_ARCHIVE);
        }
    }

    private void handle_PROXY_DATA_STORE_INSTALLED(AppEvent appEvent) {
        this.setEnabled(false);
    }

    private void handle_ACTION_SWITCH_ONLINE_PERFORMED(AppEvent appEvent) {
        this.setEnabled(true);
    }

    private class ACTION_SWITCH_ONLINE_PERFORMED_Listener
    extends AppEventListener {
        private ACTION_SWITCH_ONLINE_PERFORMED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionMoveToArchive.this.handle_ACTION_SWITCH_ONLINE_PERFORMED(appEvent);
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionMoveToArchive.this.handle_PROXY_DATA_STORE_INSTALLED(appEvent);
        }
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent appEvent) {
            ActionMoveToArchive.this.handle_STORE_MODE_CHANGED(appEvent);
        }
    }
}

