/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.alarm;

import com.appframework.ApplicationFrame;
import com.appframework.components.DigitDocument;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.alarm.AlarmDialogController;
import com.novell.gw.jclient.application.alarm.AlarmSet;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.saver.AlarmManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.options.AlarmOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AlarmDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$alarm$AlarmDialog == null ? (class$com$novell$gw$jclient$application$alarm$AlarmDialog = AlarmDialog.class$("com.novell.gw.jclient.application.alarm.AlarmDialog")) : class$com$novell$gw$jclient$application$alarm$AlarmDialog));
    private Dimension dimSize = new Dimension(430, 190);
    private static final int DEFAULT_MIN = 10;
    private JTextField tfBeforeHours;
    private JTextField tfBeforeMins;
    private JTextField tfLaunchProg;
    private JButton btnLaunchProg;
    private File lastSelectedFile = new File("./");
    private AbstractCalendarItem item;
    private BtnSetAction btnSetAction;
    private JButton btnClear;
    private JButton btnClearAll;
    private ApplicationFrame applicationFrame;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$alarm$AlarmDialog;

    public AlarmDialog(ApplicationFrame applicationFrame, AbstractCalendarItem abstractCalendarItem, MVCController mVCController) {
        super(applicationFrame, true);
        this.setController(new AlarmDialogController(this, mVCController));
        this.item = abstractCalendarItem;
        this.applicationFrame = applicationFrame;
        this.buildUI();
        this.refreshView();
    }

    private void buildUI() {
        this.setTitle(StringResources.ALARM);
        this.setSize(this.dimSize);
        this.getContentPane().setLayout(new BorderLayout());
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.add((Component)this.buildBeforePanel(), "North");
        orientablePanel.add((Component)this.buildLaunchPanel(), "South");
        this.getContentPane().add((Component)orientablePanel, "Before");
        this.getContentPane().add((Component)this.buildButtonsPanel(), "After");
    }

    private JPanel buildBeforePanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(StringResources.HOURS_BEFORE_C);
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        orientablePanel.add((Component)jLabel, gridBagConstraints);
        this.tfBeforeHours = new JTextField();
        this.tfBeforeHours.setDocument(new DigitDocument());
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.ipadx = 25;
        orientablePanel.add((Component)this.tfBeforeHours, gridBagConstraints);
        jLabel = new JLabel(StringResources.MINUTES_BEFORE_C);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.ipadx = 0;
        orientablePanel.add((Component)jLabel, gridBagConstraints);
        this.tfBeforeMins = new JTextField();
        this.tfBeforeMins.setDocument(new DigitDocument());
        this.tfBeforeMins.setText(Integer.toString(10));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.ipadx = 25;
        orientablePanel.add((Component)this.tfBeforeMins, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.btnSetAction = new BtnSetAction();
        JButton jButton = new JButton(StringResources.SET);
        jButton.addActionListener(this.btnSetAction);
        gridBagConstraints.insets = new Insets(20, 20, 0, 20);
        gridBagConstraints.fill = 1;
        orientablePanel.add((Component)jButton, gridBagConstraints);
        this.btnClear = new JButton(StringResources.CLEAR);
        this.btnClear.addActionListener(new BtnClearAction());
        gridBagConstraints.insets = new Insets(10, 20, 0, 20);
        gridBagConstraints.gridy = 1;
        orientablePanel.add((Component)this.btnClear, gridBagConstraints);
        this.btnClearAll = new JButton(StringResources.CLEAR_ALL);
        this.btnClearAll.addActionListener(new BtnClearAllAction());
        gridBagConstraints.insets = new Insets(10, 20, 0, 20);
        gridBagConstraints.gridy = 2;
        orientablePanel.add((Component)this.btnClearAll, gridBagConstraints);
        AlarmDialog.setButtonsState(this.btnClear, this.btnClearAll, this.item);
        JButton jButton2 = new JButton(StringResources.CLOSE);
        jButton2.addActionListener(new BtnCloseAction());
        this.setCancelButton(jButton2);
        this.setDefaultButton(jButton2);
        gridBagConstraints.insets = new Insets(10, 20, 20, 20);
        gridBagConstraints.gridy = 3;
        orientablePanel.add((Component)jButton2, gridBagConstraints);
        return orientablePanel;
    }

    public static void setButtonsState(JButton jButton, JButton jButton2, AbstractCalendarItem abstractCalendarItem) {
        jButton.setEnabled(true);
        jButton2.setEnabled(true);
        if (AlarmSet.getAlarmSetForItem(abstractCalendarItem) == null) {
            jButton.setEnabled(false);
            jButton2.setEnabled(false);
        } else {
            jButton2.setEnabled(false);
        }
    }

    private void refreshView() {
        AlarmSet alarmSet = AlarmSet.getAlarmSetForItem(this.item);
        if (alarmSet != null) {
            Date date = alarmSet.getAlarmDate();
            long l = 0L;
            l = this.item.getDate().getTime() - date.getTime() - (long)GWCalendarUtils.getZoneOffset();
            int n = (int)(l /= 60000L) / 60;
            int n2 = (int)l % 60;
            this.tfBeforeHours.setText(Integer.toString(n));
            this.tfBeforeMins.setText(Integer.toString(n2));
            this.tfLaunchProg.setText(alarmSet.getLaunchProg());
        } else {
            this.tfBeforeMins.setText(Integer.toString(10));
        }
    }

    private JPanel buildLaunchPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(StringResources.PROGRAM_TO_LAUNCH);
        gridBagConstraints.insets = new Insets(10, 20, 5, 0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        orientablePanel.add((Component)jLabel, gridBagConstraints);
        this.tfLaunchProg = new JTextField();
        gridBagConstraints.insets = new Insets(0, 20, 20, 0);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 220;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        orientablePanel.add((Component)this.tfLaunchProg, gridBagConstraints);
        this.btnLaunchProg = new JButton("...");
        this.btnLaunchProg.addActionListener(new BtnLaunchProgAction());
        this.btnLaunchProg.setPreferredSize(new Dimension(19, 19));
        gridBagConstraints.insets = new Insets(0, 5, 20, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.ipadx = 0;
        orientablePanel.add((Component)this.btnLaunchProg, gridBagConstraints);
        return orientablePanel;
    }

    BtnSetAction getBtnSetAction() {
        return this.btnSetAction;
    }

    JButton getBtnClear() {
        return this.btnClear;
    }

    JButton getBtnClearAll() {
        return this.btnClearAll;
    }

    public ApplicationFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BtnLaunchProgAction
    extends AbstractAction {
        BtnLaunchProgAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OS.isMacOS()) {
                GWMacFileChooser gWMacFileChooser = new GWMacFileChooser((Frame)AlarmDialog.this.getApplicationFrame(), StringResources.OPEN_PROGRAM, AlarmDialog.this.lastSelectedFile, 0);
                gWMacFileChooser.setVisible(true);
                String string = gWMacFileChooser.getFile();
                if (string != null) {
                    AlarmDialog.this.lastSelectedFile = new File(string).getParentFile();
                    AlarmDialog.this.tfLaunchProg.setText(string);
                }
            } else {
                GWFileChooser gWFileChooser = new GWFileChooser(AlarmDialog.this, StringResources.OPEN_PROGRAM, AlarmDialog.this.lastSelectedFile, null, 0, 0, false);
                gWFileChooser.setVisible(true);
                String[] stringArray = gWFileChooser.getResult();
                if (stringArray != null) {
                    AlarmDialog.this.lastSelectedFile = new File(stringArray[0]).getParentFile();
                    AlarmDialog.this.tfLaunchProg.setText(stringArray[0]);
                }
            }
        }
    }

    class BtnCloseAction
    extends AbstractAction {
        BtnCloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GWDialog.disposeDialog(AlarmDialog.this);
        }
    }

    class BtnClearAllAction
    extends AbstractAction {
        BtnClearAllAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Command command = new Command(340, AlarmDialog.this.item);
            AlarmDialog.this.getController().processCommand(command);
            GWDialog.disposeDialog(AlarmDialog.this);
        }
    }

    class BtnClearAction
    extends AbstractAction {
        BtnClearAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Command command = new Command(340, AlarmDialog.this.item);
            AlarmDialog.this.getController().processCommand(command);
            GWDialog.disposeDialog(AlarmDialog.this);
        }
    }

    class BtnSetAction
    extends AbstractAction {
        BtnSetAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2 = AlarmDialog.this.tfBeforeHours.getText();
            if (string2.equals("")) {
                string2 = "0";
            }
            if ((string = AlarmDialog.this.tfBeforeMins.getText()).equals("")) {
                string = "0";
            }
            long l = (Integer.parseInt(string2) * 60 + Integer.parseInt(string)) * 60000;
            Date date = new Date(AlarmDialog.this.item.getDate().getTime() - l - (long)GWCalendarUtils.getZoneOffset());
            AlarmSet alarmSet = new AlarmSet(date, AlarmDialog.this.item.getDate(), AlarmDialog.this.tfLaunchProg.getText());
            String string3 = AlarmDialog.this.item.getID();
            AlarmOptions alarmOptions = null;
            try {
                alarmOptions = (AlarmOptions)AlarmManager.getInstance().get();
            }
            catch (GWCommandException gWCommandException) {
                logger.error((Object)gWCommandException, (Throwable)gWCommandException);
                alarmOptions = new AlarmOptions();
            }
            alarmOptions.putAlarmSet(string3, alarmSet);
            try {
                AlarmManager.getInstance().save(alarmOptions);
            }
            catch (GWCommandException gWCommandException) {
                logger.error((Object)gWCommandException);
                logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
            }
            Command command = new Command(340, AlarmDialog.this.item);
            AlarmDialog.this.getController().processCommand(command);
            GWDialog.disposeDialog(AlarmDialog.this);
        }
    }
}

