/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.folder.ActionDeleteFolder;
import com.novell.gw.jclient.application.actions.folder.ActionNewFolder;
import com.novell.gw.jclient.application.actions.folder.ActionRenameFolder;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.FoldersDialogController;
import com.novell.gw.jclient.application.controls.folderstree.EditableFoldersTree;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class FoldersDialog
extends GWDialog {
    private PlainFoldersTree treeFolders;
    private AbstractFolder folder;
    private String description;
    private AbstractAction actionNewFolder = new NewFolderAction();
    private AbstractAction actionDeleteFolder = new DeleteFolderAction();
    private AbstractAction actionRenameFolder = new RenameFolderAction();
    private AbstractAction actionMoveUPFolder = new MoveUPFolderAction();
    private AbstractAction actionMoveDownFolder = new MoveDownFolderAction();
    private AbstractAction actionMoveLeftFolder = new MoveLeftFolderAction();
    private AbstractAction actionMoveRightFolder = new MoveRightFolderAction();
    static /* synthetic */ Class class$com$appframework$ApplicationFrame;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public FoldersDialog(ApplicationFrame applicationFrame, AbstractFolder abstractFolder, String string) {
        super(applicationFrame, true);
        this.folder = abstractFolder;
        this.description = string;
        this.setController(new FoldersDialogController(this, applicationFrame.getAppActionList()));
        this.init();
    }

    public FoldersDialog(GWDialog gWDialog, AbstractFolder abstractFolder, String string) {
        super(gWDialog, true);
        this.folder = abstractFolder;
        this.description = string;
        this.setController(new FoldersDialogController(this, gWDialog.getController()));
        this.init();
    }

    private void init() {
        this.buildUI();
        if (this.folder != null) {
            this.enableActions(this.folder);
        }
        this.treeFolders.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null) {
                    AbstractFolder abstractFolder = (AbstractFolder)defaultMutableTreeNode.getUserObject();
                    FoldersDialog.this.folder = abstractFolder;
                    FoldersDialog.this.enableActions(abstractFolder);
                }
            }
        });
        if (this.folder == null) {
            this.btnOK.setEnabled(false);
        } else {
            this.treeFolders.scrollFolderToBottom(this.folder);
        }
    }

    private void enableActions(AbstractFolder abstractFolder) {
        this.actionNewFolder.setEnabled(abstractFolder.canHaveChildren());
        this.actionRenameFolder.setEnabled(abstractFolder.canRename());
        this.actionDeleteFolder.setEnabled(abstractFolder.canDelete());
        this.treeFolders.enableActions(this.folder, this.actionMoveUPFolder, this.actionMoveDownFolder, this.actionMoveRightFolder, this.actionMoveLeftFolder);
    }

    public AbstractFolder getSelectedFolder() {
        return this.treeFolders.getSelectedFolder();
    }

    protected void handleClose() {
        super.handleClose();
        this.treeFolders.clear();
    }

    private void buildUI() {
        this.setTitle(StringResources.FOLDERS);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.removeAll();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)new OrientableLabel(this.description), "North");
        jPanel.add((Component)this.buildButtonsPane(), "After");
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.add((Component)new OrientableLabel(StringResources.FOLDER_LIST_C), "North");
        String string = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(class$com$appframework$ApplicationFrame == null ? (class$com$appframework$ApplicationFrame = FoldersDialog.class$("com.appframework.ApplicationFrame")) : class$com$appframework$ApplicationFrame, this)).getUserGuid();
        this.treeFolders = new EditableFoldersTree(this.getController(), string);
        orientablePanel.add((Component)new OrientableScrollPane(this.treeFolders), "Center");
        if (this.folder != null) {
            this.treeFolders.selectFolder(this.folder);
        }
        jPanel.add((Component)orientablePanel, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private Container buildButtonsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel);
        orientablePanel.add(new JMnemonicButton(this.actionNewFolder));
        orientablePanel.add(new JMnemonicButton(this.actionRenameFolder));
        orientablePanel.add(new JMnemonicButton(this.actionDeleteFolder));
        orientablePanel.add(new JMnemonicButton(this.actionMoveUPFolder));
        orientablePanel.add(new JMnemonicButton(this.actionMoveDownFolder));
        orientablePanel.add(new JMnemonicButton(this.actionMoveRightFolder));
        orientablePanel.add(new JMnemonicButton(this.actionMoveLeftFolder));
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)orientablePanel, "North");
        return orientablePanel2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MoveLeftFolderAction
    extends AbstractAction {
        public MoveLeftFolderAction() {
            super(StringResources.MOVE_LEFT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FoldersDialog.this.treeFolders.moveLeftFolder(FoldersDialog.this.folder);
            FoldersDialog.this.enableActions(FoldersDialog.this.folder);
        }
    }

    private class MoveRightFolderAction
    extends AbstractAction {
        public MoveRightFolderAction() {
            super(StringResources.MOVE_RIGHT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FoldersDialog.this.treeFolders.moveRightFolder(FoldersDialog.this.folder);
            FoldersDialog.this.enableActions(FoldersDialog.this.folder);
        }
    }

    private class MoveDownFolderAction
    extends AbstractAction {
        public MoveDownFolderAction() {
            super(StringResources.MOVE_DOWN);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FoldersDialog.this.treeFolders.moveDownFolder(FoldersDialog.this.folder);
            FoldersDialog.this.enableActions(FoldersDialog.this.folder);
        }
    }

    private class MoveUPFolderAction
    extends AbstractAction {
        public MoveUPFolderAction() {
            super(StringResources.MOVE_UP);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FoldersDialog.this.treeFolders.moveUpFolder(FoldersDialog.this.folder);
            FoldersDialog.this.enableActions(FoldersDialog.this.folder);
        }
    }

    private class DeleteFolderAction
    extends AbstractAction {
        public DeleteFolderAction() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionDeleteFolder.doPerformAction(FoldersDialog.this.folder, FoldersDialog.this, ControlsUtils.getUserGuid(FoldersDialog.this.controller));
        }
    }

    private class RenameFolderAction
    extends AbstractAction {
        public RenameFolderAction() {
            super(StringResources.RENAME);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionRenameFolder.doPerformAction(FoldersDialog.this.folder, FoldersDialog.this);
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        public NewFolderAction() {
            super(StringResources.NEW);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = FoldersDialog.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, FoldersDialog.this);
            ActionNewFolder.doPerformAction(jFrame, FoldersDialog.this.folder);
        }
    }
}

