/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;

public class RadioButtonGroup
extends ButtonGroup {
    public RadioButtonGroup(Window window) {
        window.setFocusTraversalPolicy(new RBFTPolicy());
    }

    private void selectNextButton(AbstractButton abstractButton) {
        int n = this.buttons.indexOf(abstractButton);
        if (++n >= this.buttons.size()) {
            n = 0;
        }
        this.selectButtonAt(n);
    }

    private boolean selectButtonAt(int n) {
        AbstractButton abstractButton = (AbstractButton)this.buttons.get(n);
        if (abstractButton.isEnabled()) {
            abstractButton.setSelected(true);
            abstractButton.requestFocus();
            return true;
        }
        return false;
    }

    private void selectPrevButton(AbstractButton abstractButton) {
        int n = this.buttons.indexOf(abstractButton);
        if (--n < 0) {
            n = this.buttons.size() - 1;
        }
        this.selectButtonAt(n);
    }

    private AbstractButton getSelectedButton() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)this.buttons.get(i);
            if (!abstractButton.isSelected()) continue;
            return abstractButton;
        }
        return null;
    }

    public void add(AbstractButton abstractButton) {
        super.add(abstractButton);
        abstractButton.setFocusTraversalKeys(0, new HashSet());
        abstractButton.setFocusTraversalKeys(1, new HashSet());
        abstractButton.addKeyListener(new RBGKeyListener());
    }

    private class RBFTPolicy
    extends LayoutFocusTraversalPolicy {
        private RBFTPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            return this.findSelectedButton(container, super.getComponentAfter(container, component), true);
        }

        private Component findSelectedButton(Container container, Component component, boolean bl) {
            if (component instanceof JRadioButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                if (abstractButton.isSelected() && abstractButton.isEnabled()) {
                    return abstractButton;
                }
                Component component2 = bl ? super.getComponentAfter(container, component) : super.getComponentBefore(container, component);
                return this.findSelectedButton(container, component2, bl);
            }
            return component;
        }

        public Component getComponentBefore(Container container, Component component) {
            return this.findSelectedButton(container, super.getComponentBefore(container, component), false);
        }
    }

    private class RBGKeyListener
    extends KeyAdapter {
        private RBGKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Component component;
            AbstractButton abstractButton = (AbstractButton)keyEvent.getSource();
            if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 225) {
                RadioButtonGroup.this.selectNextButton(abstractButton);
            }
            if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 224) {
                RadioButtonGroup.this.selectPrevButton((AbstractButton)keyEvent.getSource());
            }
            if (KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()).equals(KeyStroke.getKeyStroke(9, 0))) {
                component = (Component)RadioButtonGroup.this.buttons.get(RadioButtonGroup.this.buttons.size() - 1);
                component.transferFocus();
            }
            if (KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()).equals(KeyStroke.getKeyStroke(9, 64))) {
                component = (JComponent)RadioButtonGroup.this.buttons.get(0);
                component.transferFocusBackward();
            }
        }
    }
}

