/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.ActionList;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.components.AbstractOKAction;
import com.appframework.mvc.LocalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialogActionList;
import com.novell.gw.jclient.application.controls.addressbook.list.RecipientsList;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable;
import com.novell.gw.jclient.application.controls.header.HeaderPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.standardgwitemtable.filter.ComponentWithMenu;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.SaveableDialog;
import com.novell.gw.jclient.application.frames.addressbook.FilterOffAction;
import com.novell.gw.jclient.application.frames.addressbook.GroupFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.OrganizationFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.ResourceFilterAction;
import com.novell.gw.jclient.application.frames.addressbook.UserFilterAction;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public abstract class AbstractAddressSelectorDialog
extends SaveableDialog {
    public static final int BUTTON_HEIGHT = 23;
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$controls$addressbook$AbstractAddressSelectorDialog == null ? (class$com$novell$gw$jclient$application$controls$addressbook$AbstractAddressSelectorDialog = AbstractAddressSelectorDialog.class$("com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog")) : class$com$novell$gw$jclient$application$controls$addressbook$AbstractAddressSelectorDialog));
    JTextField tfSearch = new OrientableTextField();
    JComboBox cbSearch;
    JComboBox cbDirectories = new OrientableComboBox();
    private JLabel lbFilter = new OrientableLabel(ImageResources.ICON_UNACTIVE_FILTER);
    RecipientsList listRecipients;
    AbstractAddressBookTable tableAddressList;
    AbstractAddressBook directory;
    JPanel pnlSaveGroup = new OrientablePanel(new FlowLayout(3));
    private JComponent btnSaveGroup;
    protected JPanel pnlRight = new OrientablePanel(new BorderLayout());
    static /* synthetic */ Class class$com$novell$gw$jclient$application$controls$addressbook$AbstractAddressSelectorDialog;

    AbstractAddressSelectorDialog(JFrame jFrame, MVCController mVCController) {
        super(jFrame);
        this.setController(new AddressSelectorDialogActionList(this, mVCController));
        this.init();
    }

    AbstractAddressSelectorDialog(JDialog jDialog, MVCController mVCController) {
        super(jDialog);
        this.setController(new AddressSelectorDialogActionList(this, mVCController));
        this.init();
    }

    void init() {
        this.setTitle(StringResources.ADDRESS_SELECTOR);
        ActionList actionList = this.getController().getActionList();
        this.btnSaveGroup = actionList.getAction("Save group").getToolBarComponent();
        actionList.getAction("Move To Recipients List").setMVCModel(new Integer(1));
        this.tfSearch.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (AbstractAddressSelectorDialog.this.tfSearch.getDocument().getLength() == 0) {
                        AbstractAddressSelectorDialog.this.btnOK.getAction().actionPerformed(null);
                    } else {
                        AbstractAddressSelectorDialog abstractAddressSelectorDialog = AbstractAddressSelectorDialog.this;
                        abstractAddressSelectorDialog.getController().getActionList().performAction("Move To Recipients List");
                        abstractAddressSelectorDialog.tfSearch.setText("");
                    }
                }
            }
        });
        actionList.addAction(new FilterOffAction(actionList, this.tableAddressList));
        actionList.addAction(new GroupFilterAction(actionList, this.tableAddressList));
        actionList.addAction(new OrganizationFilterAction(actionList, this.tableAddressList));
        actionList.addAction(new ResourceFilterAction(actionList, this.tableAddressList));
        actionList.addAction(new UserFilterAction(actionList, this.tableAddressList));
        this.buildUI();
        this.setData();
    }

    public void show() {
        this.tfSearch.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
            }

            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
            }
        });
        this.tfSearch.requestFocus();
        super.show();
    }

    protected abstract JPanel buildToggleButtons();

    void buildUI() {
        this.btnOK = new JButton(new OkAction());
        this.cbDirectories.addItemListener(new DirectoriesItemListener());
        this.cbDirectories.setRenderer(new DirectoriesRendererr());
        this.cbSearch = new OrientableComboBox(new String[]{StringResources.NAME});
        this.cbSearch.setEnabled(false);
        this.cbSearch.setPreferredSize(new Dimension((int)this.cbSearch.getPreferredSize().getWidth(), 23));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(UIUtils.getComponentOrientation());
        jPanel.setLayout(new BorderLayout(12, 0));
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(3));
        GWToolBar gWToolBar = new GWToolBar();
        gWToolBar.setBorder(null);
        gWToolBar.add(this.getController().getActionList().getAction("New Contact").getToolBarComponent());
        orientablePanel.add(gWToolBar);
        gWToolBar = new GWToolBar();
        gWToolBar.setBorder(null);
        gWToolBar.add(this.getController().getActionList().getAction("Directory Entry Details").getToolBarComponent());
        orientablePanel.add(gWToolBar);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)this.buildTableTopPane(), "North");
        orientablePanel2.add((Component)new ColoredScrollPane(this.tableAddressList), "Center");
        orientablePanel2.add((Component)orientablePanel, "South");
        jPanel.add((Component)orientablePanel2, "Center");
        orientablePanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel);
        jPanel.add((Component)orientablePanel, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    protected void handleClose() {
        super.handleClose();
        this.tableAddressList.dispose();
    }

    protected JPanel buildRightPane() {
        JPanel jPanel = this.buildToggleButtons();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.pnlRight.add((Component)jPanel, "North");
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.listRecipients);
        orientableScrollPane.setPreferredSize(new Dimension(200, (int)orientableScrollPane.getPreferredSize().getHeight()));
        this.pnlRight.add((Component)orientableScrollPane, "Center");
        this.pnlSaveGroup.add(this.btnSaveGroup);
        GWToolBar gWToolBar = new GWToolBar();
        gWToolBar.setBorder(null);
        gWToolBar.add(this.getController().getActionList().getAction("Remove from Recipients List").getToolBarComponent());
        this.pnlSaveGroup.add(gWToolBar);
        this.pnlRight.add((Component)this.pnlSaveGroup, "South");
        return this.pnlRight;
    }

    private JComponent buildTableTopPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 0;
        orientablePanel.add((Component)new OrientableLabel(StringResources.LOOK_IN_C), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 0;
        orientablePanel.add((Component)this.cbDirectories, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 5;
        orientablePanel.add((Component)new OrientableLabel(StringResources.LOOK_FOR_C), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 3;
        orientablePanel.add((Component)this.tfSearch, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 4;
        orientablePanel.add((Component)this.buildHeader(), gridBagConstraints);
        return orientablePanel;
    }

    private JComponent buildHeader() {
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.ADDRESS_LIST_C);
        orientableLabel.setForeground(Color.white);
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        orientablePanel.setBackground(HeaderPanel.DEFAULT_HEADER_BACKGROUND_COLOR);
        orientablePanel.add((Component)orientableLabel, "Before");
        orientablePanel.add((Component)new ComponentWithMenu(this.lbFilter, new FilterPopupMenu()), "After");
        return orientablePanel;
    }

    void removeSaveGroupButton() {
        this.pnlSaveGroup.remove(this.btnSaveGroup);
    }

    private void setData() {
        IDObjectsCollection iDObjectsCollection = EngineCommandManager.getDirectories();
        this.cbDirectories.setModel(new DefaultComboBoxModel<Object>(iDObjectsCollection.getData().toArray()));
        String string = OptionManager.getInstance().getGeneralOptions().getSelectedAddressSelectorBookID();
        AbstractAddressBook abstractAddressBook = (AbstractAddressBook)iDObjectsCollection.getIDObjectAt(0);
        if (string != null) {
            abstractAddressBook = (AbstractAddressBook)EngineCommandManager.getDirectories().getIDObject(string);
        }
        this.cbDirectories.setSelectedIndex(-1);
        this.cbDirectories.setSelectedItem(abstractAddressBook);
    }

    private void directoryChanged(AbstractAddressBook abstractAddressBook) {
        LocalCommand localCommand = new LocalCommand(360, abstractAddressBook, this.getController().getActionList());
        this.getController().processCommand(localCommand);
        GeneralOptions generalOptions = OptionManager.getInstance().getGeneralOptions();
        generalOptions.setSelectedAddressSelectorBookID(abstractAddressBook.getID());
        OptionManager.getInstance().setGeneralOptions(generalOptions);
    }

    void setCopyType(int n) {
        this.getController().getActionList().getAction("Move To Recipients List").setMVCModel(new Integer(n));
    }

    protected abstract void performOkAction();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class FilterPopupMenu
    extends JPopupMenu {
        ButtonGroup buttonGroup = new ButtonGroup();
        private ItemListener itemListener = new FilterItemListener();

        public FilterPopupMenu() {
            ActionList actionList = AbstractAddressSelectorDialog.this.getController().getActionList();
            OrientableRadioButtonMenuItem orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter Off"));
            orientableRadioButtonMenuItem.setText(StringResources.ALL_ENTRIES);
            orientableRadioButtonMenuItem.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
            this.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.setSelected(true);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter User"));
            orientableRadioButtonMenuItem.setText(StringResources.CONTACTS);
            orientableRadioButtonMenuItem.setIcon(ImageResources.ICON_ADDRESS_BOOK_USER);
            this.add(orientableRadioButtonMenuItem);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter Group"));
            orientableRadioButtonMenuItem.setText(StringResources.GROUPS);
            orientableRadioButtonMenuItem.setIcon(ImageResources.ICON_ADDRESS_BOOK_GROUP);
            this.add(orientableRadioButtonMenuItem);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
            orientableRadioButtonMenuItem = new OrientableRadioButtonMenuItem(actionList.getAction("AB Filter Resource"));
            orientableRadioButtonMenuItem.setText(StringResources.RESOURCES);
            orientableRadioButtonMenuItem.setIcon(ImageResources.ICON_ADDRESS_BOOK_RESOURSE);
            this.add(orientableRadioButtonMenuItem);
            this.buttonGroup.add(orientableRadioButtonMenuItem);
            orientableRadioButtonMenuItem.addItemListener(this.itemListener);
        }
    }

    private class FilterItemListener
    implements ItemListener {
        private FilterItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Action action = ((JMenuItem)itemEvent.getItem()).getAction();
                if (action instanceof FilterOffAction) {
                    AbstractAddressSelectorDialog.this.lbFilter.setIcon(ImageResources.ICON_UNACTIVE_FILTER);
                } else {
                    AbstractAddressSelectorDialog.this.lbFilter.setIcon(ImageResources.ICON_ACTIVE_FILTER);
                }
            }
        }
    }

    private class OkAction
    extends AbstractOKAction {
        private OkAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractAddressSelectorDialog.this.performOkAction();
            GWDialog.disposeDialog(AbstractAddressSelectorDialog.this);
        }
    }

    class DirectoriesRendererr
    extends OrientableLabel
    implements ListCellRenderer {
        public DirectoriesRendererr() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof AbstractAddressBook) {
                this.setIcon(ControlsUtils.getIconForAddressBook((AbstractAddressBook)object));
            }
            if (object != null) {
                this.setText(object.toString());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    class DirectoriesItemListener
    implements ItemListener {
        DirectoriesItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && itemEvent.getItem() instanceof AbstractAddressBook) {
                AbstractAddressSelectorDialog.this.directoryChanged((AbstractAddressBook)itemEvent.getItem());
            }
        }
    }
}

